/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.ByteSignature;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyECPrivateKey;
import anon.crypto.MyRSAPrivateKey;
import anon.util.ClassUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class AsymmetricCryptoKeyPair {
    public static final int KEY_LENGTH_512 = 512;
    public static final int KEY_LENGTH_1024 = 1024;
    private static final MyDSAPrivateKey dsaKey = null;
    private static final MyRSAPrivateKey rsaKey = null;
    private static final MyECPrivateKey ecKey = null;
    private static Vector ms_privateKeyClasses;
    private static Vector ms_publicKeyClasses;
    private IMyPrivateKey m_privateKey;
    private IMyPublicKey m_publicKey;
    static /* synthetic */ Class class$anon$crypto$IMyPrivateKey;
    static /* synthetic */ Class class$anon$crypto$MyDSAPrivateKey;
    static /* synthetic */ Class class$anon$crypto$MyRSAPrivateKey;
    static /* synthetic */ Class class$anon$crypto$IMyPublicKey;
    static /* synthetic */ Class class$anon$crypto$MyDSAPublicKey;
    static /* synthetic */ Class class$anon$crypto$MyRSAPublicKey;

    public AsymmetricCryptoKeyPair(IMyPrivateKey a_privateKey) {
        this.m_privateKey = a_privateKey;
        this.m_publicKey = a_privateKey.createPublicKey();
    }

    public AsymmetricCryptoKeyPair(PrivateKeyInfo a_keyInfo) throws InvalidKeyException {
        IMyPrivateKey privateKey;
        try {
            privateKey = (IMyPrivateKey)AsymmetricCryptoKeyPair.createAsymmetricCryptoKey(a_keyInfo, AsymmetricCryptoKeyPair.getPrivateKeyClasses());
        }
        catch (ClassCastException a_e) {
            throw new InvalidKeyException("The key that was created was no private key!");
        }
        this.m_privateKey = privateKey;
        this.m_publicKey = privateKey.createPublicKey();
    }

    public static final IMyPublicKey createPublicKey(SubjectPublicKeyInfo a_keyInfo) throws InvalidKeyException {
        IMyPublicKey publicKey;
        try {
            publicKey = (IMyPublicKey)AsymmetricCryptoKeyPair.createAsymmetricCryptoKey(a_keyInfo, AsymmetricCryptoKeyPair.getPublicKeyClasses());
        }
        catch (ClassCastException a_e) {
            throw new InvalidKeyException("The key that was created was no public key!");
        }
        return publicKey;
    }

    public final IMyPrivateKey getPrivate() {
        return this.m_privateKey;
    }

    public final IMyPublicKey getPublic() {
        return this.m_publicKey;
    }

    protected static final boolean isValidKeyPair(AsymmetricCryptoKeyPair a_keyPair) {
        if (a_keyPair == null) {
            return false;
        }
        Random random = new Random();
        random.setSeed(0L);
        byte[] message = new byte[1024];
        random.nextBytes(message);
        byte[] signature = ByteSignature.sign(message, a_keyPair);
        if (signature == null) {
            return false;
        }
        byte[] dummySignature = new byte[signature.length - 1];
        random.nextBytes(dummySignature);
        try {
            if (ByteSignature.verify(message, dummySignature, a_keyPair)) {
                return false;
            }
        }
        catch (Exception a_e) {
            // empty catch block
        }
        return ByteSignature.verify(message, signature, a_keyPair);
    }

    private static Key createAsymmetricCryptoKey(Object a_keyInfo, Enumeration a_keyClasses) throws InvalidKeyException {
        Key key = null;
        Class[] parameterTypes = new Class[1];
        Object[] parameters = new Object[1];
        parameterTypes[0] = a_keyInfo.getClass();
        parameters[0] = a_keyInfo;
        while (key == null && a_keyClasses.hasMoreElements()) {
            Class keyClass = (Class)a_keyClasses.nextElement();
            try {
                key = (Key)keyClass.getConstructor(parameterTypes).newInstance(parameters);
            }
            catch (Throwable a_e) {}
        }
        if (key == null) {
            throw new InvalidKeyException("No key available for this key info!");
        }
        return key;
    }

    private static Enumeration getPrivateKeyClasses() {
        if (ms_privateKeyClasses == null) {
            try {
                ms_privateKeyClasses = ClassUtil.findSubclasses(class$anon$crypto$IMyPrivateKey == null ? (class$anon$crypto$IMyPrivateKey = AsymmetricCryptoKeyPair.class$("anon.crypto.IMyPrivateKey")) : class$anon$crypto$IMyPrivateKey);
                ms_privateKeyClasses.removeElement(class$anon$crypto$IMyPrivateKey == null ? (class$anon$crypto$IMyPrivateKey = AsymmetricCryptoKeyPair.class$("anon.crypto.IMyPrivateKey")) : class$anon$crypto$IMyPrivateKey);
            }
            catch (Throwable a_e) {
                LogHolder.log(2, LogType.CRYPTO, a_e);
            }
            if (ms_privateKeyClasses == null) {
                ms_privateKeyClasses = new Vector();
            }
            if (ms_privateKeyClasses.size() < 2) {
                LogHolder.log(2, LogType.CRYPTO, "Private key classes have not been loaded automatically!");
                ms_privateKeyClasses.removeElement(class$anon$crypto$MyDSAPrivateKey == null ? (class$anon$crypto$MyDSAPrivateKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyDSAPrivateKey")) : class$anon$crypto$MyDSAPrivateKey);
                ms_privateKeyClasses.removeElement(class$anon$crypto$MyRSAPrivateKey == null ? (class$anon$crypto$MyRSAPrivateKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyRSAPrivateKey")) : class$anon$crypto$MyRSAPrivateKey);
                ms_privateKeyClasses.addElement(class$anon$crypto$MyDSAPrivateKey == null ? (class$anon$crypto$MyDSAPrivateKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyDSAPrivateKey")) : class$anon$crypto$MyDSAPrivateKey);
                ms_privateKeyClasses.addElement(class$anon$crypto$MyRSAPrivateKey == null ? (class$anon$crypto$MyRSAPrivateKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyRSAPrivateKey")) : class$anon$crypto$MyRSAPrivateKey);
            }
        }
        return ms_privateKeyClasses.elements();
    }

    private static Enumeration getPublicKeyClasses() {
        if (ms_publicKeyClasses == null) {
            try {
                ms_publicKeyClasses = ClassUtil.findSubclasses(class$anon$crypto$IMyPublicKey == null ? (class$anon$crypto$IMyPublicKey = AsymmetricCryptoKeyPair.class$("anon.crypto.IMyPublicKey")) : class$anon$crypto$IMyPublicKey);
                ms_publicKeyClasses.removeElement(class$anon$crypto$IMyPublicKey == null ? (class$anon$crypto$IMyPublicKey = AsymmetricCryptoKeyPair.class$("anon.crypto.IMyPublicKey")) : class$anon$crypto$IMyPublicKey);
            }
            catch (Throwable a_e) {
                LogHolder.log(2, LogType.CRYPTO, a_e);
            }
            if (ms_publicKeyClasses == null) {
                ms_publicKeyClasses = new Vector();
            }
            if (ms_publicKeyClasses.size() < 2) {
                int level = ClassUtil.isFindSubclassesEnabled() ? 2 : 5;
                LogHolder.log(level, LogType.CRYPTO, "Public key classes have not been loaded automatically.");
                ms_publicKeyClasses.removeElement(class$anon$crypto$MyDSAPublicKey == null ? (class$anon$crypto$MyDSAPublicKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyDSAPublicKey")) : class$anon$crypto$MyDSAPublicKey);
                ms_publicKeyClasses.removeElement(class$anon$crypto$MyRSAPublicKey == null ? (class$anon$crypto$MyRSAPublicKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyRSAPublicKey")) : class$anon$crypto$MyRSAPublicKey);
                ms_publicKeyClasses.addElement(class$anon$crypto$MyDSAPublicKey == null ? (class$anon$crypto$MyDSAPublicKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyDSAPublicKey")) : class$anon$crypto$MyDSAPublicKey);
                ms_publicKeyClasses.addElement(class$anon$crypto$MyRSAPublicKey == null ? (class$anon$crypto$MyRSAPublicKey = AsymmetricCryptoKeyPair.class$("anon.crypto.MyRSAPublicKey")) : class$anon$crypto$MyRSAPublicKey);
            }
        }
        return ms_publicKeyClasses.elements();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

