/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPath;
import anon.crypto.CertPathInfo;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.SignatureVerifier;
import anon.crypto.X509DistinguishedName;
import anon.util.IXMLEncodable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MultiCertPath
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "MultiCertPath";
    private CertPath[] m_certPaths;
    private X509DistinguishedName m_subject;
    private X509DistinguishedName m_issuer;
    private int m_documentType;

    protected MultiCertPath(CertPath[] a_certPaths, int a_documentType) {
        if (a_certPaths.length != 0 && a_certPaths[0] != null) {
            this.m_subject = a_certPaths[0].getFirstCertificate().getSubject();
            this.m_issuer = a_certPaths[0].getFirstCertificate().getIssuer();
            for (int i = 1; i < a_certPaths.length; ++i) {
                if (!this.m_subject.equals(a_certPaths[i].getFirstCertificate().getSubject())) {
                    throw new IllegalArgumentException("Wrong subject in MultiCertPath!");
                }
                if (this.m_issuer.equals(a_certPaths[i].getFirstCertificate().getIssuer())) continue;
                throw new IllegalArgumentException("Wrong issuer in MultiCertPath!");
            }
        }
        this.m_documentType = a_documentType;
        this.m_certPaths = a_certPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Date a_date) {
        if (!this.needsVerification()) {
            return true;
        }
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            boolean checkOnlyVerfied = this.getFirstVerifiedPath() != null;
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                if ((!checkOnlyVerfied || !this.m_certPaths[i].verify()) && checkOnlyVerfied || !this.m_certPaths[i].checkValidity(a_date)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private boolean needsVerification() {
        return SignatureVerifier.getInstance().isCheckSignatures(this.m_documentType);
    }

    public boolean isVerified() {
        if (!this.needsVerification()) {
            return true;
        }
        return this.getFirstVerifiedPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertPath getPath() {
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            CertPath path = this.getFirstVerifiedPath();
            if (path == null) {
                path = this.m_certPaths[0];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return path;
        }
    }

    public Vector getPaths() {
        Vector<CertPath> vecPaths = new Vector<CertPath>();
        for (int i = 0; i < this.m_certPaths.length; ++i) {
            vecPaths.addElement(this.m_certPaths[i]);
        }
        return vecPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertPath getFirstVerifiedPath() {
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                if (this.m_certPaths[i] == null || !this.m_certPaths[i].verify()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.m_certPaths[i];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEndEntityKeys() {
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            Vector<IMyPublicKey> keys = new Vector<IMyPublicKey>();
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                if (this.needsVerification() && !this.m_certPaths[i].verify()) continue;
                keys.addElement(this.m_certPaths[i].getFirstCertificate().getPublicKey());
            }
            if (keys.size() != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return keys;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public X509DistinguishedName getSubject() {
        return this.m_subject;
    }

    public X509DistinguishedName getIssuer() {
        return this.m_issuer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countPaths() {
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_certPaths.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countVerifiedPaths() {
        int count = 0;
        if (!this.needsVerification()) {
            return this.countPaths();
        }
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                if (!this.m_certPaths[i].verify()) continue;
                ++count;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countVerifiedAndValidPaths() {
        int count = 0;
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                if (this.needsVerification() && !this.m_certPaths[i].verify() || !this.m_certPaths[i].checkValidity(new Date())) continue;
                ++count;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxLength() {
        int maxLength = 0;
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                if (this.m_certPaths[i].length() <= maxLength) continue;
                maxLength = this.m_certPaths[i].length();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return maxLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertPathInfo[] getPathInfos() {
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            CertPathInfo[] infos = new CertPathInfo[this.m_certPaths.length];
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                infos[i] = this.m_certPaths[i].getPathInfo();
                if (this.needsVerification()) continue;
                infos[i].setVerified(-1);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        if (a_doc == null) {
            return null;
        }
        Element elemMultiCertPath = a_doc.createElement(XML_ELEMENT_NAME);
        CertPath[] certPathArray = this.m_certPaths;
        synchronized (this.m_certPaths) {
            for (int i = 0; i < this.m_certPaths.length; ++i) {
                Enumeration certificates = this.m_certPaths[i].getCertificates().elements();
                while (certificates.hasMoreElements()) {
                    elemMultiCertPath.appendChild(((JAPCertificate)certificates.nextElement()).toXmlElement(a_doc));
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return elemMultiCertPath;
        }
    }
}

