/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.IMySignature;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.MyRSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;

public final class MyRSASignature
implements IMySignature {
    private static final AlgorithmIdentifier ms_identifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"));
    private PKCS1Encoding m_SignatureAlgorithm = new PKCS1Encoding(new RSAEngine());
    private SHA1Digest m_Digest = new SHA1Digest();
    private static final AlgorithmIdentifier ms_AlgID = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, null);

    public synchronized void initVerify(IMyPublicKey k) throws InvalidKeyException {
        this.m_SignatureAlgorithm.init(false, ((MyRSAPublicKey)k).getParams());
    }

    public synchronized void initSign(IMyPrivateKey k) throws InvalidKeyException {
        this.m_SignatureAlgorithm.init(true, ((MyRSAPrivateKey)k).getParams());
    }

    public synchronized boolean verify(byte[] a_message, byte[] a_signature) {
        return this.verify(a_message, 0, a_message.length, a_signature, 0, a_signature.length);
    }

    public synchronized boolean verify(byte[] message, int message_offset, int message_len, byte[] sig, int signature_offset, int signature_len) {
        try {
            this.m_Digest.reset();
            this.m_Digest.update(message, message_offset, message_len);
            byte[] hash2 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.doFinal(hash2, 0);
            byte[] decryptedSig = this.m_SignatureAlgorithm.processBlock(sig, signature_offset, signature_len);
            ByteArrayInputStream bIn = new ByteArrayInputStream(decryptedSig);
            ASN1InputStream dIn = new ASN1InputStream(bIn);
            DigestInfo digInfo = new DigestInfo((ASN1Sequence)dIn.readObject());
            bIn.close();
            dIn.close();
            if (!digInfo.getAlgorithmId().getAlgorithm().equals(ms_AlgID.getAlgorithm())) {
                return false;
            }
            ASN1Encodable o = digInfo.getAlgorithmId().getParameters();
            if (o != null && !(o instanceof ASN1Null)) {
                return false;
            }
            byte[] sigHash = digInfo.getDigest();
            if (hash2.length != sigHash.length) {
                return false;
            }
            for (int i = 0; i < hash2.length; ++i) {
                if (sigHash[i] == hash2[i]) continue;
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            LogHolder.log(7, LogType.CRYPTO, "Signature algorithm does not match!");
            return false;
        }
    }

    public synchronized boolean verifyPlain(byte[] hash2, byte[] sig) {
        try {
            byte[] sigHash = this.m_SignatureAlgorithm.processBlock(sig, 0, sig.length);
            if (hash2.length != sigHash.length) {
                return false;
            }
            for (int i = 0; i < hash2.length; ++i) {
                if (sigHash[i] == hash2[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized byte[] sign(byte[] bytesToSign) {
        try {
            byte[] hash2 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.reset();
            this.m_Digest.update(bytesToSign, 0, bytesToSign.length);
            this.m_Digest.doFinal(hash2, 0);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            DigestInfo dInfo = new DigestInfo(ms_AlgID, hash2);
            dOut.writeObject(dInfo);
            byte[] bytes = bOut.toByteArray();
            return this.m_SignatureAlgorithm.processBlock(bytes, 0, bytes.length);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public synchronized byte[] signPlain(byte[] hash2) {
        try {
            return this.m_SignatureAlgorithm.processBlock(hash2, 0, hash2.length);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public AlgorithmIdentifier getIdentifier() {
        return ms_identifier;
    }

    public byte[] encodeForXMLSignature(byte[] a_signature) {
        return a_signature;
    }

    public byte[] decodeForXMLSignature(byte[] a_encodedSignature) {
        return a_encodedSignature;
    }

    public String getXMLSignatureAlgorithmReference() {
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }
}

