/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import anon.util.Util;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;

public final class MyX509Extensions {
    private ASN1ObjectIdentifier X509_EXTENSIONS_IDENTIFIER = new ASN1ObjectIdentifier("1.2.840.113549.1.9.14");
    private static final Vector KNOWN_CERTIFICATE_EXTENSIONS = new Vector();
    private static final Vector KNOWN_CRL_EXTENSIONS = new Vector();
    private static final Vector KNOWN_CRL_ENTRY_EXTENSIONS = new Vector();
    private ASN1Set m_extensions;
    private Vector m_vecExtensions;

    public MyX509Extensions(AbstractX509Extension a_extension) {
        this(Util.toVector(a_extension));
    }

    public MyX509Extensions(Vector a_extensions) {
        ASN1EncodableVector extensions = new ASN1EncodableVector();
        if (a_extensions == null) {
            a_extensions = new Vector();
        }
        this.m_vecExtensions = new Vector();
        for (int i = 0; i < a_extensions.size(); ++i) {
            if (!(a_extensions.elementAt(i) instanceof AbstractX509Extension)) {
                throw new IllegalArgumentException("X509 extension expected, but was: " + a_extensions.elementAt(i));
            }
            this.m_vecExtensions.addElement(a_extensions.elementAt(i));
            extensions.add(((AbstractX509Extension)a_extensions.elementAt(i)).getBCExtension());
        }
        ASN1EncodableVector extensionWrapper = new ASN1EncodableVector();
        extensionWrapper.add(this.X509_EXTENSIONS_IDENTIFIER);
        extensionWrapper.add(new DERSet(new DERSequence(extensions)));
        this.m_extensions = new DERSet(new DERSequence(extensionWrapper));
    }

    MyX509Extensions(ASN1Set a_extensions) {
        this.m_extensions = a_extensions;
        this.m_vecExtensions = new Vector();
        if (this.m_extensions.size() == 0) {
            return;
        }
        ASN1Sequence extensionWrapper = (ASN1Sequence)this.m_extensions.getObjectAt(0);
        ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)extensionWrapper.getObjectAt(0);
        if (!identifier.equals(this.X509_EXTENSIONS_IDENTIFIER)) {
            throw new IllegalArgumentException("Wrong identifier: " + identifier.getId());
        }
        extensionWrapper = (ASN1Sequence)((ASN1Set)extensionWrapper.getObjectAt(1)).getObjectAt(0);
        for (int i = 0; i < extensionWrapper.size(); ++i) {
            this.m_vecExtensions.addElement(AbstractX509Extension.getInstance(extensionWrapper.getObjectAt(i)));
        }
    }

    MyX509Extensions(Extensions a_extensions) {
        this(MyX509Extensions.createExtensionsFromX509Extensions(a_extensions));
    }

    public int getSize() {
        return this.m_vecExtensions.size();
    }

    public AbstractX509Extension getExtension(int a_index) {
        return (AbstractX509Extension)this.m_vecExtensions.elementAt(a_index);
    }

    public AbstractX509Extension getExtension(String a_identifier) {
        for (int i = 0; i < this.m_vecExtensions.size(); ++i) {
            AbstractX509Extension currentExtension = (AbstractX509Extension)this.m_vecExtensions.elementAt(i);
            if (!currentExtension.getIdentifier().equals(a_identifier)) continue;
            return currentExtension;
        }
        return null;
    }

    public Vector getExtensions(String a_identifier) {
        Vector<AbstractX509Extension> extensionsFound = new Vector<AbstractX509Extension>();
        for (int i = 0; i < this.m_vecExtensions.size(); ++i) {
            AbstractX509Extension currentExtension = (AbstractX509Extension)this.m_vecExtensions.elementAt(i);
            if (!currentExtension.getIdentifier().equals(a_identifier)) continue;
            extensionsFound.addElement(currentExtension);
        }
        return extensionsFound;
    }

    public Vector getExtensions() {
        return (Vector)this.m_vecExtensions.clone();
    }

    ASN1Set getExtensionsAsASN1Set() {
        return this.m_extensions;
    }

    Extensions getExtensionsAsBCExtensions() {
        if (this.m_extensions.size() == 0) {
            return null;
        }
        ASN1Sequence ds = (ASN1Sequence)this.m_extensions.getObjectAt(0);
        ASN1Set set = (ASN1Set)ds.getObjectAt(1);
        ASN1Sequence ds1 = (ASN1Sequence)set.getObjectAt(0);
        return Extensions.getInstance(ds1);
    }

    private static Vector createExtensionsFromX509Extensions(ASN1Object a_extensions) {
        Vector<AbstractX509Extension> vecExtensions = new Vector<AbstractX509Extension>();
        if (a_extensions == null) {
            return vecExtensions;
        }
        ASN1Sequence extensionWrapper = (ASN1Sequence)a_extensions.toASN1Primitive();
        for (int i = 0; i < extensionWrapper.size(); ++i) {
            ASN1Encodable asn1extension = extensionWrapper.getObjectAt(i);
            AbstractX509Extension extension = AbstractX509Extension.getInstance(asn1extension);
            vecExtensions.addElement(extension);
        }
        return vecExtensions;
    }

    protected boolean hasUnknownCriticalExtensions() {
        Enumeration extensions = this.m_vecExtensions.elements();
        while (extensions.hasMoreElements()) {
            AbstractX509Extension someExtension = (AbstractX509Extension)extensions.nextElement();
            String someIdentifier = someExtension.getIdentifier();
            if (!someExtension.isCritical() || KNOWN_CERTIFICATE_EXTENSIONS.contains(someIdentifier) || KNOWN_CRL_EXTENSIONS.contains(someIdentifier) || KNOWN_CRL_EXTENSIONS.contains(someIdentifier)) continue;
            return true;
        }
        return false;
    }

    static {
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(Extension.authorityKeyIdentifier.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(Extension.subjectKeyIdentifier.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(Extension.basicConstraints.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(Extension.keyUsage.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(Extension.issuerAlternativeName.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(Extension.subjectAlternativeName.toString());
        KNOWN_CRL_EXTENSIONS.addElement(Extension.authorityKeyIdentifier.toString());
        KNOWN_CRL_EXTENSIONS.addElement(Extension.issuerAlternativeName.toString());
        KNOWN_CRL_EXTENSIONS.addElement(Extension.issuingDistributionPoint.toString());
        KNOWN_CRL_ENTRY_EXTENSIONS.addElement(Extension.certificateIssuer.toString());
    }
}

