/*
 * Decompiled with CFR 0.152.
 */
package captcha;

import anon.util.Base64;
import anon.util.ZLibTools;
import captcha.ICaptchaGenerator;
import captcha.graphics.BinaryImageCreator;
import captcha.graphics.ImageFactory;
import captcha.graphics.PerspectiveProjection;
import captcha.graphics.Quadrangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Random;

public class ZipBinaryImageCaptchaGenerator
implements ICaptchaGenerator {
    private static final String DEFAULT_FONT = "SansSerif";
    private static final String VALID_TEXT_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String CAPTCHA_DATA_FORMAT = "ZIP_BINARY_IMAGE";
    private int m_width;
    private int m_height;

    public ZipBinaryImageCaptchaGenerator(int a_width, int a_height) {
        this.m_width = a_width;
        this.m_height = a_height;
    }

    @Override
    public String createCaptcha(String a_embeddedText) throws Exception {
        Image bitmap = this.generateCaptchaImage(a_embeddedText);
        byte[] binaryData = BinaryImageCreator.imageToBinary(bitmap);
        byte[] zippedData = ZLibTools.compress(binaryData);
        return Base64.encode(zippedData, false);
    }

    @Override
    public String getValidCharacters() {
        return VALID_TEXT_CHARACTERS;
    }

    @Override
    public String getCaptchaDataFormat() {
        return CAPTCHA_DATA_FORMAT;
    }

    @Override
    public int getMaximumStringLength() {
        return 8;
    }

    private Image generateCaptchaImage(String a_embeddedText) throws Exception {
        int h;
        int w;
        int y;
        int x;
        int i;
        int h2;
        int w2;
        int y2;
        int x2;
        int i2;
        Random random = new Random();
        Image bitmap = ImageFactory.createImage(this.m_width, this.m_height);
        Graphics g = bitmap.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.m_width, this.m_height);
        g.setColor(Color.darkGray);
        int fontSize = this.m_height + 1;
        Font font = null;
        int stringWidth = 0;
        do {
            font = new Font(DEFAULT_FONT, 1, --fontSize);
            g.setFont(font);
        } while (this.m_width < (stringWidth = g.getFontMetrics().stringWidth(a_embeddedText)));
        int stringPosX = (this.m_width - stringWidth) / 2;
        int stringPosY = (this.m_height + g.getFontMetrics().getHeight()) / 2 - 1 - g.getFontMetrics().getDescent();
        g.drawString(a_embeddedText, stringPosX, stringPosY);
        g.setColor(Color.white);
        float m = Math.max((float)this.m_width, (float)this.m_height);
        for (i2 = 0; i2 < this.m_width * this.m_height / 800; ++i2) {
            x2 = (int)Math.floor(random.nextDouble() * (double)this.m_width);
            y2 = (int)Math.floor(random.nextDouble() * (double)this.m_height);
            w2 = (int)Math.floor(random.nextFloat() * m / 20.0f);
            h2 = (int)Math.floor(random.nextFloat() * m / 20.0f);
            g.fillOval(x2, y2, w2, h2);
        }
        g.setColor(Color.darkGray);
        for (i2 = 0; i2 < this.m_width * this.m_height / 800; ++i2) {
            x2 = (int)Math.floor(random.nextFloat() * (float)this.m_width);
            y2 = (int)Math.floor(random.nextFloat() * (float)this.m_height);
            w2 = (int)Math.floor(random.nextFloat() * m / 20.0f);
            h2 = (int)Math.floor(random.nextFloat() * m / 20.0f);
            g.fillOval(x2, y2, w2, h2);
        }
        PerspectiveProjection transformMatrix = new PerspectiveProjection(new Quadrangle(0, 0, this.m_width - 1, 0, 0, this.m_height - 1, this.m_width - 1, this.m_height - 1), new Quadrangle((int)Math.floor(random.nextFloat() * (float)this.m_width / 4.0f), (int)Math.floor(random.nextFloat() * (float)this.m_height / 4.0f), this.m_width - 1 - (int)Math.floor(random.nextFloat() * (float)this.m_width / 4.0f), (int)Math.floor(random.nextFloat() * (float)this.m_height / 4.0f), (int)Math.floor(random.nextFloat() * (float)this.m_width / 4.0f), this.m_height - 1 - (int)Math.floor(random.nextFloat() * (float)this.m_height / 4.0f), this.m_width - 1 - (int)Math.floor(random.nextFloat() * (float)this.m_width / 4.0f), this.m_height - 1 - (int)Math.floor(random.nextFloat() * (float)this.m_height / 4.0f)));
        bitmap = transformMatrix.transform(bitmap, Color.white);
        g = bitmap.getGraphics();
        g.setColor(Color.white);
        for (i = 0; i < this.m_width * this.m_height / 800; ++i) {
            x = (int)Math.floor(random.nextFloat() * (float)this.m_width);
            y = (int)Math.floor(random.nextFloat() * (float)this.m_height);
            w = (int)Math.floor(random.nextFloat() * m / 20.0f);
            h = (int)Math.floor(random.nextFloat() * m / 20.0f);
            g.fillOval(x, y, w, h);
        }
        g.setColor(Color.darkGray);
        for (i = 0; i < this.m_width * this.m_height / 800; ++i) {
            x = (int)Math.floor(random.nextFloat() * (float)this.m_width);
            y = (int)Math.floor(random.nextFloat() * (float)this.m_height);
            w = (int)Math.floor(random.nextFloat() * m / 20.0f);
            h = (int)Math.floor(random.nextFloat() * m / 20.0f);
            g.fillOval(x, y, w, h);
        }
        return bitmap;
    }
}

