/*
 * Decompiled with CFR 0.152.
 */
package infoservice.japforwarding.captcha.test;

import anon.util.Base64;
import anon.util.ZLibTools;
import captcha.ZipBinaryImageCaptchaGenerator;
import infoservice.japforwarding.captcha.test.BinaryImageExtractor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TestZipBinaryImageCaptcha {
    private Random textRandom = new Random();
    private int wrongCaptchas = 0;
    private int correctCaptchas = 0;
    private JLabel wrongLabel;
    private JLabel correctLabel;
    private JLabel lastLabel;
    private JButton nextButton;
    private JPanel mainPanel = new JPanel();
    private JLabel captchaLabel;
    private JTextField codeField;
    private String lastString = this.getRandomString(8);
    private JLabel codeLabel;
    private JLabel sizeLabel;

    public TestZipBinaryImageCaptcha() throws Exception {
        String currentCaptcha = new ZipBinaryImageCaptchaGenerator(300, 100).createCaptcha(this.lastString);
        this.captchaLabel = new JLabel(new ImageIcon(BinaryImageExtractor.binaryToImage(ZLibTools.decompress(Base64.decode(currentCaptcha)))));
        this.sizeLabel = new JLabel("Base64-encoded-size: " + NumberFormat.getInstance().format(currentCaptcha.length()) + " Bytes");
        this.codeField = new JTextField(10);
        this.nextButton = new JButton("Next");
        this.lastLabel = new JLabel("Last Captcha-Code:");
        this.wrongLabel = new JLabel("Wrong: 0");
        this.correctLabel = new JLabel("Correct: 0");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (TestZipBinaryImageCaptcha.this.lastString.toLowerCase().equals(TestZipBinaryImageCaptcha.this.codeField.getText().trim().toLowerCase())) {
                        TestZipBinaryImageCaptcha.this.correctCaptchas++;
                    } else {
                        TestZipBinaryImageCaptcha.this.wrongCaptchas++;
                    }
                    TestZipBinaryImageCaptcha.this.lastLabel.setText("Last Captcha-Code: " + TestZipBinaryImageCaptcha.this.lastString);
                    TestZipBinaryImageCaptcha.this.lastString = TestZipBinaryImageCaptcha.this.getRandomString(8);
                    String currentCaptcha = new ZipBinaryImageCaptchaGenerator(300, 100).createCaptcha(TestZipBinaryImageCaptcha.this.lastString);
                    TestZipBinaryImageCaptcha.this.captchaLabel.setIcon(new ImageIcon(BinaryImageExtractor.binaryToImage(ZLibTools.decompress(Base64.decode(currentCaptcha)))));
                    TestZipBinaryImageCaptcha.this.sizeLabel.setText("Base64-encoded-size: " + NumberFormat.getInstance().format(currentCaptcha.length()) + " Bytes");
                    TestZipBinaryImageCaptcha.this.codeField.setText("");
                    TestZipBinaryImageCaptcha.this.correctLabel.setText("Correct: " + Integer.toString(TestZipBinaryImageCaptcha.this.correctCaptchas));
                    TestZipBinaryImageCaptcha.this.wrongLabel.setText("Wrong: " + Integer.toString(TestZipBinaryImageCaptcha.this.wrongCaptchas));
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
        });
        this.codeLabel = new JLabel("Captcha-Code:");
        GridBagLayout mainPanelLayout = new GridBagLayout();
        this.mainPanel.setLayout(mainPanelLayout);
        GridBagConstraints mainPanelConstraints = new GridBagConstraints();
        mainPanelConstraints.anchor = 18;
        mainPanelConstraints.fill = 0;
        mainPanelConstraints.weightx = 1.0;
        mainPanelConstraints.weighty = 0.0;
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 0;
        mainPanelConstraints.gridwidth = 3;
        mainPanelLayout.setConstraints(this.captchaLabel, mainPanelConstraints);
        this.mainPanel.add(this.captchaLabel);
        mainPanelConstraints.insets = new Insets(5, 0, 0, 0);
        mainPanelConstraints.fill = 2;
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 1;
        mainPanelLayout.setConstraints(this.sizeLabel, mainPanelConstraints);
        this.mainPanel.add(this.sizeLabel);
        mainPanelConstraints.insets = new Insets(20, 0, 0, 0);
        mainPanelConstraints.fill = 2;
        mainPanelConstraints.weightx = 0.0;
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 2;
        mainPanelConstraints.gridwidth = 1;
        mainPanelLayout.setConstraints(this.codeLabel, mainPanelConstraints);
        this.mainPanel.add(this.codeLabel);
        mainPanelConstraints.gridx = 1;
        mainPanelConstraints.gridy = 2;
        mainPanelConstraints.insets = new Insets(10, 10, 0, 0);
        mainPanelConstraints.weightx = 1.0;
        mainPanelLayout.setConstraints(this.codeField, mainPanelConstraints);
        this.mainPanel.add(this.codeField);
        mainPanelConstraints.gridx = 2;
        mainPanelConstraints.gridy = 2;
        mainPanelLayout.setConstraints(this.nextButton, mainPanelConstraints);
        this.mainPanel.add(this.nextButton);
        mainPanelConstraints.insets = new Insets(20, 0, 0, 0);
        mainPanelConstraints.weightx = 1.0;
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 3;
        mainPanelConstraints.gridwidth = 2;
        mainPanelLayout.setConstraints(this.correctLabel, mainPanelConstraints);
        this.mainPanel.add(this.correctLabel);
        mainPanelConstraints.insets = new Insets(20, 10, 0, 0);
        mainPanelConstraints.gridx = 2;
        mainPanelConstraints.gridy = 3;
        mainPanelConstraints.gridwidth = 1;
        mainPanelLayout.setConstraints(this.wrongLabel, mainPanelConstraints);
        this.mainPanel.add(this.wrongLabel);
        mainPanelConstraints.insets = new Insets(10, 0, 0, 0);
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 4;
        mainPanelConstraints.gridwidth = 3;
        mainPanelLayout.setConstraints(this.lastLabel, mainPanelConstraints);
        this.mainPanel.add(this.lastLabel);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getRandomString(int stringLength) {
        String randomString = "";
        while (stringLength > 0) {
            String charString = new ZipBinaryImageCaptchaGenerator(300, 100).getValidCharacters();
            int position = this.textRandom.nextInt(charString.length());
            randomString = randomString + charString.substring(position, position + 1);
            --stringLength;
        }
        return randomString;
    }

    public static void main(String[] args) {
        try {
            JFrame testFrame = new JFrame("CaptchaTest");
            TestZipBinaryImageCaptcha captchaTest = new TestZipBinaryImageCaptcha();
            testFrame.getContentPane().add(captchaTest.getMainPanel());
            testFrame.setLocation(300, 200);
            testFrame.pack();
            testFrame.setDefaultCloseOperation(2);
            testFrame.setVisible(true);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }
}

