/*
 * Decompiled with CFR 0.152.
 */
package logging;

public final class LogType {
    private static final String[] STR_LOG_TYPES = new String[]{"NUL", "GUI", "NET", "MISC", "PAY", "TOR", "CRYPTO", "FILTER", "AGREEMENT", "DB", "TRANSPORT", "FORWARDING", "ALL"};
    private static final String STR_ADD_LOG_TYPE = "+";
    private static final int[] LOG_TYPES = LogType.getAvailableLogTypes();
    public static final int NUL = LOG_TYPES[0];
    public static final int GUI = LOG_TYPES[1];
    public static final int NET = LOG_TYPES[2];
    public static final int MISC = LOG_TYPES[3];
    public static final int PAY = LOG_TYPES[4];
    public static final int TOR = LOG_TYPES[5];
    public static final int CRYPTO = LOG_TYPES[6];
    public static final int FILTER = LOG_TYPES[7];
    public static final int AGREEMENT = LOG_TYPES[8];
    public static final int DB = LOG_TYPES[9];
    public static final int TRANSPORT = LOG_TYPES[10];
    public static final int FORWARDING = LOG_TYPES[11];
    public static final int ALL = LogType.createLogTypeALL();

    private LogType() {
    }

    public static boolean isValidLogType(int a_logType) {
        return a_logType >= 0 && a_logType <= ALL;
    }

    public static int[] getAvailableLogTypes() {
        int[] logTypes = new int[STR_LOG_TYPES.length - 1];
        logTypes[0] = 0;
        int i = 1;
        int j = 1;
        while (i < logTypes.length) {
            logTypes[i] = j;
            j <<= 1;
            ++i;
        }
        return logTypes;
    }

    public static int getNumberOfLogTypes() {
        return STR_LOG_TYPES.length - 1;
    }

    public static String getLogTypeName(int a_logType) {
        String strLogTypeName = "";
        if (a_logType == 0) {
            strLogTypeName = STR_LOG_TYPES[0];
        } else if ((a_logType & ALL) == ALL) {
            strLogTypeName = STR_LOG_TYPES[STR_LOG_TYPES.length - 1];
        } else {
            int i = 1;
            while (i < LOG_TYPES.length) {
                if ((a_logType & LOG_TYPES[i]) > 0) {
                    strLogTypeName = strLogTypeName + STR_LOG_TYPES[i] + STR_ADD_LOG_TYPE;
                }
                ++i;
            }
            strLogTypeName = strLogTypeName.length() == 0 ? STR_LOG_TYPES[0] : strLogTypeName.substring(0, strLogTypeName.length() - STR_ADD_LOG_TYPE.length());
        }
        return strLogTypeName;
    }

    private static int createLogTypeALL() {
        int all = 0;
        int i = 0;
        while (i < LOG_TYPES.length) {
            all += LOG_TYPES[i];
            ++i;
        }
        return all;
    }
}

