/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.Cookie2;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.DefaultCookiePolicyHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientUtil;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CookieModule
implements HTTPClientModule,
GlobalConstants {
    private static Hashtable cookie_cntxt_list = new Hashtable();
    private static CookiePolicyHandler cookie_handler = new DefaultCookiePolicyHandler();

    CookieModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestHandler(Request req, Response[] resp) {
        req.setHeaders(HttpClientUtil.removeAllValues(req.getHeaders(), "Cookie"));
        Hashtable cookie_list = HttpClientUtil.getList(cookie_cntxt_list, req.getConnection().getContext());
        if (cookie_list.size() == 0) {
            return 0;
        }
        Vector<String> names = new Vector<String>();
        Vector<Integer> lens = new Vector<Integer>();
        boolean cookie2 = false;
        Hashtable hashtable = cookie_list;
        synchronized (hashtable) {
            Enumeration list = cookie_list.elements();
            Vector<Cookie> remove_list = null;
            while (list.hasMoreElements()) {
                int idx;
                Cookie cookie = (Cookie)list.nextElement();
                if (cookie.hasExpired()) {
                    if (remove_list == null) {
                        remove_list = new Vector<Cookie>();
                    }
                    remove_list.addElement(cookie);
                    continue;
                }
                if (!cookie.sendWith(req) || cookie_handler != null && !cookie_handler.sendCookie(cookie, req)) continue;
                int len = cookie.getPath().length();
                for (idx = 0; idx < lens.size() && (Integer)lens.elementAt(idx) >= len; ++idx) {
                }
                names.insertElementAt(cookie.toExternalForm(), idx);
                lens.insertElementAt(new Integer(len), idx);
                if (!(cookie instanceof Cookie2)) continue;
                cookie2 = true;
            }
            if (remove_list != null) {
                for (int idx = 0; idx < remove_list.size(); ++idx) {
                    cookie_list.remove(remove_list.elementAt(idx));
                }
            }
        }
        if (!names.isEmpty()) {
            int idx;
            StringBuffer value = new StringBuffer();
            if (cookie2) {
                value.append("$Version=\"1\"; ");
            }
            value.append((String)names.elementAt(0));
            for (int idx2 = 1; idx2 < names.size(); ++idx2) {
                value.append("; ");
                value.append((String)names.elementAt(idx2));
            }
            NVPair[] hdrs = req.getHeaders();
            hdrs = HttpClientUtil.resizeArray(hdrs, hdrs.length + 1);
            hdrs[hdrs.length - 1] = new NVPair("Cookie", value.toString());
            if (!cookie2 && (idx = HttpClientUtil.getIndex(hdrs, "Cookie2")) == hdrs.length) {
                hdrs = HttpClientUtil.addValue(hdrs, "Cookie2", "$Version=\"1\"");
            }
            req.setHeaders(hdrs);
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getHeader("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteHeader("Set-Cookie");
        resp.deleteHeader("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getTrailer("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteTrailer("Set-Cookie");
        resp.deleteTrailer("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCookie(String set_cookie, boolean cookie2, RoRequest req, Response resp) throws ProtocolException {
        Hashtable cookie_list;
        Cookie[] cookies = cookie2 ? Cookie2.parse(set_cookie, req) : Cookie.parse(set_cookie, req);
        Hashtable hashtable = cookie_list = HttpClientUtil.getList(cookie_cntxt_list, req.getConnection().getContext());
        synchronized (hashtable) {
            for (int idx = 0; idx < cookies.length; ++idx) {
                Cookie cookie = (Cookie)cookie_list.get(cookies[idx]);
                if (cookie != null && cookies[idx].hasExpired()) {
                    cookie_list.remove(cookie);
                    continue;
                }
                if (cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                cookie_list.put(cookies[idx], cookies[idx]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardAllCookies() {
        Hashtable hashtable = cookie_cntxt_list;
        synchronized (hashtable) {
            cookie_cntxt_list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardAllCookies(Object context) {
        Hashtable cookie_list;
        Hashtable hashtable = cookie_list = HttpClientUtil.getList(cookie_cntxt_list, context);
        synchronized (hashtable) {
            cookie_list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies() {
        Hashtable hashtable = cookie_cntxt_list;
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[]{};
            int idx = 0;
            Enumeration cntxt_list = cookie_cntxt_list.elements();
            while (cntxt_list.hasMoreElements()) {
                Hashtable cntxt;
                Hashtable hashtable2 = cntxt = (Hashtable)cntxt_list.nextElement();
                synchronized (hashtable2) {
                    cookies = HttpClientUtil.resizeArray(cookies, idx + cntxt.size());
                    Enumeration cookie_list = cntxt.elements();
                    while (cookie_list.hasMoreElements()) {
                        cookies[idx++] = (Cookie)cookie_list.nextElement();
                    }
                }
            }
            return cookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies(Object context) {
        Hashtable cookie_list;
        Hashtable hashtable = cookie_list = HttpClientUtil.getList(cookie_cntxt_list, context);
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[cookie_list.size()];
            int idx = 0;
            Enumeration enumer = cookie_list.elements();
            while (enumer.hasMoreElements()) {
                cookies[idx++] = (Cookie)enumer.nextElement();
            }
            return cookies;
        }
    }

    public static void addCookie(Cookie cookie) {
        Hashtable cookie_list = HttpClientUtil.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.put(cookie, cookie);
    }

    public static void addCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = HttpClientUtil.getList(cookie_cntxt_list, context);
        cookie_list.put(cookie, cookie);
    }

    public static void removeCookie(Cookie cookie) {
        Hashtable cookie_list = HttpClientUtil.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.remove(cookie);
    }

    public static void removeCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = HttpClientUtil.getList(cookie_cntxt_list, context);
        cookie_list.remove(cookie);
    }

    public static synchronized CookiePolicyHandler setCookiePolicyHandler(CookiePolicyHandler handler) {
        CookiePolicyHandler old = cookie_handler;
        cookie_handler = handler;
        return old;
    }
}

