/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPHelpContext;
import jap.AbstractJAPConfModule;
import jap.JAPConf;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class JAPConfModuleSystem
implements JAPHelpContext.IHelpContext {
    private JPanel m_rootPanel;
    private JPanel m_configurationCardsPanel;
    private JTree m_configurationTree;
    private Hashtable m_registratedModules = new Hashtable();
    private Hashtable m_treeNodesToSymbolicNames = new Hashtable();
    private Hashtable m_symbolicNamesToTreeNodes = new Hashtable();
    private Hashtable m_symbolicNamesToHelpContext = new Hashtable();
    private JAPHelpContext.IHelpContext m_currentHelpContext;

    public JAPConfModuleSystem() {
        this.m_configurationCardsPanel = new JPanel(new CardLayout());
        DefaultTreeModel configurationTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("root"));
        DefaultTreeCellRenderer configurationTreeRenderer = new DefaultTreeCellRenderer();
        configurationTreeRenderer.setClosedIcon(GUIUtils.loadImageIcon("arrow.gif", true));
        configurationTreeRenderer.setOpenIcon(GUIUtils.loadImageIcon("arrow90.gif", true));
        configurationTreeRenderer.setLeafIcon(null);
        DefaultTreeSelectionModel configurationTreeSelectionModel = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = 1L;

            public void setSelectionPath(TreePath a_treePath) {
                String symbolicName = (String)JAPConfModuleSystem.this.m_treeNodesToSymbolicNames.get(a_treePath.getLastPathComponent());
                if (symbolicName != null) {
                    super.setSelectionPath(a_treePath);
                }
            }
        };
        configurationTreeSelectionModel.setSelectionMode(1);
        this.m_configurationTree = new JTree(configurationTreeModel);
        this.m_configurationTree.setSelectionModel(configurationTreeSelectionModel);
        this.m_configurationTree.setRootVisible(false);
        this.m_configurationTree.setEditable(false);
        this.m_configurationTree.setCellRenderer(configurationTreeRenderer);
        this.m_configurationTree.setBorder(new CompoundBorder(LineBorder.createBlackLineBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.m_configurationTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent a_event) throws ExpandVetoException {
                throw new ExpandVetoException(a_event);
            }

            public void treeWillExpand(TreeExpansionEvent event) {
            }
        });
        this.m_configurationTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent a_event) {
                String symbolicName;
                if (a_event.isAddedPath() && (symbolicName = (String)JAPConfModuleSystem.this.m_treeNodesToSymbolicNames.get(a_event.getPath().getLastPathComponent())) != null) {
                    JAPConfModuleSystem.this.m_currentHelpContext = (JAPHelpContext.IHelpContext)JAPConfModuleSystem.this.m_symbolicNamesToHelpContext.get(symbolicName);
                    ((CardLayout)JAPConfModuleSystem.this.m_configurationCardsPanel.getLayout()).show(JAPConfModuleSystem.this.m_configurationCardsPanel, symbolicName);
                }
            }
        });
        this.m_rootPanel = new JPanel();
        GridBagLayout rootPanelLayout = new GridBagLayout();
        this.m_rootPanel.setLayout(rootPanelLayout);
        GridBagConstraints rootPanelConstraints = new GridBagConstraints();
        rootPanelConstraints.weightx = 0.0;
        rootPanelConstraints.weighty = 1.0;
        rootPanelConstraints.gridx = 0;
        rootPanelConstraints.gridy = 0;
        rootPanelConstraints.insets = new Insets(10, 10, 10, 10);
        rootPanelConstraints.anchor = 18;
        rootPanelConstraints.fill = 1;
        rootPanelLayout.setConstraints(this.m_configurationTree, rootPanelConstraints);
        this.m_rootPanel.add(this.m_configurationTree);
        rootPanelConstraints.weightx = 1.0;
        rootPanelConstraints.weighty = 1.0;
        rootPanelConstraints.gridx = 1;
        rootPanelConstraints.gridy = 0;
        rootPanelConstraints.insets = new Insets(10, 10, 10, 10);
        rootPanelConstraints.anchor = 18;
        rootPanelConstraints.fill = 1;
        rootPanelLayout.setConstraints(this.m_configurationCardsPanel, rootPanelConstraints);
        this.m_rootPanel.add(this.m_configurationCardsPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode addConfigurationModule(DefaultMutableTreeNode a_parentNode, AbstractJAPConfModule a_module, String a_symbolicName) {
        DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(a_module.getTabTitle());
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            a_parentNode.add(moduleNode);
            this.m_configurationCardsPanel.add((Component)a_module.getRootPanel(), a_symbolicName);
            this.m_registratedModules.put(moduleNode, a_module);
            this.m_treeNodesToSymbolicNames.put(moduleNode, a_symbolicName);
            this.m_symbolicNamesToTreeNodes.put(a_symbolicName, moduleNode);
            this.m_symbolicNamesToHelpContext.put(a_symbolicName, a_module);
        }
        return moduleNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode addComponent(DefaultMutableTreeNode a_parentNode, Component a_component, String a_nodeNameIdentifier, String a_symbolicName, final String a_helpContext) {
        DefaultMutableTreeNode componentNode = new DefaultMutableTreeNode(JAPMessages.getString(a_nodeNameIdentifier));
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            a_parentNode.add(componentNode);
            if (a_component != null) {
                this.m_configurationCardsPanel.add(a_component, a_symbolicName);
                this.m_treeNodesToSymbolicNames.put(componentNode, a_symbolicName);
                this.m_symbolicNamesToTreeNodes.put(a_symbolicName, componentNode);
                this.m_symbolicNamesToHelpContext.put(a_symbolicName, new JAPHelpContext.IHelpContext(){

                    public String getHelpContext() {
                        return a_helpContext;
                    }

                    public Component getHelpExtractionDisplayContext() {
                        return JAPConf.getInstance().getContentPane();
                    }
                });
            }
        }
        return componentNode;
    }

    public DefaultMutableTreeNode getConfigurationTreeRootNode() {
        return (DefaultMutableTreeNode)this.m_configurationTree.getModel().getRoot();
    }

    public JTree getConfigurationTree() {
        return this.m_configurationTree;
    }

    public String getHelpContext() {
        return this.m_currentHelpContext.getHelpContext();
    }

    public Component getHelpExtractionDisplayContext() {
        return JAPConf.getInstance().getContentPane();
    }

    public AbstractJAPConfModule getCurrentModule() {
        return null;
    }

    public JPanel getRootPanel() {
        return this.m_rootPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initObservers() {
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            Enumeration enumModules = this.m_registratedModules.elements();
            while (enumModules.hasMoreElements()) {
                ((AbstractJAPConfModule)enumModules.nextElement()).initObservers();
            }
        }
    }

    protected void revalidate() {
        this.m_configurationCardsPanel.revalidate();
        this.m_configurationTree.revalidate();
        this.m_rootPanel.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNode(String a_symbolicName) {
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            DefaultMutableTreeNode treeNodeToSelect = (DefaultMutableTreeNode)this.m_symbolicNamesToTreeNodes.get(a_symbolicName);
            if (treeNodeToSelect != null) {
                this.m_configurationTree.setSelectionPath(new TreePath(treeNodeToSelect.getPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOkPressedEvent() {
        boolean returnValue = true;
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            Enumeration confModules = this.m_registratedModules.elements();
            while (confModules.hasMoreElements()) {
                AbstractJAPConfModule confModule = (AbstractJAPConfModule)confModules.nextElement();
                if (confModule.okPressed()) continue;
                returnValue = false;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCancelPressedEvent() {
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            Enumeration confModules = this.m_registratedModules.elements();
            while (confModules.hasMoreElements()) {
                ((AbstractJAPConfModule)confModules.nextElement()).cancelPressed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResetToDefaultsPressedEvent() {
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            Enumeration confModules = this.m_registratedModules.elements();
            while (confModules.hasMoreElements()) {
                ((AbstractJAPConfModule)confModules.nextElement()).resetToDefaultsPressed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdateValuesEvent(boolean a_bSync) {
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            Enumeration confModules = this.m_registratedModules.elements();
            while (confModules.hasMoreElements()) {
                ((AbstractJAPConfModule)confModules.nextElement()).updateValues(a_bSync);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSavePoints() {
        JAPConfModuleSystem jAPConfModuleSystem = this;
        synchronized (jAPConfModuleSystem) {
            Enumeration confModules = this.m_registratedModules.elements();
            while (confModules.hasMoreElements()) {
                ((AbstractJAPConfModule)confModules.nextElement()).createSavePoint();
            }
        }
    }
}

