/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.util.JAPMessages;
import gui.JapCouponField;
import jap.gui.LinkRegistrator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PaymentInstancePanel
extends JPanel {
    private static final String MSG_BTN_DELETE = (class$jap$pay$PaymentInstancePanel == null ? (class$jap$pay$PaymentInstancePanel = PaymentInstancePanel.class$("jap.pay.PaymentInstancePanel")) : class$jap$pay$PaymentInstancePanel).getName() + ".btnDelete";
    private JapCouponField m_coupon1;
    private JapCouponField m_coupon2;
    private JapCouponField m_coupon3;
    private JapCouponField m_coupon4;
    private PaymentInstanceDBEntry m_paymentInstance;
    private JLabel m_lblHeadline;
    static /* synthetic */ Class class$jap$pay$PaymentInstancePanel;

    public PaymentInstancePanel(PaymentInstanceDBEntry a_paymentInstance, LinkRegistrator a_registrator) {
        this(a_paymentInstance, a_registrator, false);
    }

    public PaymentInstancePanel(PaymentInstanceDBEntry a_paymentInstance, LinkRegistrator a_registrator, boolean a_bHideCouponFields) {
        this.m_paymentInstance = a_paymentInstance;
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_lblHeadline = new JLabel(a_paymentInstance.getName());
        if (!a_bHideCouponFields) {
            JPanel couponPanel = new JPanel();
            this.m_coupon1 = new JapCouponField(true);
            couponPanel.add(this.m_coupon1);
            couponPanel.add(new JLabel("-"));
            this.m_coupon2 = new JapCouponField(false);
            this.m_coupon1.setNextCouponField(this.m_coupon2);
            couponPanel.add(this.m_coupon2);
            couponPanel.add(new JLabel("-"));
            this.m_coupon3 = new JapCouponField(false);
            this.m_coupon2.setNextCouponField(this.m_coupon3);
            couponPanel.add(this.m_coupon3);
            couponPanel.add(new JLabel("-"));
            this.m_coupon4 = new JapCouponField(false);
            this.m_coupon3.setNextCouponField(this.m_coupon4);
            couponPanel.add(this.m_coupon4);
            ++constraints.gridy;
            this.add((Component)couponPanel, constraints);
            JButton btnDelete = new JButton(JAPMessages.getString(MSG_BTN_DELETE));
            btnDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a_event) {
                    PaymentInstancePanel.this.clearCode();
                }
            });
            ++constraints.gridx;
            this.add((Component)btnDelete, constraints);
        }
        URL urlWebShop = null;
        String strAlternative = PayAccountsFile.MSG_DO_PREMIUM_PAYMENT;
        if (PayAccountsFile.getInstance().isNewUser()) {
            urlWebShop = a_paymentInstance.getFreeCodeURL();
        }
        if (urlWebShop != null) {
            a_registrator.addBrowserInstallationInfo(this, constraints, JAPMessages.getString(PayAccountsFile.MSG_GET_FREE_CODE), urlWebShop.toString(), false, 1);
            strAlternative = PayAccountsFile.MSG_DO_PREMIUM_PAYMENT_ALTERNATIVE;
        }
        if ((urlWebShop = a_paymentInstance.getWebshopURL()) == null) {
            a_registrator.addBrowserInstallationInfo(this, constraints, JAPMessages.getString(strAlternative), "CONF_PAYMENT", false, 2, a_paymentInstance.getId());
        } else {
            a_registrator.addBrowserInstallationInfo(this, constraints, JAPMessages.getString(strAlternative), urlWebShop.toString(), false, 1);
        }
    }

    public PaymentInstanceDBEntry getPaymentInstance() {
        return this.m_paymentInstance;
    }

    public String getCode() {
        if (this.m_coupon1 == null) {
            return null;
        }
        String code = this.m_coupon1.getText() + this.m_coupon2.getText() + this.m_coupon3.getText() + this.m_coupon4.getText();
        if (code.length() == 0) {
            return null;
        }
        return code;
    }

    public boolean isComplete() {
        String strCode = this.getCode();
        return strCode == null || PayAccount.checkCouponCode(strCode) != null;
    }

    public void setHeadlineVisible(boolean a_bVisible) {
        this.m_lblHeadline.setVisible(a_bVisible);
    }

    public void clearCode() {
        if (this.m_coupon1 == null) {
            return;
        }
        this.m_coupon1.setText("");
        this.m_coupon2.setText("");
        this.m_coupon3.setText("");
        this.m_coupon4.setText("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

