/*
 * Decompiled with CFR 0.152.
 */
package jondobrowsercommunicator;

import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import jondobrowsercommunicator.SocketServerThread;
import logging.LogHolder;
import logging.LogType;

public class SocketServer
extends Thread {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    static int serverPortNumber = 40012;
    static SocketServerThread socketConn = null;
    static SecureRandom secureRandom;
    static String secureKey;

    public static void createSecureKey() {
        secureRandom = new SecureRandom();
        secureRandom.setSeed(secureRandom.generateSeed(50));
        byte[] tokenBytes = new byte[50];
        secureRandom.nextBytes(tokenBytes);
        secureKey = SocketServer.bytesToHex(tokenBytes);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void startServer() {
        try {
            ServerSocket serverSocket = new ServerSocket(serverPortNumber);
            LogHolder.log(6, LogType.MISC, "Socket server running on PORT_NUMBER=40012");
            while (true) {
                try {
                    while (true) {
                        Socket socket = serverSocket.accept();
                        SocketServerThread thread = new SocketServerThread(socket);
                        thread.start();
                    }
                }
                catch (Exception e) {
                    LogHolder.log(4, LogType.MISC, "Accepting socket connection failed\r\n" + e.toString());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogHolder.log(4, LogType.MISC, "Socket server start failed\r\n" + e.toString());
            return;
        }
    }

    public synchronized void run() {
        SocketServer.createSecureKey();
        SocketServer.startServer();
    }

    public static boolean pushHelpUrl(String url) {
        if (socketConn != null) {
            SocketServerThread socketServerThread = socketConn;
            try {
                if (socketServerThread.isValidConnection) {
                    while (socketConn.getState() == Thread.State.TIMED_WAITING) {
                    }
                    LogHolder.log(6, LogType.MISC, "Sent URL to JonDoBrowser - " + url);
                    socketServerThread.setPushHelpUrlPending(url);
                    return true;
                }
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Sending URL to JonDoBrowser failed.");
            }
        }
        return false;
    }
}

