/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class JunkbusterModule
implements HTTPClientModule,
GlobalConstants {
    private static String bl_file;
    private static String[] bl_lines;
    private static String[] bl_hosts;
    private static int[] bl_ports;
    private static String[] bl_paths;
    private static boolean[] bl_block;
    private static boolean remove_from;
    private static boolean remove_ua;
    private static boolean remove_referer;

    public int requestHandler(Request req, Response[] resp) {
        String rule = JunkbusterModule.isBlocked(req);
        if (rule != null) {
            NVPair[] ct = new NVPair[]{new NVPair("Content-type", "text/plain")};
            byte[] msg = ("JunkbusterModule: this url was blocked by the rule '" + rule + "'").getBytes();
            resp[0] = new Response("HTTP/1.1", 403, "Forbidden", ct, msg, null, 0);
            if (GlobalConstants.DebugMods) {
                Util.logLine("JBM:   '" + req.getConnection() + req.getRequestURI() + "' blocked by " + "rule '" + rule + "'");
            }
            return 4;
        }
        NVPair[] hdrs = req.getHeaders();
        if (remove_from) {
            hdrs = Util.removeAllValues(hdrs, "From");
        }
        if (remove_ua) {
            hdrs = Util.removeAllValues(hdrs, "User-Agent");
        }
        if (remove_referer) {
            hdrs = Util.removeAllValues(hdrs, "Referer");
        }
        req.setHeaders(hdrs);
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException, ModuleException {
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    public static void removeFrom(boolean flag) {
        remove_from = flag;
    }

    public static void removeUserAgent(boolean flag) {
        remove_ua = flag;
    }

    public static void removeReferer(boolean flag) {
        remove_referer = flag;
    }

    private static String isBlocked(RoRequest req) {
        String host = req.getConnection().getHost();
        int port = req.getConnection().getPort();
        String path = Util.getPath(req.getRequestURI());
        boolean blocked = false;
        String rule = null;
        int idx = 0;
        while (idx < bl_hosts.length) {
            String bl_host = bl_hosts[idx];
            String bl_path = bl_paths[idx];
            int bl_port = bl_ports[idx];
            if ((bl_host == null || bl_host.equals(host) || bl_host.length() < host.length() && host.endsWith(bl_host) && host.charAt(host.length() - bl_host.length() - 1) == '.') && (bl_port == -1 || bl_port == port) && (bl_path == null || path.startsWith(bl_path))) {
                blocked = bl_block[idx];
                rule = bl_lines[idx];
            }
            ++idx;
        }
        return blocked ? rule : null;
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void readBlocklist(String file) {
        block16: {
            if (file == null) {
                return;
            }
            try {
                String line;
                BufferedReader blockfile = new BufferedReader(new FileReader(file));
                bl_lines = new String[100];
                bl_hosts = new String[100];
                bl_ports = new int[100];
                bl_paths = new String[100];
                bl_block = new boolean[100];
                int pos = 0;
                while ((line = blockfile.readLine()) != null) {
                    void var3_4;
                    int beg;
                    if (pos == bl_hosts.length) {
                        bl_lines = Util.resizeArray(bl_lines, pos + 100);
                        bl_hosts = Util.resizeArray(bl_hosts, pos + 100);
                        bl_ports = Util.resizeArray(bl_ports, pos + 100);
                        bl_paths = Util.resizeArray(bl_paths, pos + 100);
                        bl_block = Util.resizeArray(bl_block, pos + 100);
                    }
                    if ((beg = var3_4.indexOf(35)) != -1) {
                        line = var3_4.substring(0, beg);
                    }
                    if ((line = line.trim()).length() == 0) continue;
                    JunkbusterModule.bl_lines[pos] = line;
                    beg = 0;
                    if (line.charAt(0) == '~') {
                        JunkbusterModule.bl_block[pos] = false;
                        beg = 1;
                    } else {
                        JunkbusterModule.bl_block[pos] = true;
                    }
                    if (line.charAt(beg) != '/') {
                        int col;
                        int end = line.indexOf(47);
                        if (end == -1) {
                            end = line.length();
                        }
                        if ((col = line.indexOf(58)) > end) {
                            col = -1;
                        }
                        if (col != -1) {
                            if (col > beg) {
                                JunkbusterModule.bl_hosts[pos] = line.substring(beg, col);
                            }
                            JunkbusterModule.bl_ports[pos] = Integer.parseInt(line.substring(col + 1, end));
                        } else {
                            JunkbusterModule.bl_hosts[pos] = line.substring(beg, end);
                            JunkbusterModule.bl_ports[pos] = -1;
                        }
                        beg = end;
                    } else {
                        JunkbusterModule.bl_ports[pos] = -1;
                    }
                    if (beg < line.length()) {
                        JunkbusterModule.bl_paths[pos] = line.substring(beg);
                    }
                    ++pos;
                }
                bl_lines = Util.resizeArray(bl_lines, pos);
                bl_hosts = Util.resizeArray(bl_hosts, pos);
                bl_ports = Util.resizeArray(bl_ports, pos);
                bl_paths = Util.resizeArray(bl_paths, pos);
                bl_block = Util.resizeArray(bl_block, pos);
            }
            catch (Exception e) {
                bl_lines = new String[0];
                bl_hosts = new String[0];
                bl_ports = new int[0];
                bl_paths = new String[0];
                bl_block = new boolean[0];
                if (!GlobalConstants.DebugMods) break block16;
                Util.logLine("JBM:   Error reading `" + bl_file + "': " + e);
            }
        }
    }

    static {
        try {
            remove_from = Boolean.getBoolean("HTTPClient.junkbuster.remove_from");
        }
        catch (Exception e) {
            remove_from = false;
        }
        try {
            remove_ua = Boolean.getBoolean("HTTPClient.junkbuster.remove_useragent");
        }
        catch (Exception e) {
            remove_ua = false;
        }
        try {
            remove_referer = Boolean.getBoolean("HTTPClient.junkbuster.remove_referer");
        }
        catch (Exception e) {
            remove_referer = false;
        }
        try {
            bl_file = System.getProperty("HTTPClient.junkbuster.blockfile");
        }
        catch (Exception e) {
            bl_file = null;
        }
        if (GlobalConstants.DebugMods && bl_file != null) {
            Util.logLine("JBM:   reading blockfile " + bl_file);
        }
        JunkbusterModule.readBlocklist(bl_file);
    }
}

