/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private static final BitSet Separators = new BitSet(128);
    private static final BitSet TokenChar;
    private static final BitSet UnsafeChar;
    private static SimpleDateFormat http_format;
    static final char[] hex_map;
    private static final String nl;
    static /* synthetic */ Class class$HTTPClient$Util;

    private Util() {
    }

    static final Object[] resizeArray(Object[] src, int new_size) {
        Object[] tmp = new Object[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final NVPair[] resizeArray(NVPair[] src, int new_size) {
        NVPair[] tmp = new NVPair[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final AuthorizationInfo[] resizeArray(AuthorizationInfo[] src, int new_size) {
        AuthorizationInfo[] tmp = new AuthorizationInfo[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final Cookie[] resizeArray(Cookie[] src, int new_size) {
        Cookie[] tmp = new Cookie[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final String[] resizeArray(String[] src, int new_size) {
        String[] tmp = new String[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final boolean[] resizeArray(boolean[] src, int new_size) {
        boolean[] tmp = new boolean[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final byte[] resizeArray(byte[] src, int new_size) {
        byte[] tmp = new byte[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final char[] resizeArray(char[] src, int new_size) {
        char[] tmp = new char[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final int[] resizeArray(int[] src, int new_size) {
        int[] tmp = new int[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static String[] splitProperty(String prop) {
        if (prop == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(prop, "|");
        String[] list = new String[tok.countTokens()];
        int idx = 0;
        while (idx < list.length) {
            list[idx] = tok.nextToken().trim();
            ++idx;
        }
        return list;
    }

    static String[] splitList(String str, String sep) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(str, sep);
        String[] list = new String[tok.countTokens()];
        int idx = 0;
        while (idx < list.length) {
            list[idx] = tok.nextToken().trim();
            ++idx;
        }
        return list;
    }

    static final Hashtable getList(Hashtable cntxt_list, Object cntxt) {
        Hashtable list = (Hashtable)cntxt_list.get(cntxt);
        if (list == null) {
            Hashtable hashtable = cntxt_list;
            synchronized (hashtable) {
                list = (Hashtable)cntxt_list.get(cntxt);
                if (list == null) {
                    list = new Hashtable();
                    cntxt_list.put(cntxt, list);
                }
            }
        }
        return list;
    }

    static final int[] compile_search(byte[] search) {
        int[] cmp = new int[]{0, 1, 0, 1, 0, 1};
        int idx = 0;
        while (idx < search.length) {
            int end = idx + 1;
            while (end < search.length) {
                if (search[idx] == search[end]) break;
                ++end;
            }
            if (end < search.length) {
                if (end - idx > cmp[1]) {
                    cmp[4] = cmp[2];
                    cmp[5] = cmp[3];
                    cmp[2] = cmp[0];
                    cmp[3] = cmp[1];
                    cmp[0] = idx;
                    cmp[1] = end - idx;
                } else if (end - idx > cmp[3]) {
                    cmp[4] = cmp[2];
                    cmp[5] = cmp[3];
                    cmp[2] = idx;
                    cmp[3] = end - idx;
                } else if (end - idx > cmp[3]) {
                    cmp[4] = idx;
                    cmp[5] = end - idx;
                }
            }
            ++idx;
        }
        cmp[1] = cmp[1] + cmp[0];
        cmp[3] = cmp[3] + cmp[2];
        cmp[5] = cmp[5] + cmp[4];
        return cmp;
    }

    static final int findStr(byte[] search, int[] cmp, byte[] str, int beg, int end) {
        int c1f = cmp[0];
        int c1l = cmp[1];
        int d1 = c1l - c1f;
        int c2f = cmp[2];
        int c2l = cmp[3];
        int d2 = c2l - c2f;
        int c3f = cmp[4];
        int c3l = cmp[5];
        int d3 = c3l - c3f;
        while (beg + search.length <= end) {
            if (search[c1l] == str[beg + c1l]) {
                if (search[c1f] == str[beg + c1f]) {
                    boolean same = true;
                    int idx = 0;
                    while (idx < search.length) {
                        if (search[idx] != str[beg + idx]) {
                            same = false;
                            break;
                        }
                        ++idx;
                    }
                    if (same) break;
                }
                beg += d1;
                continue;
            }
            if (search[c2l] == str[beg + c2l]) {
                beg += d2;
                continue;
            }
            if (search[c3l] == str[beg + c3l]) {
                beg += d3;
                continue;
            }
            ++beg;
        }
        if (beg + search.length > end) {
            return -1;
        }
        return beg;
    }

    public static final String dequoteString(String str) {
        if (str.indexOf(92) == -1) {
            return str;
        }
        char[] buf = str.toCharArray();
        int pos = 0;
        int num_deq = 0;
        while (pos < buf.length) {
            if (buf[pos] == '\\' && pos + 1 < buf.length) {
                System.arraycopy(buf, pos + 1, buf, pos, buf.length - pos - 1);
                ++num_deq;
            }
            ++pos;
        }
        return new String(buf, 0, buf.length - num_deq);
    }

    public static final String quoteString(String str, String qlist) {
        char[] list = qlist.toCharArray();
        int idx = 0;
        while (idx < list.length) {
            if (str.indexOf(list[idx]) != -1) break;
            ++idx;
        }
        if (idx == list.length) {
            return str;
        }
        int len = str.length();
        char[] buf = new char[len * 2];
        str.getChars(0, len, buf, 0);
        int pos = 0;
        while (pos < len) {
            if (qlist.indexOf(buf[pos], 0) != -1) {
                if (len == buf.length) {
                    buf = Util.resizeArray(buf, len + str.length());
                }
                System.arraycopy(buf, pos, buf, pos + 1, len - pos);
                ++len;
                buf[pos++] = 92;
            }
            ++pos;
        }
        return new String(buf, 0, len);
    }

    public static final Vector parseHeader(String header) throws ParseException {
        return Util.parseHeader(header, true);
    }

    public static final Vector parseHeader(String header, boolean dequote) throws ParseException {
        if (header == null) {
            return null;
        }
        Vector<HttpHeaderElement> elems = new Vector<HttpHeaderElement>();
        boolean first = true;
        int beg = -1;
        int end = 0;
        int len = header.length();
        int[] abeg = new int[1];
        while (true) {
            String elem_value;
            if (!first) {
                beg = Util.skipSpace(header, end);
                if (beg == len) break;
                if (header.charAt(beg) != ',') {
                    throw new ParseException("Bad header format: '" + header + "'\nExpected \",\" at position " + beg);
                }
            }
            first = false;
            if ((beg = Util.skipSpace(header, beg + 1)) == len) break;
            char ch = header.charAt(beg);
            if (ch == ',') {
                end = beg;
                continue;
            }
            if (ch == '=' || ch == ';' || ch == '\"') {
                throw new ParseException("Bad header format: '" + header + "'\nEmpty element name at position " + beg);
            }
            end = beg + 1;
            while (end < len && !Character.isWhitespace(ch = header.charAt(end)) && ch != '=' && ch != ',' && ch != ';') {
                ++end;
            }
            String elem_name = header.substring(beg, end);
            beg = Util.skipSpace(header, end);
            if (beg < len && header.charAt(beg) == '=') {
                abeg[0] = beg + 1;
                elem_value = Util.parseValue(header, abeg, dequote);
                end = abeg[0];
            } else {
                elem_value = null;
                end = beg;
            }
            NVPair[] params = new NVPair[]{};
            while ((beg = Util.skipSpace(header, end)) != len && header.charAt(beg) == ';') {
                String param_value;
                if ((beg = Util.skipSpace(header, beg + 1)) == len || (ch = header.charAt(beg)) == ',') {
                    end = beg;
                    break;
                }
                if (ch == ';') {
                    end = beg;
                    continue;
                }
                if (ch == '=' || ch == '\"') {
                    throw new ParseException("Bad header format: '" + header + "'\nEmpty parameter name at position " + beg);
                }
                end = beg + 1;
                while (end < len && !Character.isWhitespace(ch = header.charAt(end)) && ch != '=' && ch != ',' && ch != ';') {
                    ++end;
                }
                String param_name = header.substring(beg, end);
                beg = Util.skipSpace(header, end);
                if (beg < len && header.charAt(beg) == '=') {
                    abeg[0] = beg + 1;
                    param_value = Util.parseValue(header, abeg, dequote);
                    end = abeg[0];
                } else {
                    param_value = null;
                    end = beg;
                }
                params = Util.resizeArray(params, params.length + 1);
                params[params.length - 1] = new NVPair(param_name, param_value);
            }
            elems.addElement(new HttpHeaderElement(elem_name, elem_value, params));
        }
        return elems;
    }

    private static String parseValue(char[] buf, int[] abeg, String header, boolean dequote) throws ParseException {
        String value;
        int beg;
        int end = beg = abeg[0];
        int len = buf.length;
        if ((beg = Util.skipSpace(buf, beg)) < len && buf[beg] == '\"') {
            end = ++beg;
            char[] deq_buf = null;
            int deq_pos = 0;
            int lst_pos = beg;
            while (end < len && buf[end] != '\"') {
                if (buf[end] == '\\') {
                    if (dequote) {
                        if (deq_buf == null) {
                            deq_buf = new char[buf.length];
                        }
                        System.arraycopy(buf, lst_pos, deq_buf, deq_pos, end - lst_pos);
                        deq_pos += end - lst_pos;
                        lst_pos = ++end;
                    } else {
                        ++end;
                    }
                }
                ++end;
            }
            if (end == len) {
                throw new ParseException("Bad header format: '" + header + "'\nClosing <\"> for quoted-string" + " starting at position " + (beg - 1) + " not found");
            }
            if (deq_buf != null) {
                System.arraycopy(buf, lst_pos, deq_buf, deq_pos, end - lst_pos);
                value = new String(deq_buf, 0, deq_pos += end - lst_pos);
            } else {
                value = new String(buf, beg, end - beg);
            }
        } else {
            end = beg;
            while (end < len && !Character.isWhitespace(buf[end]) && buf[end] != ',' && buf[end] != ';') {
                ++end;
            }
            value = new String(buf, beg, end - beg);
        }
        abeg[0] = ++end;
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private static String parseValue(String header, int[] abeg, boolean dequote) throws ParseException {
        String value;
        int beg;
        int end = beg = abeg[0];
        int len = header.length();
        if ((beg = Util.skipSpace(header, beg)) < len && header.charAt(beg) == '\"') {
            char ch;
            end = ++beg;
            char[] deq_buf = null;
            int deq_pos = 0;
            int lst_pos = beg;
            while (end < len && (ch = header.charAt(end)) != '\"') {
                void var7_9;
                if (var7_9 == 92) {
                    if (dequote) {
                        if (deq_buf == null) {
                            deq_buf = new char[len];
                        }
                        header.getChars(lst_pos, end, deq_buf, deq_pos);
                        deq_pos += end - lst_pos;
                        lst_pos = ++end;
                    } else {
                        ++end;
                    }
                }
                ++end;
            }
            if (end == len) {
                throw new ParseException("Bad header format: '" + header + "'\nClosing <\"> for quoted-string" + " starting at position " + (beg - 1) + " not found");
            }
            if (deq_buf != null) {
                header.getChars(lst_pos, end, deq_buf, deq_pos);
                value = new String(deq_buf, 0, deq_pos += end - lst_pos);
            } else {
                value = header.substring(beg, end);
            }
        } else {
            char ch;
            end = beg;
            while (end < len && !Character.isWhitespace(ch = header.charAt(end)) && ch != ',' && ch != ';') {
                ++end;
            }
            value = header.substring(beg, end);
        }
        abeg[0] = ++end;
        return value;
    }

    public static final boolean hasToken(String header, String token) throws ParseException {
        if (header == null) {
            return false;
        }
        return Util.parseHeader(header).contains(new HttpHeaderElement(token));
    }

    public static final HttpHeaderElement getElement(Vector header, String name) {
        int idx = header.indexOf(new HttpHeaderElement(name));
        if (idx == -1) {
            return null;
        }
        return (HttpHeaderElement)header.elementAt(idx);
    }

    public static final String getParameter(String param, String hdr) throws ParseException {
        NVPair[] params = ((HttpHeaderElement)Util.parseHeader(hdr).firstElement()).getParams();
        int idx = 0;
        while (idx < params.length) {
            if (params[idx].getName().equalsIgnoreCase(param)) {
                return params[idx].getValue();
            }
            ++idx;
        }
        return null;
    }

    public static final String assembleHeader(Vector pheader) {
        StringBuffer hdr = new StringBuffer(200);
        int len = pheader.size();
        int idx = 0;
        while (idx < len) {
            ((HttpHeaderElement)pheader.elementAt(idx)).appendTo(hdr);
            hdr.append(", ");
            ++idx;
        }
        hdr.setLength(hdr.length() - 2);
        return hdr.toString();
    }

    static final int skipSpace(String str, int pos) {
        int len = str.length();
        while (pos < len && Character.isWhitespace(str.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    static final int skipSpace(char[] str, int pos) {
        int len = str.length;
        while (pos < len && Character.isWhitespace(str[pos])) {
            ++pos;
        }
        return pos;
    }

    static final int findSpace(String str, int pos) {
        int len = str.length();
        while (pos < len && !Character.isWhitespace(str.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    static final int findSpace(char[] str, int pos) {
        int len = str.length;
        while (pos < len && !Character.isWhitespace(str[pos])) {
            ++pos;
        }
        return pos;
    }

    static final int skipToken(char[] str, int pos) {
        int len = str.length;
        while (pos < len && TokenChar.get(str[pos])) {
            ++pos;
        }
        return pos;
    }

    static final boolean needsQuoting(String str) {
        int len = str.length();
        int pos = 0;
        while (pos < len && TokenChar.get(str.charAt(pos))) {
            ++pos;
        }
        return pos < len;
    }

    public static final String getValue(NVPair[] list, String key) {
        int len = list.length;
        int idx = 0;
        while (idx < len) {
            if (list[idx].getName().equalsIgnoreCase(key)) {
                return list[idx].getValue();
            }
            ++idx;
        }
        return null;
    }

    public static final int getIndex(NVPair[] list, String key) {
        int len = list.length;
        int idx = 0;
        while (idx < len) {
            if (list[idx].getName().equalsIgnoreCase(key)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static final NVPair[] setValue(NVPair[] list, String key, String val) {
        int idx = Util.getIndex(list, key);
        if (idx == -1) {
            idx = list.length;
            list = Util.resizeArray(list, list.length + 1);
        }
        list[idx] = new NVPair(key, val);
        return list;
    }

    public static final NVPair[] setValue(NVPair[] list, String key, String val, boolean a_quoteValue) {
        int idx = Util.getIndex(list, key);
        if (idx == -1) {
            idx = list.length;
            list = Util.resizeArray(list, list.length + 1);
        }
        list[idx] = new NVPair(key, val, a_quoteValue);
        return list;
    }

    public static final void updateValue(NVPair[] list, String key, String val) {
        int idx = Util.getIndex(list, key);
        if (idx != -1) {
            list[idx] = new NVPair(key, val);
        }
    }

    public static final NVPair[] addValue(NVPair[] list, String key, String val) {
        int idx = list.length;
        list = Util.resizeArray(list, list.length + 1);
        list[idx] = new NVPair(key, val);
        return list;
    }

    public static final NVPair[] removeAllValues(NVPair[] list, String key) {
        int length = list.length;
        int idx = 0;
        while (idx < list.length) {
            int beg = idx;
            while (idx < list.length && list[idx].getName().equalsIgnoreCase(key)) {
                ++idx;
            }
            if (idx - beg > 0) {
                System.arraycopy(list, idx, list, beg, (length -= idx - beg) - beg);
            }
            ++idx;
        }
        if (length < list.length) {
            list = Util.resizeArray(list, length);
        }
        return list;
    }

    public static final NVPair[] addToken(NVPair[] list, String hdr, String tok) throws ParseException {
        int idx = Util.getIndex(list, hdr);
        if (idx == -1) {
            return Util.addValue(list, hdr, tok);
        }
        if (!Util.hasToken(list[idx].getValue(), tok)) {
            list[idx] = new NVPair(hdr, list[idx].getValue() + ", " + tok);
        }
        return list;
    }

    public static final NVPair[] removeToken(NVPair[] list, String hdr, String tok) throws ParseException {
        int idx = Util.getIndex(list, hdr);
        if (idx == -1) {
            return list;
        }
        Vector p_list = Util.parseHeader(list[idx].getValue());
        if (!p_list.removeElement(new HttpHeaderElement(tok))) {
            return list;
        }
        if (p_list.isEmpty()) {
            System.arraycopy(list, idx + 1, list, idx, list.length - idx - 1);
            list = Util.resizeArray(list, list.length - 1);
        } else {
            list[idx] = new NVPair(hdr, Util.assembleHeader(p_list));
        }
        return list;
    }

    public static final boolean sameHttpURL(URL url1, URL url2) {
        if (!url1.getProtocol().equalsIgnoreCase(url2.getProtocol())) {
            return false;
        }
        if (!url1.getHost().equalsIgnoreCase(url2.getHost())) {
            return false;
        }
        int port1 = url1.getPort();
        int port2 = url2.getPort();
        if (port1 == -1) {
            port1 = URI.defaultPort(url1.getProtocol());
        }
        if (port2 == -1) {
            port2 = URI.defaultPort(url1.getProtocol());
        }
        if (port1 != port2) {
            return false;
        }
        try {
            return URI.unescape(url1.getFile()).equals(URI.unescape(url2.getFile()));
        }
        catch (ParseException pe) {
            return url1.getFile().equals(url2.getFile());
        }
    }

    public static final String httpDate(Date date) {
        if (http_format == null) {
            Class clazz = class$HTTPClient$Util == null ? (class$HTTPClient$Util = Util.class$("HTTPClient.Util")) : class$HTTPClient$Util;
            synchronized (clazz) {
                if (http_format == null) {
                    http_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                    http_format.setTimeZone(new SimpleTimeZone(0, "GMT"));
                }
            }
        }
        return http_format.format(date);
    }

    static final String escapeUnsafeChars(String path) {
        int len = path.length();
        char[] buf = new char[3 * len];
        int dst = 0;
        int src = 0;
        while (src < len) {
            char ch = path.charAt(src);
            if (ch >= '\u0080' || UnsafeChar.get(ch)) {
                buf[dst++] = 37;
                buf[dst++] = hex_map[(ch & 0xF0) >>> 4];
                buf[dst++] = hex_map[ch & 0xF];
            } else {
                buf[dst++] = ch;
            }
            ++src;
        }
        if (dst > len) {
            return new String(buf, 0, dst);
        }
        return path;
    }

    public static final String getPath(String resource) {
        int end = resource.length();
        int p = resource.indexOf(35);
        if (p != -1) {
            end = p;
        }
        if ((p = resource.indexOf(63)) != -1 && p < end) {
            end = p;
        }
        return resource.substring(0, end);
    }

    public static final String getQuery(String resource) {
        int end = resource.length();
        int p = resource.indexOf(35);
        if (p != -1) {
            end = p;
        }
        if ((p = resource.indexOf(63)) != -1 && p < end) {
            return resource.substring(p + 1, end);
        }
        return null;
    }

    public static final String getFragment(String resource) {
        int beg = resource.indexOf(35);
        if (beg != -1) {
            return resource.substring(beg + 1);
        }
        return null;
    }

    static final void logLine(String str) {
        System.err.print(str + " (" + Thread.currentThread() + ")" + nl);
        System.err.flush();
    }

    static final void logLine() {
        System.err.println();
        System.err.flush();
    }

    static final void logMessage(String str) {
        System.err.print(str);
        System.err.flush();
    }

    static final void logStackTrace(Throwable t) {
        t.printStackTrace(System.err);
        System.err.flush();
    }

    public static void getBytes(String str, byte[] to, int toOffset) {
        byte[] tmp = str.getBytes();
        System.arraycopy(tmp, 0, to, toOffset, tmp.length);
    }

    public static void getBytes(String str, int len, byte[] to, int toOffset) {
        byte[] tmp = str.getBytes();
        System.arraycopy(tmp, 0, to, toOffset, len);
    }

    public static Date parseDate(String raw_date) throws IllegalArgumentException {
        try {
            return DateFormat.getDateTimeInstance().parse(raw_date);
        }
        catch (java.text.ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Separators.set(40);
        Separators.set(41);
        Separators.set(60);
        Separators.set(62);
        Separators.set(64);
        Separators.set(44);
        Separators.set(59);
        Separators.set(58);
        Separators.set(92);
        Separators.set(34);
        Separators.set(47);
        Separators.set(91);
        Separators.set(93);
        Separators.set(63);
        Separators.set(61);
        Separators.set(123);
        Separators.set(125);
        Separators.set(32);
        Separators.set(9);
        TokenChar = new BitSet(128);
        int ch = 32;
        while (ch < 127) {
            TokenChar.set(ch);
            ++ch;
        }
        TokenChar.xor(Separators);
        UnsafeChar = new BitSet(128);
        int ch2 = 0;
        while (ch2 < 32) {
            UnsafeChar.set(ch2);
            ++ch2;
        }
        UnsafeChar.set(32);
        UnsafeChar.set(60);
        UnsafeChar.set(62);
        UnsafeChar.set(34);
        UnsafeChar.set(123);
        UnsafeChar.set(125);
        UnsafeChar.set(124);
        UnsafeChar.set(92);
        UnsafeChar.set(94);
        UnsafeChar.set(126);
        UnsafeChar.set(91);
        UnsafeChar.set(93);
        UnsafeChar.set(96);
        UnsafeChar.set(127);
        hex_map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        nl = System.getProperty("line.separator");
    }
}

