/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Constants;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PerformanceEntry
extends AbstractDatabaseEntry
implements IXMLEncodable {
    public static final long WEEK_SEVEN_DAYS_TIMEOUT = 604800000L;
    public static final long ONE_DAY_TIMEOUT = 86400000L;
    private static final double BOUND_ROUNDING = 0.1;
    public static final String XML_ELEMENT_CONTAINER_NAME = "PerformanceInfo";
    public static final String XML_ELEMENT_NAME = "PerformanceEntry";
    private static final String XML_ELEMENT_DATA = "Data";
    private static final String XML_ATTR_ID = "id";
    public static final long LAST_TEST_DATA_TTL = 1200000L;
    private static final int PERFORMANCE_ENTRY_TTL = 3600000;
    public static final int SPEED = 0;
    public static final int DELAY = 1;
    public static final int USERS = 2;
    public static final int PACKETS = 3;
    private static final String[] ATTRIBUTES = new String[]{"Speed", "Delay", "Users", "Packets"};
    public static final int[][] BOUNDARIES = new int[][]{{0, 30, 40, 50, 100, 200, 300, 400, 500, 600, 700, 800}, {500, 750, 1000, 2000, 2500, 3000, 4000, 8000, Integer.MAX_VALUE}, {0}, {0}};
    private String m_strCascadeId;
    private Calendar m_current = Calendar.getInstance();
    private long m_lastUpdate;
    private long m_serial;
    private boolean m_bPassive;
    private long m_lastTestTime;
    private StabilityAttributes m_stabilityAttributes;
    private PerformanceAttributeEntry[][][] m_entries = new PerformanceAttributeEntry[ATTRIBUTES.length][8][24];
    private PerformanceAttributeFloatingTimeEntry[] m_floatingTimeEntries;
    private int[] m_lastTestAverage = new int[4];
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    public PerformanceEntry(String a_strCascadeId) {
        this(a_strCascadeId, false);
    }

    public PerformanceEntry(String a_strCascadeId, boolean a_bPassive) {
        super(Long.MAX_VALUE);
        this.m_strCascadeId = a_strCascadeId;
        this.m_lastUpdate = System.currentTimeMillis();
        this.m_serial = System.currentTimeMillis();
        this.m_bPassive = a_bPassive;
        this.m_floatingTimeEntries = new PerformanceAttributeFloatingTimeEntry[]{new PerformanceAttributeFloatingTimeEntry(0, !a_bPassive), new PerformanceAttributeFloatingTimeEntry(1, !a_bPassive), new PerformanceAttributeFloatingTimeEntry(2, !a_bPassive), new PerformanceAttributeFloatingTimeEntry(3, !a_bPassive)};
    }

    public PerformanceEntry(Element a_entry) throws XMLParseException {
        super(System.currentTimeMillis() + 3600000L);
        this.m_floatingTimeEntries = new PerformanceAttributeFloatingTimeEntry[ATTRIBUTES.length];
        XMLUtil.assertNodeName(a_entry, XML_ELEMENT_NAME);
        this.m_strCascadeId = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_ID, "");
        if (this.m_strCascadeId == "") {
            throw new XMLParseException("PerformanceEntry: invalid id");
        }
        Node elemCurrentData = XMLUtil.getFirstChildByName(a_entry, XML_ELEMENT_DATA);
        if (elemCurrentData == null) {
            throw new XMLParseException("PerformanceEntry: Could not find node Data");
        }
        this.m_current.setTime(new Date(System.currentTimeMillis()));
        Node elemDelay = XMLUtil.getFirstChildByName(elemCurrentData, ATTRIBUTES[1]);
        this.m_floatingTimeEntries[1] = new PerformanceAttributeFloatingTimeEntry(1, elemDelay);
        Node elemSpeed = XMLUtil.getFirstChildByName(elemCurrentData, ATTRIBUTES[0]);
        this.m_floatingTimeEntries[0] = new PerformanceAttributeFloatingTimeEntry(0, elemSpeed);
        Node elemStability = XMLUtil.getFirstChildByName(elemCurrentData, "Stability");
        this.m_stabilityAttributes = elemStability != null ? new StabilityAttributes((Element)elemStability) : new StabilityAttributes(0, 0, 0, 0);
        this.m_lastUpdate = System.currentTimeMillis();
        this.m_serial = System.currentTimeMillis();
    }

    public String getId() {
        return this.m_strCascadeId;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.m_serial;
    }

    public long getLastTestTime() {
        return this.m_lastTestTime;
    }

    public PerformanceAttributeEntry importValue(int a_attribute, long a_timestamp, int a_value) {
        return this.addPerformanceAttributeEntry(a_attribute, a_timestamp, a_value, true);
    }

    public PerformanceEntry update(PerformanceEntry a_entry) {
        boolean bUpdated = false;
        if (!this.m_bPassive) {
            return null;
        }
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            this.setBound(i, a_entry.getBound(i));
            this.setBestBound(i, a_entry.getBestBound(i));
            if ((i != 1 || this.getBound(i).getBound() <= 0) && (i == 1 || this.getBound(i).getBound() < 0)) continue;
            bUpdated = true;
        }
        this.setStabilityAttributes(a_entry.getStabilityAttributes());
        if (bUpdated) {
            this.m_lastUpdate = System.currentTimeMillis();
        }
        return this;
    }

    public Vector updateHourlyPerformanceAttributeEntries(long a_timestamp) {
        if (!this.m_bPassive) {
            return null;
        }
        Vector<PerformanceAttributeEntry> entries = new Vector<PerformanceAttributeEntry>();
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            int bound = this.getBound(i).getNotRecoveredBound();
            if (i == 0 && bound == Integer.MAX_VALUE) {
                bound = -1;
            } else if (i == 1 && bound == 0) {
                bound = -1;
            }
            PerformanceAttributeEntry entry = this.addPerformanceAttributeEntry(i, a_timestamp, bound, false);
            if (entry == null) continue;
            entries.addElement(entry);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceAttributeEntry addPerformanceAttributeEntry(int a_attribute, long a_timestamp, int a_value, boolean a_bImport) {
        PerformanceAttributeEntry[][][] performanceAttributeEntryArray = this.m_entries;
        synchronized (this.m_entries) {
            PerformanceAttributeEntry entry = null;
            if (System.currentTimeMillis() - a_timestamp >= 604800000L) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return null;
            }
            if (a_timestamp > System.currentTimeMillis()) {
                LogHolder.log(4, LogType.MISC, "Performance timestamp has future value and is ignored: " + a_timestamp + " , current: " + System.currentTimeMillis());
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(a_timestamp));
            int day = cal.get(7);
            int hour = cal.get(11);
            if (this.m_bPassive) {
                if (hour > 0) {
                    --hour;
                } else if (day == 1) {
                    day = 7;
                    hour = 23;
                } else {
                    --day;
                    hour = 23;
                }
                cal.set(11, hour);
                cal.set(7, day);
                a_timestamp = cal.getTime().getTime();
            }
            for (int i = hour; i < 24; ++i) {
                if (this.m_entries[a_attribute][day][i] == null || System.currentTimeMillis() - this.m_entries[a_attribute][day][i].getDayTimestamp() <= 86400000L) continue;
                this.m_entries[a_attribute][day][i] = null;
            }
            entry = this.m_entries[a_attribute][day][hour];
            if (entry == null) {
                this.m_entries[a_attribute][day][hour] = entry = new PerformanceAttributeEntry(a_attribute, this.m_bPassive);
            } else if (this.m_bPassive) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return null;
            }
            PerformanceAttributeEntry previousEntry = hour > 0 ? this.m_entries[a_attribute][day][hour - 1] : (day == 1 ? this.m_entries[a_attribute][7][23] : this.m_entries[a_attribute][day - 1][23]);
            entry.addValue(a_timestamp, a_value, previousEntry);
            if (a_bImport && !this.m_bPassive) {
                this.m_floatingTimeEntries[a_attribute].addValue(a_timestamp, a_value);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return entry;
        }
    }

    public int addData(int a_attribute, Hashtable a_data) {
        if (a_data.isEmpty()) {
            LogHolder.log(1, LogType.MISC, "Empty performance data!");
            return -1;
        }
        int lAverageFromLastTest = 0;
        long lastTestTimestamp = -1L;
        long lastUpdateTimestamp = -1L;
        Enumeration<Object> enumKeys = a_data.keys();
        Vector vecKeys = new Vector();
        while (enumKeys.hasMoreElements()) {
            vecKeys.addElement(enumKeys.nextElement());
        }
        Util.sort(vecKeys, new Util.LongSortAsc());
        enumKeys = vecKeys.elements();
        int values = 0;
        while (enumKeys.hasMoreElements()) {
            int value;
            long timestamp = (Long)enumKeys.nextElement();
            if (this.addPerformanceAttributeEntry(a_attribute, timestamp, value = ((Integer)a_data.get(new Long(timestamp))).intValue(), false) == null) continue;
            lastUpdateTimestamp = timestamp;
            this.m_floatingTimeEntries[a_attribute].addValue(timestamp, value);
            if (value > 0) {
                if (value >= Integer.MAX_VALUE) continue;
                if (lAverageFromLastTest < 0) {
                    lAverageFromLastTest = 0;
                }
                lAverageFromLastTest += value;
                ++values;
                lastTestTimestamp = timestamp;
                continue;
            }
            if (values != 0) continue;
            if (lAverageFromLastTest == 0) {
                lAverageFromLastTest = -1;
            }
            lastTestTimestamp = timestamp;
        }
        if (values > 0) {
            lAverageFromLastTest /= values;
        }
        if (lastTestTimestamp >= 0L) {
            this.m_lastTestTime = lastTestTimestamp;
            this.m_lastTestAverage[a_attribute] = lAverageFromLastTest;
        }
        if (lastUpdateTimestamp >= 0L) {
            this.m_lastUpdate = lastUpdateTimestamp;
        }
        return lAverageFromLastTest;
    }

    public int getLastTestAverage(int a_attribute) {
        return this.m_lastTestAverage[a_attribute];
    }

    public void setStabilityAttributes(StabilityAttributes a_attributes) {
        this.m_stabilityAttributes = a_attributes;
    }

    public void setBound(int a_attribute, Bound a_lValue) {
        this.m_floatingTimeEntries[a_attribute].setBound(a_lValue);
    }

    public void setBestBound(int a_attribute, int a_lValue) {
        this.m_floatingTimeEntries[a_attribute].setBestBound(a_lValue);
    }

    public Bound getBound(int a_attribute) {
        return this.m_floatingTimeEntries[a_attribute].getBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StabilityAttributes getStabilityAttributes() {
        StabilityAttributes attributes;
        if (this.m_stabilityAttributes != null) {
            return this.m_stabilityAttributes;
        }
        Hashtable hashtable = this.m_floatingTimeEntries[3].m_Values;
        synchronized (hashtable) {
            Hashtable hashtable2 = this.m_floatingTimeEntries[0].m_Values;
            synchronized (hashtable2) {
                attributes = new StabilityAttributes(this.m_floatingTimeEntries[3].m_Values.size(), this.m_floatingTimeEntries[0].m_iUnknown, this.m_floatingTimeEntries[0].m_iErrors, this.m_floatingTimeEntries[3].m_iResets);
            }
        }
        return attributes;
    }

    public int getBestBound(int a_attribute) {
        return this.m_floatingTimeEntries[a_attribute].getBestBound();
    }

    public int getAverage(int a_attribute) {
        return this.m_floatingTimeEntries[a_attribute].getAverage();
    }

    public String delayToHTML(int day) {
        return this.toHTML(1, "ms", day);
    }

    public String speedToHTML(int day) {
        return this.toHTML(0, "kbit/s", day);
    }

    public String usersToHTML(int day) {
        return this.toHTML(2, "", day);
    }

    private long getDayTimestamp(int a_attribute, int a_dayOfWeek) {
        long timestamp = -1L;
        for (int i = 0; i < 24 && (this.m_entries[a_attribute][a_dayOfWeek][i] == null || (timestamp = this.m_entries[a_attribute][a_dayOfWeek][i].getDayTimestamp()) == -1L); ++i) {
        }
        return timestamp;
    }

    private String toHTML(int a_attribute, String a_unit, int a_selectedDay) {
        MixCascade cascade = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = PerformanceEntry.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_strCascadeId);
        String htmlData = (cascade != null ? cascade.getName() : "") + "<h2>" + this.m_strCascadeId + "</h2>";
        this.m_current.setTime(new Date(System.currentTimeMillis()));
        int dayOfWeek = this.m_current.get(7);
        Calendar cal = Calendar.getInstance();
        cal.add(7, -6);
        for (int i = 1; i <= 7; ++i) {
            SimpleDateFormat df = new SimpleDateFormat("E yyyy-MM-dd");
            String date = df.format(cal.getTime());
            htmlData = cal.get(7) == a_selectedDay ? htmlData + "<b> " + (cal.get(7) == dayOfWeek ? "Today</b> " : date + "</b> | ") : htmlData + "<a href=\"/values/" + ATTRIBUTES[a_attribute].toLowerCase() + "/" + this.m_strCascadeId + "/" + cal.get(7) + "\">" + (cal.get(7) == dayOfWeek ? "Today</a> " : date + "</a> | ");
            cal.add(7, 1);
        }
        htmlData = htmlData + "<br /><br /><table width=\"100%\"><tr><th width=\"16%\">Hour</th><th>Average</th><th>Min</th><th>Max</th><th>Bound</th><th>% Std. Deviation</th><th>Err/Try/Total</th><th>Resets</th></tr>";
        for (int hour = 0; hour < 24; ++hour) {
            htmlData = htmlData + "<tr><td CLASS=\"name\">" + hour + ":00 - " + (hour + 1) % 24 + ":00</td>";
            PerformanceAttributeEntry entry = this.m_entries[a_attribute][a_selectedDay][hour];
            long dayTimestamp = 0L;
            if (entry != null) {
                dayTimestamp = entry.getDayTimestamp();
            }
            if (entry == null || System.currentTimeMillis() - dayTimestamp >= 604800000L) {
                htmlData = htmlData + "<td colspan=\"7\" align=\"center\">No data available</td>";
            } else {
                int bound;
                NumberFormat format = NumberFormat.getInstance(Constants.LOCAL_FORMAT);
                format.setMaximumFractionDigits(2);
                format.setMinimumFractionDigits(2);
                htmlData = htmlData + "<td>" + entry.getAverageValue() + " " + a_unit + "</td>" + "<td>" + entry.getMinValue() + " " + a_unit + "</td>" + "<td>" + entry.getMaxValue() + " " + a_unit + "</td>" + "<td>";
                int n = bound = entry == null ? -1 : entry.getBound();
                if (a_attribute == 1) {
                    htmlData = bound == Integer.MAX_VALUE ? htmlData + "> " + BOUNDARIES[1][BOUNDARIES[1].length - 2] : (bound <= 0 ? htmlData + "?" : htmlData + bound);
                } else if (a_attribute == 0) {
                    htmlData = bound == 0 ? htmlData + "< " + BOUNDARIES[0][1] : (bound < 0 || bound == Integer.MAX_VALUE ? htmlData + "?" : htmlData + bound);
                }
                htmlData = htmlData + " " + a_unit + "</td>";
                htmlData = entry == null || entry.getStdDeviation() == -1.0 || entry.getAverageValue() == 0 ? htmlData + "<td></td>" : htmlData + "<td>" + format.format(100.0 * entry.getStdDeviation() / (double)entry.getAverageValue()) + " %</td>";
                double errorPercentage = 0.0;
                double tryPercentage = 0.0;
                if (entry != null && entry.getValueSize() != 0) {
                    errorPercentage = (double)entry.getErrors() / (double)entry.getValueSize() * 100.0;
                    tryPercentage = (double)entry.getUnknown() / (double)entry.getValueSize() * 100.0;
                }
                htmlData = htmlData + "<td>" + entry.getErrors() + " / " + entry.getUnknown() + " / " + entry.getValueSize() + " (" + NumberFormat.getInstance(Constants.LOCAL_FORMAT).format(errorPercentage) + " % / " + NumberFormat.getInstance(Constants.LOCAL_FORMAT).format(tryPercentage) + " %)</td>";
                entry = this.m_entries[3][a_selectedDay][hour];
                htmlData = entry != null && entry.getResets() > 0 ? htmlData + "<td>" + entry.getResets() + "</td>" : htmlData + "<td></td>";
            }
            htmlData = htmlData + "</tr>";
        }
        htmlData = htmlData + "</table>";
        return htmlData;
    }

    public Element toXmlElement(Document a_doc) {
        Element elem = a_doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(elem, XML_ATTR_ID, this.getId());
        Element elemCurrent = a_doc.createElement(XML_ELEMENT_DATA);
        Element elemDelay = this.m_floatingTimeEntries[1].toXmlElement(a_doc);
        elemCurrent.appendChild(elemDelay);
        Element elemSpeed = this.m_floatingTimeEntries[0].toXmlElement(a_doc);
        elemCurrent.appendChild(elemSpeed);
        Element elemStability = this.getStabilityAttributes().toXmlElement(a_doc);
        elemCurrent.appendChild(elemStability);
        elem.appendChild(elemCurrent);
        return elem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Bound {
        private int m_bound;
        private int m_nonRecoveredBound;

        public Bound(int a_bound, int a_nonRecoveredBound) {
            this.m_bound = a_bound;
            this.m_nonRecoveredBound = a_nonRecoveredBound;
        }

        public int getBound() {
            return this.m_bound;
        }

        public int getNotRecoveredBound() {
            return this.m_nonRecoveredBound;
        }
    }

    public static class StabilityAttributes {
        public static final String XML_ELEMENT_NAME = "Stability";
        private static final String XML_ATTR_TOTAL = "total";
        private static final String XML_ATTR_UNKNOWN = "unknown";
        private static final String XML_ATTR_ERRORS = "errors";
        private static final String XML_ATTR_RESETS = "resets";
        private static final String XML_ATTR_BOUND_UNKNOWN = "boundUnknown";
        private static final String XML_ATTR_BOUND_ERRORS = "boundErrors";
        private static final String XML_ATTR_BOUND_RESETS = "boundResets";
        private static final double BOUND = 5.0;
        private int m_iSize;
        private int m_iErrors;
        private int m_iResets;
        private int m_iUnknown;
        private int m_boundUnknown;
        private int m_boundErrors;
        private int m_boundResets;

        private StabilityAttributes(Element a_entry) throws XMLParseException {
            XMLUtil.assertNodeName(a_entry, XML_ELEMENT_NAME);
            this.m_iSize = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_TOTAL, 0);
            this.m_iUnknown = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_UNKNOWN, 0);
            this.m_iErrors = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_ERRORS, 0);
            this.m_iResets = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_RESETS, 0);
            this.m_boundUnknown = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_BOUND_UNKNOWN, 0);
            this.m_boundErrors = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_BOUND_ERRORS, 0);
            this.m_iResets = XMLUtil.parseAttribute((Node)a_entry, XML_ATTR_BOUND_RESETS, 0);
        }

        public StabilityAttributes(int a_iSize, int a_iUnknown, int a_iErrors, int a_iResets) {
            this.m_iSize = a_iSize;
            this.m_iUnknown = a_iUnknown;
            this.m_iErrors = a_iErrors;
            this.m_iResets = a_iResets;
            if (a_iSize == 0) {
                this.m_boundUnknown = 0;
                this.m_boundErrors = 0;
                this.m_boundResets = 0;
                return;
            }
            double percentageOne = 100.0 * (double)this.m_iUnknown / (double)this.m_iSize;
            double percentageTwo = 100.0 * (double)a_iErrors / (double)this.m_iSize;
            this.m_boundUnknown = (int)Math.ceil(percentageOne / 5.0) * 5;
            this.m_boundErrors = (int)Math.ceil(percentageTwo / 5.0) * 5;
            this.m_boundResets = (int)Math.ceil(100.0 * (double)a_iResets / (double)a_iSize / 5.0) * 5;
        }

        public int getBoundErrors() {
            return this.m_boundErrors;
        }

        public int getBoundResets() {
            return this.m_boundResets;
        }

        public int getBoundUnknown() {
            return this.m_boundUnknown;
        }

        public int getValueSize() {
            return this.m_iSize;
        }

        public Element toXmlElement(Document a_doc) {
            Element elem = a_doc.createElement(XML_ELEMENT_NAME);
            XMLUtil.setAttribute(elem, XML_ATTR_TOTAL, this.m_iSize);
            XMLUtil.setAttribute(elem, XML_ATTR_UNKNOWN, this.m_iUnknown);
            XMLUtil.setAttribute(elem, XML_ATTR_ERRORS, this.m_iErrors);
            XMLUtil.setAttribute(elem, XML_ATTR_RESETS, this.m_iResets);
            XMLUtil.setAttribute(elem, XML_ATTR_BOUND_UNKNOWN, this.m_boundUnknown);
            XMLUtil.setAttribute(elem, XML_ATTR_BOUND_ERRORS, this.m_boundErrors);
            XMLUtil.setAttribute(elem, XML_ATTR_BOUND_RESETS, this.m_boundResets);
            return elem;
        }
    }

    public static class PerformanceAttributeEntry {
        private int m_iLastValue = -1;
        private long m_iLastTimestamp = -1L;
        private int m_lMaxValue = -1;
        private int m_iMinValue = -1;
        private int m_lAverageValue = -1;
        private int m_lBound = -1;
        private double m_lStdDeviation = 0.0;
        private long m_lastUpdate = -1L;
        private Hashtable m_Values = new Hashtable();
        private int m_iErrors = 0;
        private int m_iResets = 0;
        private int m_iUnknown = 0;
        private int m_iSuccess = 0;
        private int m_attribute;
        private boolean m_bPassive;

        private PerformanceAttributeEntry(int a_attribute, boolean a_bPassive) {
            this.m_attribute = a_attribute;
            this.m_bPassive = a_bPassive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addValue(long a_lTimeStamp, int a_iValue, PerformanceAttributeEntry a_previousEntry) {
            Enumeration e;
            if (System.currentTimeMillis() - a_lTimeStamp >= 604800000L) {
                return;
            }
            this.m_lastUpdate = a_lTimeStamp;
            if (a_iValue < 0 || !this.m_bPassive && a_iValue == Integer.MAX_VALUE) {
                if (a_iValue < 0) {
                    ++this.m_iErrors;
                    if (a_iValue < -1) {
                        LogHolder.log(4, LogType.MISC, "Got negative performance value (" + a_iValue + ") for timestamp " + a_lTimeStamp + ".");
                    }
                } else if (a_iValue == Integer.MAX_VALUE) {
                    ++this.m_iUnknown;
                }
                if (this.m_Values.size() == 0) {
                    this.m_lAverageValue = -1;
                    this.m_iMinValue = -1;
                    this.m_lMaxValue = -1;
                    this.m_lStdDeviation = -1.0;
                    this.m_lBound = -1;
                }
                return;
            }
            this.m_Values.put(new Long(a_lTimeStamp), new Integer(a_iValue));
            ++this.m_iSuccess;
            if (this.m_attribute == 3) {
                if (this.m_iLastTimestamp < 0L && a_previousEntry != null) {
                    this.m_iLastTimestamp = a_previousEntry.m_iLastTimestamp;
                    this.m_iLastValue = a_previousEntry.m_iLastValue;
                }
                if (this.m_iLastTimestamp < a_lTimeStamp) {
                    if (a_iValue < this.m_iLastValue) {
                        ++this.m_iResets;
                    }
                    this.m_iLastValue = a_iValue;
                    this.m_iLastTimestamp = a_lTimeStamp;
                } else {
                    LogHolder.log(4, LogType.MISC, "Unordered timestamps for hourly attribute " + this.m_attribute + "." + "Timestamp new: " + a_lTimeStamp + " Timestamp old: " + this.m_iLastTimestamp + " Value: " + a_iValue);
                }
            }
            int lValues = 0;
            double mseValue = 0.0;
            Hashtable hashtable = this.m_Values;
            synchronized (hashtable) {
                e = this.m_Values.elements();
                while (e.hasMoreElements()) {
                    lValues += ((Integer)e.nextElement()).intValue();
                }
                this.m_lAverageValue = lValues / this.m_Values.size();
                e = this.m_Values.elements();
                while (e.hasMoreElements()) {
                    mseValue += Math.pow((Integer)e.nextElement() - this.m_lAverageValue, 2.0);
                }
            }
            this.m_lStdDeviation = Math.sqrt(mseValue /= (double)this.m_Values.size());
            if (mseValue < 0.0) {
                LogHolder.log(0, LogType.MISC, "Negative mean square error! " + mseValue);
            }
            if (a_iValue < 0) {
                LogHolder.log(3, LogType.MISC, "Negative attribute value! " + a_iValue);
            }
            this.m_iMinValue = this.m_iMinValue == 0 || this.m_iMinValue == -1 ? a_iValue : Math.min(this.m_iMinValue, a_iValue);
            this.m_lMaxValue = Math.max(this.m_lMaxValue, a_iValue);
            Vector<Integer> vec = new Vector<Integer>();
            Hashtable hashtable2 = this.m_Values;
            synchronized (hashtable2) {
                e = this.m_Values.elements();
                while (e.hasMoreElements()) {
                    Integer value = (Integer)e.nextElement();
                    if (value < 0) continue;
                    vec.addElement(value);
                }
            }
            if (this.m_attribute == 0) {
                Util.sort(vec, new Util.IntegerSortAsc());
            } else {
                Util.sort(vec, new Util.IntegerSortDesc());
            }
            int limit = (int)Math.floor((double)vec.size() * 0.1);
            for (int i = 0; i < limit && vec.size() > 1; ++i) {
                vec.removeElementAt(0);
            }
            if (vec.size() > 0) {
                int value = (Integer)vec.elementAt(0);
                if (this.m_attribute == 0) {
                    for (int i = BOUNDARIES[this.m_attribute].length - 1; i >= 0; --i) {
                        if (value < BOUNDARIES[this.m_attribute][i]) continue;
                        this.m_lBound = BOUNDARIES[this.m_attribute][i];
                        return;
                    }
                } else {
                    for (int i = 0; i < BOUNDARIES[this.m_attribute].length; ++i) {
                        if (value > BOUNDARIES[this.m_attribute][i]) continue;
                        this.m_lBound = BOUNDARIES[this.m_attribute][i];
                        return;
                    }
                    this.m_lBound = BOUNDARIES[this.m_attribute][BOUNDARIES[this.m_attribute].length - 1];
                    return;
                }
                this.m_lBound = BOUNDARIES[this.m_attribute][0];
                return;
            }
            this.m_lBound = -1;
        }

        public int getAverageValue() {
            return this.m_lAverageValue;
        }

        public int getMinValue() {
            return this.m_iMinValue;
        }

        public int getMaxValue() {
            return this.m_lMaxValue;
        }

        public int getBound() {
            return this.m_lBound;
        }

        public double getStdDeviation() {
            return this.m_lStdDeviation;
        }

        public void setErrors(int a_errors) {
            this.m_iErrors = a_errors;
        }

        public int getErrors() {
            return this.m_iErrors;
        }

        public void setResets(int a_resets) {
            this.m_iResets = a_resets;
        }

        public int getResets() {
            return this.m_iResets;
        }

        public int getUnknown() {
            return this.m_iUnknown;
        }

        public void setUnknown(int a_unknown) {
            this.m_iUnknown = a_unknown;
        }

        public void setSuccess(int a_iSuccess) {
            this.m_iSuccess = a_iSuccess;
        }

        public int getSuccess() {
            return this.m_iSuccess;
        }

        public int getValueSize() {
            return this.getSuccess() + this.m_iErrors + this.m_iUnknown;
        }

        public long getDayTimestamp() {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(this.m_lastUpdate));
            return this.m_lastUpdate - (long)(cal.get(11) * 60 * 60 * 1000) - (long)(cal.get(12) * 60 * 1000) - (long)(cal.get(13) * 1000) - (long)cal.get(14);
        }
    }

    private static class PerformanceAttributeFloatingTimeEntry
    implements IXMLEncodable {
        public static final long DEFAULT_TIMEFRAME = 3600000L;
        public static final String XML_ELEMENT_VALUES = "Values";
        public static final String XML_ELEMENT_VALUE = "Value";
        public static final String XML_ATTR_BEST = "best";
        public static final String XML_ATTR_BOUND = "bound";
        public static final String XML_ATTR_NOT_RECOVERED_BOUND = "notRecovered";
        private int m_iLastValue = -1;
        private long m_iLastTimestamp = -1L;
        public int m_attribute;
        public long m_lastUpdate;
        private Hashtable m_Values = new Hashtable();
        private Bound m_lBoundValue = new Bound(-1, -1);
        private int m_lBestBoundValue = -1;
        private int m_iResets = 0;
        private int m_iErrors = 0;
        private int m_iUnknown = 0;
        private boolean m_bInfoService;

        public PerformanceAttributeFloatingTimeEntry(int a_attribute, boolean a_bInfoService) {
            this.m_attribute = a_attribute;
            this.m_bInfoService = a_bInfoService;
        }

        public PerformanceAttributeFloatingTimeEntry(int a_attribute, Node a_node) {
            this.m_attribute = a_attribute;
            this.m_bInfoService = false;
            long lBoundValue = XMLUtil.parseAttribute(a_node, XML_ATTR_BOUND, -1L);
            int iBoundValue = lBoundValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lBoundValue;
            lBoundValue = XMLUtil.parseAttribute(a_node, XML_ATTR_NOT_RECOVERED_BOUND, -1L);
            int iNotRecoveredBound = lBoundValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lBoundValue;
            this.m_lBoundValue = new Bound(iBoundValue, iNotRecoveredBound);
            long lBestBoundValue = XMLUtil.parseAttribute(a_node, XML_ATTR_BEST, -2L);
            this.m_lBestBoundValue = lBestBoundValue == -2L ? (a_attribute == 0 ? Integer.MAX_VALUE : 0) : (lBestBoundValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lBestBoundValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValue(long a_lTimeStamp, int a_lValue) {
            if (System.currentTimeMillis() - a_lTimeStamp > 3600000L) {
                return;
            }
            Hashtable hashtable = this.m_Values;
            synchronized (hashtable) {
                Vector<Long> keysToDelete = new Vector<Long>();
                boolean bReset = false;
                if (a_lValue < 0 || a_lValue == Integer.MAX_VALUE) {
                    if (a_lValue < 0) {
                        ++this.m_iErrors;
                    } else if (a_lValue == Integer.MAX_VALUE) {
                        ++this.m_iUnknown;
                    }
                } else if (this.m_attribute == 3) {
                    if (this.m_iLastTimestamp < a_lTimeStamp) {
                        if (a_lValue < this.m_iLastValue) {
                            ++this.m_iResets;
                            bReset = true;
                        }
                        this.m_iLastValue = a_lValue;
                        this.m_iLastTimestamp = a_lTimeStamp;
                    } else {
                        LogHolder.log(4, LogType.MISC, "Unordered timestamps for floating PACKETS. Timestamp new: " + a_lTimeStamp + " Timestamp old: " + this.m_iLastTimestamp + " Value: " + a_lValue);
                    }
                    a_lValue = bReset ? 1 : 0;
                }
                this.m_Values.put(new Long(a_lTimeStamp), new Integer(a_lValue));
                Enumeration e = this.m_Values.keys();
                while (e.hasMoreElements()) {
                    Long timestamp = (Long)e.nextElement();
                    if (System.currentTimeMillis() - timestamp <= 3600000L) continue;
                    keysToDelete.addElement(timestamp);
                }
                for (int i = 0; i < keysToDelete.size(); ++i) {
                    a_lValue = (Integer)this.m_Values.get(keysToDelete.elementAt(i));
                    if (a_lValue < 0 || a_lValue == Integer.MAX_VALUE) {
                        if (a_lValue < 0) {
                            --this.m_iErrors;
                        } else if (a_lValue == Integer.MAX_VALUE) {
                            --this.m_iUnknown;
                        }
                    } else if (this.m_attribute == 3 && a_lValue == 1) {
                        --this.m_iResets;
                    }
                    this.m_Values.remove(keysToDelete.elementAt(i));
                }
                keysToDelete.removeAllElements();
            }
        }

        public void setBound(Bound a_bound) {
            if (!this.m_bInfoService) {
                this.m_lBoundValue = a_bound;
            }
        }

        public void setBestBound(int a_lValue) {
            if (!this.m_bInfoService) {
                this.m_lBestBoundValue = a_lValue;
            }
        }

        public Bound getBound() {
            if (!this.m_bInfoService) {
                return this.m_lBoundValue;
            }
            Vector vecTimestamps = new Vector();
            Hashtable hashValues = (Hashtable)this.m_Values.clone();
            int nonRecoveredBound = this.calculateBound(hashValues, vecTimestamps);
            int limit = Math.max((int)Math.floor((double)vecTimestamps.size() * 0.1), 2);
            int bound = nonRecoveredBound;
            Util.sort(vecTimestamps, new Util.LongSortDesc());
            for (int i = 0; i < vecTimestamps.size(); ++i) {
                int j;
                int value = (Integer)hashValues.get(vecTimestamps.elementAt(i));
                if (value < 0 || value == Integer.MAX_VALUE) {
                    ++limit;
                    continue;
                }
                int nextBound = bound;
                if (this.m_attribute == 1) {
                    for (j = BOUNDARIES[this.m_attribute].length - 1; j >= 0; --j) {
                        if (BOUNDARIES[this.m_attribute][j] != bound) continue;
                        if (j <= 0) break;
                        nextBound = BOUNDARIES[this.m_attribute][j - 1];
                        break;
                    }
                } else {
                    for (j = 0; j < BOUNDARIES[this.m_attribute].length; ++j) {
                        if (BOUNDARIES[this.m_attribute][j] != bound) continue;
                        if (j + 1 >= BOUNDARIES[this.m_attribute].length) break;
                        nextBound = BOUNDARIES[this.m_attribute][j + 1];
                        break;
                    }
                }
                if (nextBound == bound || (this.m_attribute != 0 || value >= nextBound) && (this.m_attribute != 1 || value <= nextBound)) continue;
                if (i <= limit) break;
                for (j = i; j < vecTimestamps.size(); ++j) {
                    hashValues.remove(vecTimestamps.elementAt(j));
                }
                vecTimestamps.removeAllElements();
                bound = this.calculateBound(hashValues, vecTimestamps);
                break;
            }
            return new Bound(bound, nonRecoveredBound);
        }

        private int calculateBound(Hashtable a_hashValues, Vector a_timestamps) {
            int values = 0;
            long errors = 0L;
            Vector<Integer> vecValues = new Vector<Integer>();
            Enumeration e = a_hashValues.keys();
            while (e.hasMoreElements()) {
                Long timestamp = (Long)e.nextElement();
                if (System.currentTimeMillis() - timestamp > 3600000L) continue;
                a_timestamps.addElement(timestamp);
                Integer value = (Integer)a_hashValues.get(timestamp);
                if (value < 0) {
                    ++errors;
                    continue;
                }
                if (value == Integer.MAX_VALUE) continue;
                ++values;
                vecValues.addElement(value);
            }
            if (values == 0) {
                if (errors > 0L) {
                    return -1;
                }
                if (this.m_attribute == 1) {
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
            if (this.m_attribute == 1) {
                Util.sort(vecValues, new Util.IntegerSortDesc());
            } else {
                Util.sort(vecValues, new Util.IntegerSortAsc());
            }
            int limit = (int)Math.floor((double)vecValues.size() * 0.1);
            for (int i = 0; i < limit; ++i) {
                vecValues.removeElementAt(0);
            }
            if (vecValues.size() > 0) {
                int value = (Integer)vecValues.elementAt(0);
                return this.getBoundFromValue(value);
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getBestBound() {
            if (!this.m_bInfoService) {
                return this.m_lBestBoundValue;
            }
            int values = 0;
            long errors = 0L;
            int bestValue = this.m_attribute == 1 ? Integer.MAX_VALUE : 0;
            Hashtable hashtable = this.m_Values;
            synchronized (hashtable) {
                Enumeration e = this.m_Values.keys();
                while (e.hasMoreElements()) {
                    Long timestamp = (Long)e.nextElement();
                    if (System.currentTimeMillis() - timestamp > 3600000L) continue;
                    Integer value = (Integer)this.m_Values.get(timestamp);
                    if (value < 0) {
                        ++errors;
                        continue;
                    }
                    if (value == Integer.MAX_VALUE) continue;
                    ++values;
                    if (this.m_attribute == 1) {
                        if (value >= bestValue) continue;
                        bestValue = value;
                        continue;
                    }
                    if (value <= bestValue) continue;
                    bestValue = value;
                }
            }
            if (values == 0) {
                if (errors > 0L) {
                    return -1;
                }
                if (this.m_attribute == 0) {
                    return Integer.MAX_VALUE;
                }
                return 0;
            }
            return this.getBoundFromValue(bestValue);
        }

        private int getBoundFromValue(int value) {
            if (this.m_attribute == 1) {
                for (int i = 0; i < BOUNDARIES[this.m_attribute].length; ++i) {
                    if (value > BOUNDARIES[this.m_attribute][i]) continue;
                    return BOUNDARIES[this.m_attribute][i];
                }
                return BOUNDARIES[this.m_attribute][BOUNDARIES[this.m_attribute].length - 1];
            }
            for (int i = BOUNDARIES[this.m_attribute].length - 1; i >= 0; --i) {
                if (value < BOUNDARIES[this.m_attribute][i]) continue;
                return BOUNDARIES[this.m_attribute][i];
            }
            return BOUNDARIES[this.m_attribute][0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getAverage() {
            if (!this.m_bInfoService) {
                return -1;
            }
            int values = 0;
            int value = 0;
            int lAverageValue = 0;
            long errors = 0L;
            Hashtable hashtable = this.m_Values;
            synchronized (hashtable) {
                Enumeration e = this.m_Values.keys();
                while (e.hasMoreElements()) {
                    Long timestamp = (Long)e.nextElement();
                    if (System.currentTimeMillis() - timestamp > 3600000L) continue;
                    value = (Integer)this.m_Values.get(timestamp);
                    if (value < 0) {
                        ++errors;
                        continue;
                    }
                    if (value == Integer.MAX_VALUE) continue;
                    ++values;
                    lAverageValue += value;
                }
            }
            if (errors > 0L && values == 0) {
                return -1;
            }
            if (values == 0) {
                return 0;
            }
            return lAverageValue / values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getStdDeviation() {
            if (!this.m_bInfoService) {
                return -1.0;
            }
            int values = 0;
            int value = 0;
            long errors = 0L;
            long mseValue = 0L;
            Hashtable hashtable = this.m_Values;
            synchronized (hashtable) {
                Enumeration e = this.m_Values.keys();
                while (e.hasMoreElements()) {
                    Long timestamp = (Long)e.nextElement();
                    if (System.currentTimeMillis() - timestamp > 3600000L) continue;
                    value = (Integer)this.m_Values.get(timestamp);
                    if (value < 0) {
                        ++errors;
                        continue;
                    }
                    if (value == Integer.MAX_VALUE) continue;
                    ++values;
                    mseValue = (long)((double)mseValue + Math.pow(value - this.getAverage(), 2.0));
                }
            }
            if (errors > 0L && values == 0) {
                return -1.0;
            }
            if (values == 0) {
                return 0.0;
            }
            return Math.sqrt(mseValue /= (long)values);
        }

        public Element toXmlElement(Document a_doc) {
            Element elem = a_doc.createElement(ATTRIBUTES[this.m_attribute]);
            Bound bound = this.getBound();
            XMLUtil.setAttribute(elem, XML_ATTR_BOUND, bound.getBound());
            XMLUtil.setAttribute(elem, XML_ATTR_NOT_RECOVERED_BOUND, bound.getNotRecoveredBound());
            XMLUtil.setAttribute(elem, XML_ATTR_BEST, this.getBestBound());
            return elem;
        }
    }
}

