/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.DSAKeyPair;
import anon.crypto.DSAKeyPool;
import anon.error.AccountEmptyException;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.pay.BIConnection;
import anon.pay.IAccountListener;
import anon.pay.IBIConnectionListener;
import anon.pay.IMessageListener;
import anon.pay.IPaymentListener;
import anon.pay.PayAccount;
import anon.pay.PayMessage;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLAccountCertificate;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLErrorMessage;
import anon.pay.xml.XMLGenericText;
import anon.pay.xml.XMLJapPublicKey;
import anon.pay.xml.XMLPassivePayment;
import anon.util.IMiscPasswordReader;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.captcha.ICaptchaSender;
import anon.util.captcha.IImageEncodedCaptcha;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PayAccountsFile
extends Observable
implements IXMLEncodable,
IBIConnectionListener,
IMessageListener {
    public static final String XML_ELEMENT_NAME = "PayAccounts";
    public static final String METHOD_COUPON = "Coupon";
    public static final String XML_ELEMENT_AFFILIATE = "Affiliate";
    public static final String XML_ELEMENT_AFFILIATES = "Affiliates";
    public static final Integer CHANGED_AUTO_UPDATE = new Integer(0);
    private static final String XML_ATTR_IGNORE_AI_ERRORS = "ignoreAIErrorMessages";
    private static final String XML_ATTR_ENABLE_BALANCE_AUTO_UPDATE = "autoUpdateBalance";
    private static final String XML_ATTR_IS_NEW_USER = "isNewUser";
    public static final String MSG_DO_PREMIUM_PAYMENT = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".doPremiumPayment";
    public static final String MSG_DO_PREMIUM_PAYMENT_ALTERNATIVE = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".doPremiumPaymentAlternative";
    public static final String MSG_GET_FREE_CODE = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".getFreeCode";
    public static final String MSG_PAY_CREATE_ACCOUNT = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".payCreateAccount";
    public static final String MSG_NO_PAYMENT_INSTANCE = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".noPaymentInstance";
    public static final String MSG_CREATING_KEY_PAIR = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".creatingKeyPair";
    public static final String MSG_CREATING_KEY_PAIR_ERROR = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".creatingKeyPairError";
    public static final String MSG_UPDATING_ACCOUNT_DATA = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".updatingAccountData";
    public static final String MSG_UPDATING_ACCOUNT_DATA_ERROR = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".updatingAccountDataError";
    public static final String MSG_CREATING_ACCOUNT = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".creatingAccount";
    public static final String MSG_CREATING_ACCOUNT_ERROR = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".creatingAccountError";
    public static final String MSG_CREATING_ACCOUNT_ERROR_UNREACHABLE = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".creatingAccountErrorUnreachable";
    public static final String MSG_CREATING_ACCOUNT_ERROR_FORBIDDEN = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".creatingAccountErrorForbidden";
    public static final String MSG_SAVING_CONFIG_FILE = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".savingConfigFile";
    public static final String MSG_SAVING_CONFIG_FILE_ERROR = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".savingConfigFileError";
    public static final String MSG_VERIFYING_COUPON = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".verifyingCoupon";
    public static final String MSG_ACTIVATING_COUPON = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".activatingCoupon";
    public static final String MSG_ACTIVATING_COUPON_ERROR = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".activatingCouponError";
    public static final String MSG_ACTIVATING_COUPON_NOT_ACCEPTED = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".activatingCouponNotAccepted";
    public static final String MSG_ACTIVATING_COUPON_NOT_A_NEW_USER = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".activatingCouponNotANewUser";
    public static final String MSG_ERROR_ALLOW_NON_ANONYMOUS_OR_CONNECT = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".errorAllowNonAnonymousOrConnect";
    public static final String MSG_ERROR_ALLOW_NON_ANONYMOUS_OR_CONNECT_INFOSERVICE = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".errorAllowNonAnonymousOrConnectInfoService";
    public static final String MSG_ERROR_DELETION_ACCOUNT_BLOCKED = (class$anon$pay$PayAccountsFile == null ? (class$anon$pay$PayAccountsFile = PayAccountsFile.class$("anon.pay.PayAccountsFile")) : class$anon$pay$PayAccountsFile).getName() + ".errorDeletionAccountBlocked";
    private static boolean m_bIsInitialized = false;
    private boolean m_bIgnoreAIAccountErrorMessages = false;
    private boolean m_bEnableBalanceAutoUpdate = true;
    private Hashtable m_hashAffiliate = new Hashtable();
    private Vector m_Accounts = new Vector();
    private boolean m_bIsNewUser = true;
    private PayAccount m_ActiveAccount = null;
    private static PayAccountsFile ms_AccountsFile = null;
    private Vector m_paymentListeners = new Vector();
    private Vector m_messageListeners = new Vector();
    private MyAccountListener m_MyAccountListener = new MyAccountListener();
    private DSAKeyPool m_keyPool;
    private static int ms_keyPoolSize = 2;
    private IAffiliateOptOut m_affiliateOptOut = new IAffiliateOptOut(){

        public boolean isAffiliateAllowed() {
            return true;
        }
    };
    private boolean m_bGotPremiumAccount = false;
    static /* synthetic */ Class class$anon$pay$PayAccountsFile;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;

    private PayAccountsFile() {
        this.m_keyPool = new DSAKeyPool(ms_keyPoolSize);
        this.m_keyPool.start();
    }

    public static PayAccountsFile getInstance() {
        if (ms_AccountsFile == null) {
            ms_AccountsFile = new PayAccountsFile();
        }
        return ms_AccountsFile;
    }

    public AsymmetricCryptoKeyPair createAccountKeyPair() {
        return this.m_keyPool.popKeyPair();
    }

    public AsymmetricCryptoKeyPair createAccountKeyPair(int a_keyLengthForTesting) {
        return DSAKeyPair.getInstance(new SecureRandom(), a_keyLengthForTesting, 60);
    }

    public void setIgnoreAIAccountError(boolean a_bIgnore) {
        this.m_bIgnoreAIAccountErrorMessages = a_bIgnore;
    }

    public boolean isNewUser() {
        return this.m_bIsNewUser;
    }

    public boolean isBalanceAutoUpdateEnabled() {
        return this.m_bEnableBalanceAutoUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalanceAutoUpdateEnabled(boolean a_bEnable) {
        PayAccountsFile payAccountsFile = this;
        synchronized (payAccountsFile) {
            if (this.m_bEnableBalanceAutoUpdate != a_bEnable) {
                this.m_bEnableBalanceAutoUpdate = a_bEnable;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_AUTO_UPDATE);
        }
    }

    public boolean isAIAccountErrorIgnored() {
        return this.m_bIgnoreAIAccountErrorMessages;
    }

    public synchronized boolean importAccounts(Element elemAccountsFile, IMiscPasswordReader a_passwordReader) throws XMLParseException, Exception {
        return this.importAccounts(elemAccountsFile, a_passwordReader, false);
    }

    public synchronized boolean importAccounts(Element elemAccountsFile, IMiscPasswordReader a_passwordReader, boolean a_bOnlyWithCorrectPassword) throws XMLParseException, Exception {
        boolean bAccountAdded = false;
        XMLUtil.assertNodeName(elemAccountsFile, XML_ELEMENT_NAME);
        Element elemAccounts = (Element)XMLUtil.getFirstChildByName(elemAccountsFile, "Accounts");
        Node elemAccount = XMLUtil.getFirstChildByName(elemAccounts, "Account");
        while (elemAccount != null) {
            PayMessage existingMessage;
            XMLBalance existingBalance;
            PayAccount theAccount = new PayAccount((Element)elemAccount, a_passwordReader);
            if (a_bOnlyWithCorrectPassword && theAccount.getPrivateKey() == null) continue;
            try {
                this.addAccount(theAccount);
                bAccountAdded = true;
            }
            catch (AccountAlreadyExistingException a_e) {
                LogHolder.log(4, LogType.PAY, "Account " + theAccount.getAccountNumber() + " already existed in our configuration and was not added.");
            }
            if (theAccount.getAccountInfo() != null && (existingBalance = theAccount.getAccountInfo().getBalance()) != null && (existingMessage = existingBalance.getMessage()) != null && !existingMessage.getShortMessage().equals("")) {
                PayAccountsFile.getInstance().messageReceived(existingMessage);
            }
            while ((elemAccount = XMLUtil.getNextSibling(elemAccount)) != null && !(elemAccount instanceof Element)) {
            }
        }
        return bAccountAdded;
    }

    public static synchronized boolean init(Element elemAccountsFile, IMiscPasswordReader a_passwordReader, boolean a_bForceAIErrors, int a_keyPoolSize, IAffiliateOptOut a_affiliateOptOut) {
        if (m_bIsInitialized) {
            return false;
        }
        if (a_affiliateOptOut != null) {
            PayAccountsFile.getInstance().m_affiliateOptOut = a_affiliateOptOut;
        }
        if (a_keyPoolSize >= 0) {
            ms_keyPoolSize = a_keyPoolSize;
        }
        if (elemAccountsFile != null && elemAccountsFile.getNodeName().equals(XML_ELEMENT_NAME)) {
            PayAccountsFile.getInstance().m_bIgnoreAIAccountErrorMessages = a_bForceAIErrors ? false : false;
            PayAccountsFile.getInstance().m_bEnableBalanceAutoUpdate = XMLUtil.parseAttribute((Node)elemAccountsFile, XML_ATTR_ENABLE_BALANCE_AUTO_UPDATE, true);
            PayAccountsFile.getInstance().m_bIsNewUser = XMLUtil.parseAttribute((Node)elemAccountsFile, XML_ATTR_IS_NEW_USER, PayAccountsFile.getInstance().m_bIsNewUser);
            Element elemActiveAccount = (Element)XMLUtil.getFirstChildByName(elemAccountsFile, "ActiveAccountNumber");
            NodeList nodesAffiliates = XMLUtil.getElementsByTagName(XMLUtil.getFirstChildByName(elemAccountsFile, XML_ELEMENT_AFFILIATES), XML_ELEMENT_AFFILIATE);
            if (nodesAffiliates != null) {
                for (int i = 0; i < nodesAffiliates.getLength(); ++i) {
                    String tmpAffiliate = XMLUtil.parseValue(nodesAffiliates.item(i), null);
                    String tmpPiid = XMLUtil.parseAttribute(nodesAffiliates.item(i), "piid", null);
                    if (tmpAffiliate == null || tmpAffiliate.length() <= 0 || tmpPiid == null || tmpPiid.length() <= 0 || tmpAffiliate.endsWith("_null")) continue;
                    PayAccountsFile.getInstance().m_hashAffiliate.put(tmpPiid, tmpAffiliate);
                    PayAccountsFile.getInstance().m_bIsNewUser = false;
                }
            }
            long activeAccountNumber = Long.parseLong(XMLUtil.parseValue((Node)elemActiveAccount, "0"));
            try {
                PayAccountsFile.getInstance().importAccounts(elemAccountsFile, a_passwordReader);
            }
            catch (Exception a_e) {
                LogHolder.log(2, LogType.PAY, a_e);
                return false;
            }
            if (activeAccountNumber > 0L) {
                Enumeration e = PayAccountsFile.getInstance().m_Accounts.elements();
                while (e.hasMoreElements()) {
                    PayAccount current = (PayAccount)e.nextElement();
                    if (current.getAccountNumber() != activeAccountNumber) continue;
                    try {
                        PayAccountsFile.getInstance().setActiveAccount(current);
                    }
                    catch (Exception ex) {}
                    break;
                }
            }
            PayAccountsFile.getInstance().checkAffiliateToDelete();
        }
        PayAccountsFile.getInstance();
        m_bIsInitialized = true;
        return true;
    }

    private synchronized void checkAffiliateToDelete() {
        Hashtable<String, String> hashPIFromAccounts = new Hashtable<String, String>();
        Hashtable hashAffiliateClone = (Hashtable)this.m_hashAffiliate.clone();
        Enumeration<Object> e = this.m_Accounts.elements();
        while (e.hasMoreElements()) {
            PayAccount current = (PayAccount)e.nextElement();
            hashPIFromAccounts.put(current.getPIID(), current.getPIID());
        }
        e = this.m_hashAffiliate.keys();
        while (e.hasMoreElements()) {
            String tmpPiid = (String)e.nextElement();
            if (hashPIFromAccounts.containsKey(tmpPiid)) continue;
            hashAffiliateClone.remove(tmpPiid);
        }
        this.m_hashAffiliate = hashAffiliateClone;
    }

    public Element toXmlElement(Document a_doc) {
        return this.toXmlElement(a_doc, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc, String a_password, boolean a_bDoNotDeactivate) {
        try {
            Element elemAccount;
            Element elemAccountsFile = a_doc.createElement(XML_ELEMENT_NAME);
            elemAccountsFile.setAttribute("version", "1.0");
            XMLUtil.setAttribute(elemAccountsFile, XML_ATTR_IGNORE_AI_ERRORS, this.m_bIgnoreAIAccountErrorMessages);
            XMLUtil.setAttribute(elemAccountsFile, XML_ATTR_ENABLE_BALANCE_AUTO_UPDATE, this.m_bEnableBalanceAutoUpdate);
            XMLUtil.setAttribute(elemAccountsFile, XML_ATTR_IS_NEW_USER, this.m_bIsNewUser);
            Element elem = a_doc.createElement("ActiveAccountNumber");
            XMLUtil.setValue((Node)elem, this.getActiveAccountNumber());
            elemAccountsFile.appendChild(elem);
            if (this.m_hashAffiliate.size() > 0) {
                elem = a_doc.createElement(XML_ELEMENT_AFFILIATES);
                Enumeration enumKeys = this.m_hashAffiliate.keys();
                while (enumKeys.hasMoreElements()) {
                    String strBIID = (String)enumKeys.nextElement();
                    if (this.m_hashAffiliate.get(strBIID) == null || this.m_hashAffiliate.get(strBIID).toString().endsWith("_null")) continue;
                    elemAccount = a_doc.createElement(XML_ELEMENT_AFFILIATE);
                    XMLUtil.setValue((Node)elemAccount, (String)this.m_hashAffiliate.get(strBIID));
                    XMLUtil.setAttribute(elemAccount, "piid", strBIID);
                    elem.appendChild(elemAccount);
                }
                elemAccountsFile.appendChild(elem);
            }
            elem = a_doc.createElement("Accounts");
            elemAccountsFile.appendChild(elem);
            PayAccountsFile payAccountsFile = this;
            synchronized (payAccountsFile) {
                for (int i = 0; i < this.m_Accounts.size(); ++i) {
                    PayAccount account = (PayAccount)this.m_Accounts.elementAt(i);
                    elemAccount = account.toXmlElement(a_doc, a_password, a_bDoNotDeactivate);
                    elem.appendChild(elemAccount);
                }
            }
            return elemAccountsFile;
        }
        catch (Exception ex) {
            LogHolder.log(2, LogType.PAY, "Exception while creating PayAccountsFile XML: " + ex);
            return null;
        }
    }

    public boolean hasActiveAccount() {
        return this.m_ActiveAccount != null;
    }

    public PayAccount getActiveAccount() {
        return this.m_ActiveAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setActiveAccount(PayAccount a_account) {
        PayAccount account = null;
        if (a_account != null) {
            account = this.getAccount(a_account.getAccountNumber(), a_account.getPIID());
        }
        if (account != null && account.getPrivateKey() != null) {
            Vector vector = this.m_paymentListeners;
            synchronized (vector) {
                this.m_ActiveAccount = account;
                Enumeration enumListeners = this.m_paymentListeners.elements();
                while (enumListeners.hasMoreElements()) {
                    ((IPaymentListener)enumListeners.nextElement()).accountActivated(this.m_ActiveAccount);
                }
            }
        }
        if (account == null) {
            this.m_ActiveAccount = null;
            Vector vector = this.m_paymentListeners;
            synchronized (vector) {
                Enumeration enumListeners = this.m_paymentListeners.elements();
                while (enumListeners.hasMoreElements()) {
                    ((IPaymentListener)enumListeners.nextElement()).accountActivated(this.m_ActiveAccount);
                }
            }
        }
    }

    public long getActiveAccountNumber() {
        PayAccount activeAccount = this.m_ActiveAccount;
        if (activeAccount != null) {
            return activeAccount.getAccountNumber();
        }
        return -1L;
    }

    public synchronized PayAccount getAccount(long accountNumber, String a_piid) {
        PayAccount tmp = null;
        Enumeration enumer = this.m_Accounts.elements();
        while (enumer.hasMoreElements() && ((tmp = (PayAccount)enumer.nextElement()).getAccountNumber() != accountNumber || a_piid != tmp.getPIID() && (a_piid == null || tmp.getPIID() == null || !a_piid.equals(tmp.getPIID())))) {
            tmp = null;
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAccount(PayAccount a_account) {
        if (a_account == null || a_account.isLocked() || a_account.isStatusUnknown()) {
            return;
        }
        PayAccount accountToDelete = null;
        Object object = this;
        synchronized (object) {
            accountToDelete = this.getAccount(a_account.getAccountNumber(), a_account.getPIID());
            if (accountToDelete != null) {
                PayMessage oldMessage;
                for (int i = 0; i < this.m_Accounts.size(); ++i) {
                    accountToDelete = (PayAccount)this.m_Accounts.elementAt(i);
                    if (accountToDelete.getAccountNumber() != a_account.getAccountNumber()) continue;
                    this.m_Accounts.removeElementAt(i);
                    break;
                }
                if (accountToDelete.getBalance() != null && (oldMessage = accountToDelete.getBalance().getMessage()) != null && !oldMessage.getShortMessage().equals("")) {
                    this.fireMessageRemoved(oldMessage);
                }
                if (this.getActiveAccount() == accountToDelete) {
                    if (this.m_Accounts.size() > 0) {
                        this.setActiveAccount((PayAccount)this.m_Accounts.elementAt(0));
                    } else {
                        this.setActiveAccount(null);
                    }
                }
            }
            this.checkAffiliateToDelete();
        }
        if (accountToDelete != null) {
            object = this.m_paymentListeners;
            synchronized (object) {
                Enumeration enumListeners = this.m_paymentListeners.elements();
                while (enumListeners.hasMoreElements()) {
                    ((IPaymentListener)enumListeners.nextElement()).accountRemoved(accountToDelete);
                }
            }
        }
    }

    public String getAffiliate(String a_strPIID, boolean a_bForceAffiliate) {
        if (a_strPIID == null) {
            return null;
        }
        if (!this.m_affiliateOptOut.isAffiliateAllowed() && !a_bForceAffiliate) {
            return null;
        }
        return (String)this.m_hashAffiliate.get(a_strPIID);
    }

    public Enumeration getAccounts() {
        return ((Vector)this.m_Accounts.clone()).elements();
    }

    public static void fireKnownMessages() {
        Enumeration allAccounts = PayAccountsFile.getInstance().getAccounts();
        while (allAccounts.hasMoreElements()) {
            XMLBalance existingBalance;
            PayMessage existingMessage;
            PayAccount theAccount = (PayAccount)allAccounts.nextElement();
            XMLAccountInfo info = theAccount.getAccountInfo();
            if (info == null || (existingMessage = (existingBalance = theAccount.getAccountInfo().getBalance()).getMessage()) == null || existingMessage.getShortMessage().equals("")) continue;
            ms_AccountsFile.fireMessageReceived(existingMessage);
        }
    }

    public synchronized PayAccount getAlternativeChargedAccount(String a_piid) {
        return this.getChargedAccount(a_piid, this.getActiveAccount());
    }

    public PayAccount getAccountWaitingForTransaction(String a_piid) {
        Vector accounts = this.getAccounts(a_piid);
        PayAccount currentAccount = null;
        for (int i = 0; i < accounts.size() && !(currentAccount = (PayAccount)accounts.elementAt(i)).isWaitingForTransaction(); ++i) {
            currentAccount = null;
        }
        return currentAccount;
    }

    public PayAccount getChargedAccount(String a_piid) {
        return this.getChargedAccount(a_piid, null);
    }

    public PayAccount getChargedAccount(String a_piid, PayAccount a_excludeAccount) {
        Vector accounts = this.getAccounts(a_piid);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        PayAccount currentAccount = null;
        if (a_excludeAccount != null && !accounts.contains(a_excludeAccount)) {
            a_excludeAccount = null;
        }
        for (int i = 0; i < accounts.size() && ((currentAccount = (PayAccount)accounts.elementAt(i)).isBlocked() || !currentAccount.isCharged(now) || a_excludeAccount != null && a_excludeAccount == currentAccount); ++i) {
            currentAccount = null;
        }
        return currentAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAccounts(String a_piid) {
        Vector vecAccounts = new Vector();
        Vector vector = this.m_Accounts;
        synchronized (vector) {
            Enumeration enumer = this.m_Accounts.elements();
            PayAccount activeAccount = this.getActiveAccount();
            this.addAccount(vecAccounts, a_piid, activeAccount);
            while (enumer.hasMoreElements()) {
                PayAccount currentAccount = (PayAccount)enumer.nextElement();
                if (currentAccount == activeAccount) continue;
                this.addAccount(vecAccounts, a_piid, currentAccount);
            }
        }
        return vecAccounts;
    }

    private void addAccount(Vector a_vecAccounts, String a_piid, PayAccount a_account) {
        String piid;
        if (a_account == null || a_vecAccounts == null) {
            return;
        }
        PaymentInstanceDBEntry pi = a_account.getBI();
        if (pi == null) {
            LogHolder.log(3, LogType.PAY, "Payment instance for account nr. " + a_account.getAccountNumber() + " not found!");
            piid = a_account.getPIID();
        } else {
            piid = pi.getId();
        }
        if (piid == null) {
            LogHolder.log(1, LogType.PAY, "Payment instance for account nr. " + a_account.getAccountNumber() + " is null!");
            return;
        }
        if (a_piid == null || piid.equals(a_piid)) {
            a_vecAccounts.addElement(a_account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAccount(PayAccount newAccount) throws AccountAlreadyExistingException {
        boolean activeChanged = false;
        Enumeration enumer = this.m_Accounts.elements();
        while (enumer.hasMoreElements()) {
            PayAccount tmp = (PayAccount)enumer.nextElement();
            if (tmp.getAccountNumber() != newAccount.getAccountNumber() || tmp.getPrivateKey() == null && newAccount.getPrivateKey() != null) continue;
            if (tmp.getPIID() == newAccount.getPIID()) {
                throw new AccountAlreadyExistingException();
            }
            if (tmp.getPIID() == null || newAccount.getPIID() == null || !tmp.getPIID().equals(newAccount.getPIID())) continue;
            throw new AccountAlreadyExistingException();
        }
        newAccount.addAccountListener(this.m_MyAccountListener);
        newAccount.addMessageListener(this);
        this.m_Accounts.addElement(newAccount);
        if (newAccount.isUsed()) {
            this.m_bIsNewUser = false;
        }
        if (this.m_ActiveAccount == null && newAccount.getPrivateKey() != null) {
            this.m_ActiveAccount = newAccount;
            activeChanged = true;
        }
        if (this.getAffiliate(newAccount.getPIID(), true) == null && newAccount.getAffiliate() != null) {
            this.m_hashAffiliate.put(newAccount.getPIID(), newAccount.getAffiliate());
        }
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            IPaymentListener pl;
            Enumeration enumListeners = this.m_paymentListeners.elements();
            while (enumListeners.hasMoreElements()) {
                pl = (IPaymentListener)enumListeners.nextElement();
                pl.accountAdded(newAccount);
                if (!activeChanged) continue;
                pl.accountActivated(newAccount);
            }
            enumListeners = null;
            pl = null;
        }
    }

    public int getNumAccounts() {
        return this.m_Accounts.size();
    }

    public synchronized PayAccount getAccountAt(int rowIndex) {
        return (PayAccount)this.m_Accounts.elementAt(rowIndex);
    }

    public boolean isInitialized() {
        return m_bIsInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaymentListener(IPaymentListener listener) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            if (listener != null) {
                this.m_paymentListeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaymentListener(IPaymentListener a_listener) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            if (this.m_paymentListeners.contains(a_listener)) {
                this.m_paymentListeners.removeElement(a_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IMessageListener listener) {
        Vector vector = this.m_messageListeners;
        synchronized (vector) {
            if (listener != null) {
                this.m_messageListeners.addElement(listener);
            }
        }
    }

    private void fireMessageReceived(PayMessage message) {
        Enumeration enumListeners = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumListeners.hasMoreElements()) {
            ((IMessageListener)enumListeners.nextElement()).messageReceived(message);
        }
    }

    private void fireMessageRemoved(PayMessage message) {
        Enumeration enumListeners = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumListeners.hasMoreElements()) {
            ((IMessageListener)enumListeners.nextElement()).messageRemoved(message);
        }
    }

    public PayAccount createAccount(PaymentInstanceDBEntry a_bi, XMLGenericText a_terms) throws Exception {
        AsymmetricCryptoKeyPair keyPair = this.createAccountKeyPair();
        if (keyPair == null) {
            return null;
        }
        return this.createAccount(a_bi, keyPair, a_terms);
    }

    public static boolean isNewUserLetter(char a_startingLetter) {
        return a_startingLetter == 'X' || a_startingLetter == 'Y';
    }

    public static boolean isPromotionLetter(char a_startingLetter) {
        return a_startingLetter == 'P';
    }

    public boolean isNewUserAllowed(String a_code) {
        if (a_code == null) {
            return true;
        }
        return !PayAccountsFile.isNewUserLetter(a_code.charAt(0)) || this.isNewUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateCouponCode(String a_code, PayAccount a_account, boolean a_bPreCheckOnly) throws Exception {
        boolean bValid = true;
        if (a_account == null) {
            throw new NullPointerException("No account given!");
        }
        if ((a_code = PayAccount.checkCouponCode(a_code)) == null) {
            return false;
        }
        BIConnection piConn = null;
        if (a_bPreCheckOnly) {
            bValid = false;
            piConn = new BIConnection(a_account.getBI());
            try {
                piConn.connect();
                piConn.authenticate(a_account);
                bValid = piConn.checkCouponCode(a_code, a_account);
                Object var7_6 = null;
                piConn.disconnect();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                piConn.disconnect();
                throw throwable;
            }
            if (!this.isNewUserAllowed(a_code)) {
                return false;
            }
            return bValid;
        }
        XMLPassivePayment paymentToSend = new XMLPassivePayment(a_account.getPIID());
        paymentToSend.addData("code", a_code);
        paymentToSend.setPaymentName(METHOD_COUPON);
        long accNum = a_account.getAccountNumber();
        paymentToSend.addData("accountnumber", new Long(accNum).toString());
        piConn = null;
        try {
            piConn = new BIConnection(a_account.getBI());
            piConn.connect();
            piConn.authenticate(a_account);
            if (!piConn.sendPassivePayment(paymentToSend, a_account)) {
                bValid = false;
            }
            Object var10_11 = null;
            if (piConn != null) {
                piConn.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (piConn != null) {
                piConn.disconnect();
            }
            throw throwable;
        }
        if (!bValid) {
            throw new Exception("Coupon code was not accepted when charging at the payment instance!");
        }
        return true;
    }

    public PayAccount createAccount(PaymentInstanceDBEntry a_bi, AsymmetricCryptoKeyPair a_keyPair, XMLGenericText a_terms) throws Exception {
        return this.createAccount(a_bi, a_keyPair, a_terms, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayAccount createAccount(PaymentInstanceDBEntry a_bi, AsymmetricCryptoKeyPair a_keyPair, XMLGenericText a_terms, boolean a_bLock) throws Exception {
        XMLAccountCertificate cert;
        XMLJapPublicKey xmlKey = new XMLJapPublicKey(a_keyPair.getPublic());
        LogHolder.log(7, LogType.PAY, "Attempting to create account at PI " + a_bi.getName());
        BIConnection biConn = new BIConnection(a_bi);
        biConn.addConnectionListener(this);
        try {
            biConn.connect();
            cert = biConn.registerNewAccount(xmlKey, a_keyPair.getPrivate());
            Object var9_8 = null;
            biConn.disconnect();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            biConn.disconnect();
            throw throwable;
        }
        PayAccount newAccount = new PayAccount(cert, a_keyPair.getPrivate(), a_bi, a_terms, a_bLock);
        this.addAccount(newAccount);
        return newAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAccountRequest(MixCascade a_connectedCascade) throws AccountEmptyException {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            Enumeration enumListeners = this.m_paymentListeners.elements();
            while (enumListeners.hasMoreElements()) {
                ((IPaymentListener)enumListeners.nextElement()).accountCertRequested(a_connectedCascade);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAccountError(XMLErrorMessage msg) {
        PayAccount account;
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            IPaymentListener currentListener = null;
            Enumeration enumListeners = this.m_paymentListeners.elements();
            while (enumListeners.hasMoreElements()) {
                currentListener = (IPaymentListener)enumListeners.nextElement();
                currentListener.accountError(msg, this.m_bIgnoreAIAccountErrorMessages);
            }
        }
        if (msg.getXmlErrorCode() == 21 && (account = this.getAccount(msg.getAccountNumber(), msg.getPIID())) != null) {
            account.setBlocked(true);
            this.m_MyAccountListener.accountChanged(account);
        }
    }

    public Vector getPaymentInstances(boolean a_bProductiveOnly) {
        Vector vecPIs = Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PayAccountsFile.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryList();
        Vector retPIs = new Vector();
        for (int i = 0; i < vecPIs.size(); ++i) {
            if (a_bProductiveOnly == ((PaymentInstanceDBEntry)vecPIs.elementAt(i)).isTest()) continue;
            retPIs.addElement(vecPIs.elementAt(i));
        }
        return retPIs;
    }

    public Vector getPaymentInstances() {
        return Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PayAccountsFile.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryList();
    }

    public PaymentInstanceDBEntry getBI(String a_piID) {
        PaymentInstanceDBEntry theBI = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PayAccountsFile.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(a_piID);
        return theBI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotCaptcha(ICaptchaSender a_source, IImageEncodedCaptcha a_captcha) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            Enumeration enumListeners = this.m_paymentListeners.elements();
            while (enumListeners.hasMoreElements()) {
                ((IPaymentListener)enumListeners.nextElement()).gotCaptcha(a_source, a_captcha);
            }
        }
    }

    public void messageReceived(PayMessage message) {
        this.fireMessageReceived(message);
    }

    public void messageRemoved(PayMessage message) {
        this.fireMessageRemoved(message);
    }

    protected void finalize() {
        if (this.m_keyPool != null) {
            this.m_keyPool.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyAccountListener
    implements IAccountListener {
        private MyAccountListener() {
        }

        public void accountChanged(PayAccount acc) {
            Enumeration enumListeners = ((Vector)PayAccountsFile.this.m_paymentListeners.clone()).elements();
            if (acc != null) {
                String strAffiliate = acc.getAffiliate();
                if (strAffiliate != null && PayAccountsFile.this.getAffiliate(acc.getPIID(), true) == null) {
                    PayAccountsFile.this.m_hashAffiliate.put(acc.getPIID(), strAffiliate);
                }
                while (enumListeners.hasMoreElements()) {
                    ((IPaymentListener)enumListeners.nextElement()).creditChanged(acc);
                }
                if (acc.isUsed()) {
                    PayAccountsFile.this.m_bIsNewUser = false;
                }
            }
        }
    }

    public static class AccountAlreadyExistingException
    extends Exception {
    }

    public static interface IAffiliateOptOut {
        public boolean isAffiliateAllowed();
    }
}

