/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.proxy.AbstractHTTPConnectionListener;
import anon.proxy.HTTPConnectionEvent;
import anon.proxy.HTTPProxyCallback;

public abstract class AbstractJonDoFoxHeaders
extends AbstractHTTPConnectionListener {
    public static final String HTTP_ENCODING_GZIP = "gzip";
    public static final String HTTP_ENCODING_DEFLATE = "deflate";
    public static final String USER_AGENT_JONDOFOX = "Mozilla/5.0 (Windows NT 6.1; rv:17.0) Gecko/17.0 Firefox/17.0";
    public static final String USER_AGENT_JONDOFOX_OLD = "Mozilla/5.0 (Windows NT 6.1; rv:10.0) Gecko/20100101 Firefox/10.0";
    public static final String USER_AGENT_TORBUTTON = "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.3) Gecko/20100401 Firefox/3.6.3";
    public static final String USER_AGENT_TORBUTTON_OLD = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.7) Gecko/2009021910 Firefox/3.0.7";
    public static final String JONDOFOX_LANGUAGE_NEW = "en-us";
    public static final String JONDOFOX_CHARSET = "utf-8,*";
    public static final String JONDOFOX_CONTENT_TYPES = "text/html,application/xml,*/*";
    public static final String JONDOFOX_ENCODING = "gzip, deflate";
    public static final String HTTP_DO_NOT_TRACK = "DNT";

    public AbstractJonDoFoxHeaders(int a_priority) {
        super(a_priority);
    }

    protected boolean checkJonDoFox(HTTPConnectionEvent event) {
        HTTPProxyCallback.HTTPConnectionHeader connHeader = event.getConnectionHeader();
        int iJonDoFoxRecognized = 2;
        boolean bProxyKeepAlive = false;
        String[] checkHeader = connHeader.getRequestHeader("Keep-Alive");
        if (checkHeader != null && checkHeader.length >= 1) {
            bProxyKeepAlive = true;
        }
        if ((checkHeader = connHeader.getRequestHeader("Proxy-Connection")) != null && checkHeader.length >= 1 && checkHeader[0].toLowerCase().equals("Keep-Alive")) {
            bProxyKeepAlive = true;
        }
        if (event.getAnonRequest().isProxyKeepAliveEnabled()) {
            bProxyKeepAlive = true;
        }
        if (bProxyKeepAlive) {
            --iJonDoFoxRecognized;
        }
        if ((checkHeader = connHeader.getRequestHeader("User-Agent")) == null || checkHeader.length != 1 || !checkHeader[0].equals(USER_AGENT_JONDOFOX) && !checkHeader[0].equals(USER_AGENT_JONDOFOX_OLD)) {
            --iJonDoFoxRecognized;
        }
        if ((checkHeader = connHeader.getRequestHeader("Accept-Language")) == null || checkHeader.length != 1 || !checkHeader[0].equals(JONDOFOX_LANGUAGE_NEW)) {
            --iJonDoFoxRecognized;
        }
        if ((checkHeader = connHeader.getRequestHeader("Accept-Encoding")) == null || checkHeader.length != 1 || !checkHeader[0].equals(JONDOFOX_ENCODING)) {
            --iJonDoFoxRecognized;
        }
        if ((checkHeader = connHeader.getRequestHeader("Accept-Charset")) != null && checkHeader.length >= 1) {
            --iJonDoFoxRecognized;
        }
        return iJonDoFoxRecognized >= 0;
    }
}

