/*
 * Decompiled with CFR 0.152.
 */
package anon.tor.ordescription;

import anon.crypto.MyRandom;
import anon.tor.ordescription.ORDescriptor;
import anon.tor.ordescription.ORListFetcher;
import anon.tor.util.Base16;
import anon.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class ORList {
    private Vector m_onionrouters = new Vector();
    private Vector m_exitnodes = new Vector();
    private Vector m_middlenodes = new Vector();
    private Hashtable m_onionroutersWithNames = new Hashtable();
    private MyRandom m_rand;
    private ORListFetcher m_orlistFetcher;
    private Date m_datePublished;
    private int m_countHibernate;
    private static final DateFormat ms_DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ORList(ORListFetcher fetcher) {
        this.m_orlistFetcher = fetcher;
        this.m_countHibernate = 0;
        this.m_rand = new MyRandom();
    }

    public synchronized int size() {
        return this.m_onionrouters.size();
    }

    public synchronized int active() {
        return this.size() - this.m_countHibernate;
    }

    public synchronized void setFetcher(ORListFetcher fetcher) {
        this.m_orlistFetcher = fetcher;
    }

    public synchronized boolean updateList() {
        try {
            byte[] buff = null;
            if (this.size() == 0 || (buff = this.m_orlistFetcher.getRouterStatus()) == null) {
                buff = this.m_orlistFetcher.getAllDescriptors();
                if (buff == null) {
                    return false;
                }
                return this.parseFirstDocument(buff);
            }
            return this.parseStatus(buff, true);
        }
        catch (Throwable t) {
            LogHolder.log(7, LogType.TOR, "There was a problem with fetching the available ORRouters: " + t.getMessage());
            return false;
        }
    }

    public Vector getList() {
        return (Vector)this.m_onionrouters.clone();
    }

    public Date getPublished() {
        return this.m_datePublished;
    }

    public synchronized ORDescriptor getByName(String name) {
        return (ORDescriptor)this.m_onionroutersWithNames.get(name);
    }

    public synchronized void remove(String name) {
        ORDescriptor ord = this.getByName(name);
        if (ord == null) {
            return;
        }
        this.m_onionrouters.removeElement(ord);
        if (ord.isExitNode()) {
            this.m_exitnodes.removeElement(ord);
        } else {
            this.m_middlenodes.removeElement(ord);
        }
        this.m_onionroutersWithNames.remove(name);
    }

    public synchronized void add(ORDescriptor ord) {
        if (ord.isExitNode()) {
            this.m_exitnodes.addElement(ord);
        } else {
            this.m_middlenodes.addElement(ord);
        }
        this.m_onionrouters.addElement(ord);
        this.m_onionroutersWithNames.put(ord.getName(), ord);
        LogHolder.log(7, LogType.TOR, "Added: " + ord);
    }

    public synchronized ORDescriptor getByRandom(Vector allowedNames) {
        ORDescriptor ord;
        if (this.active() == 0) {
            return null;
        }
        do {
            String orName;
            if ((ord = this.getByName(orName = (String)allowedNames.elementAt(this.m_rand.nextInt(allowedNames.size())))) != null) continue;
            return null;
        } while (ord.getHibernate());
        return ord;
    }

    public synchronized ORDescriptor getByRandom() {
        ORDescriptor ord;
        if (this.active() == 0) {
            return null;
        }
        while ((ord = (ORDescriptor)this.m_onionrouters.elementAt(this.m_rand.nextInt(this.m_onionrouters.size()))).getHibernate()) {
        }
        return ord;
    }

    public synchronized ORDescriptor getByRandom(int length) {
        ORDescriptor ord;
        if (this.active() == 0) {
            return null;
        }
        int number_of_routers = this.m_onionrouters.size();
        int numerator = length * this.m_exitnodes.size() - number_of_routers;
        int denominator = (length - 1) * number_of_routers;
        denominator *= 2;
        while ((ord = this.m_rand.nextInt(denominator) > numerator ? (ORDescriptor)this.m_middlenodes.elementAt(this.m_rand.nextInt(this.m_middlenodes.size())) : (ORDescriptor)this.m_exitnodes.elementAt(this.m_rand.nextInt(this.m_exitnodes.size()))).getHibernate()) {
        }
        return ord;
    }

    public synchronized ORDescriptor getORDescriptor(String name) {
        if (this.m_onionroutersWithNames.containsKey(name)) {
            return (ORDescriptor)this.m_onionroutersWithNames.get(name);
        }
        return null;
    }

    private boolean parseStatus(byte[] document, boolean change) throws Exception {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(document)));
        Date published = null;
        String curLine = reader.readLine();
        boolean hibernate = false;
        if (curLine == null || !curLine.startsWith("network-status-version")) {
            return false;
        }
        while (true) {
            byte[] b;
            String version;
            StringTokenizer st;
            reader.mark(200);
            curLine = reader.readLine();
            if (curLine == null) break;
            if (curLine.startsWith("published")) {
                st = new StringTokenizer(curLine, " ");
                st.nextToken();
                String strPublished = st.nextToken();
                strPublished = strPublished + " " + st.nextToken();
                published = ms_DateFormat.parse(strPublished);
                continue;
            }
            if (!curLine.startsWith("r ")) continue;
            st = new StringTokenizer(curLine, " ");
            st.nextToken();
            String nick = st.nextToken();
            String hashKey = st.nextToken() + "=";
            String hashDescriptor = st.nextToken() + "=";
            String strPublished = st.nextToken();
            strPublished = strPublished + " " + st.nextToken();
            String address = st.nextToken();
            Vector<String> options = new Vector<String>();
            int port = Integer.parseInt(st.nextToken());
            reader.mark(200);
            curLine = reader.readLine();
            if (!curLine.startsWith("s ")) {
                reader.reset();
            } else {
                st = new StringTokenizer(curLine);
                st.nextToken();
                while (st.hasMoreTokens()) {
                    options.addElement(st.nextToken());
                }
            }
            curLine = reader.readLine();
            if (curLine.startsWith("v ")) {
                version = curLine.substring(2);
            } else if (curLine.startsWith("opt v ")) {
                version = curLine.substring(6);
            } else {
                reader.reset();
            }
            ORDescriptor ord = this.getORDescriptor(nick);
            String digest = Base16.encode(Base64.decode(hashDescriptor));
            if (ord != null && ord.getHash() != null && digest.equals(ord.getHash()) || (b = this.m_orlistFetcher.getDescriptor(digest)) == null) continue;
            if (ord != null && ord.getHibernate()) {
                hibernate = true;
            }
            this.remove(nick);
            LineNumberReader l = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(b)));
            ord = ORDescriptor.parse(l);
            ord.setHash(digest);
            if (hibernate && !ord.getHibernate()) {
                --this.m_countHibernate;
            }
            this.add(ord);
        }
        return true;
    }

    private synchronized boolean parseFirstDocument(byte[] document) throws Exception {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(document)));
        Date published = new Date();
        reader.mark(200);
        String curLine = reader.readLine();
        if (curLine == null) {
            return false;
        }
        this.m_countHibernate = 0;
        this.m_onionrouters = new Vector();
        this.m_exitnodes = new Vector();
        this.m_middlenodes = new Vector();
        this.m_onionroutersWithNames = new Hashtable();
        do {
            if (curLine.startsWith("router ")) {
                reader.reset();
                ORDescriptor ord = ORDescriptor.parse(reader);
                if (ord != null) {
                    if (ord.getHibernate()) {
                        ++this.m_countHibernate;
                    }
                    this.add(ord);
                }
            }
            reader.mark(200);
        } while ((curLine = reader.readLine()) != null && curLine != null);
        LogHolder.log(7, LogType.TOR, "Exit Nodes : " + this.m_exitnodes.size() + " Non-Exit Nodes : " + this.m_middlenodes.size());
        this.m_datePublished = published;
        return true;
    }

    static {
        ms_DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

