/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.ApplicationAdapter;
import com.skype.Friend;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.StreamListener;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.NotificationChecker;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Stream
extends SkypeObject {
    private final Application application;
    private final String id;
    private Vector listeners = new Vector();
    private SkypeExceptionHandler exceptionHandler;

    Stream(Application newApplication, String newId) {
        this.application = newApplication;
        this.id = newId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof Stream) {
            Stream comparedStream = (Stream)compared;
            return this.getId().equals(comparedStream.getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public Application getApplication() {
        return this.application;
    }

    public String getId() {
        return this.id;
    }

    public Friend getFriend() {
        return User.getFriendInstance(this.getId().substring(0, this.getId().indexOf(58)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text) throws SkypeException {
        Utils.checkNotNull(text, "text");
        try {
            NotificationChecker checker = new NotificationChecker(){

                public boolean isTarget(String message) {
                    if (message.startsWith("APPLICATION " + Stream.this.getApplication().getName() + " SENDING ")) {
                        String data = message.substring(("APPLICATION " + Stream.this.getApplication().getName() + " SENDING ").length());
                        if ("".equals(data)) {
                            return true;
                        }
                        String[] streams = data.split(" ");
                        for (int i = 0; i < streams.length; ++i) {
                            String stream = streams[i];
                            if (!(stream = stream.substring(0, stream.indexOf(61))).equals(Stream.this.getId())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
            String header = "ALTER APPLICATION " + this.getApplication().getName() + " WRITE " + this.getId();
            ApplicationAdapter applicationListener = null;
            try {
                final Future future = Connector.getInstance().waitForEndWithId(header + " " + text, header, checker);
                applicationListener = new ApplicationAdapter(){

                    public void disconnected(Stream stream) throws SkypeException {
                        if (stream == Stream.this) {
                            future.cancel(true);
                        }
                    }
                };
                this.application.addApplicationListener(applicationListener);
                try {
                    Utils.checkError((String)future.get());
                }
                catch (CancellationException e) {
                    throw new SkypeException("The '" + this.getId() + "' stream is closed.", e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ConnectorException) {
                        throw (ConnectorException)e.getCause();
                    }
                    throw new SkypeException("The '" + header + " " + text + "' command failed.", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SkypeException("The thread is interrupted.", e);
                }
                if (applicationListener != null) {
                    this.application.removeApplicationListener(applicationListener);
                }
            }
            catch (Throwable throwable) {
                if (applicationListener != null) {
                    this.application.removeApplicationListener(applicationListener);
                }
                throw throwable;
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void send(String datagram) throws SkypeException {
        Utils.checkNotNull(datagram, "datagram");
        try {
            String resposeHeader = "ALTER APPLICATION " + this.getApplication().getName() + " DATAGRAM " + this.getId();
            String command = resposeHeader + " " + datagram;
            String result = Connector.getInstance().execute(command, resposeHeader);
            Utils.checkError(result);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void addStreamListener(StreamListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeStreamListener(StreamListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    void fireTextReceived(String text) {
        StreamListener[] tmpListeners = this.listeners.toArray(new StreamListener[0]);
        for (int i = 0; i < tmpListeners.length; ++i) {
            StreamListener listener = tmpListeners[i];
            try {
                listener.textReceived(text);
                continue;
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    void fireDatagramReceived(String datagram) {
        StreamListener[] tmpListeners = this.listeners.toArray(new StreamListener[0]);
        for (int i = 0; i < tmpListeners.length; ++i) {
            StreamListener listener = tmpListeners[i];
            try {
                listener.datagramReceived(datagram);
                continue;
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public void disconnect() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("ALTER APPLICATION " + this.application.getName() + " DISCONNECT " + this.getId());
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }
}

