/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DateListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import logging.LogHolder;
import logging.LogType;

public class DatePanel
extends JPanel
implements ItemListener {
    private Vector<DateListener> m_dateListeners = new Vector();
    private final int[] m_daysPerMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final String[] m_months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private JComboBox m_cbDay;
    private JComboBox m_cbMonth;
    private JComboBox m_cbYear;
    private DefaultComboBoxModel m_modelDay;
    private DefaultComboBoxModel m_modelMonth;
    private DefaultComboBoxModel m_modelYear;
    private Calendar m_cal = null;
    private boolean m_bSuppressEvents = false;

    public DatePanel(Date date) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_modelDay = new DefaultComboBoxModel();
        this.m_cbDay = new JComboBox(this.m_modelDay);
        this.m_cbDay.addItemListener(this);
        constraints.insets.left = 0;
        this.add((Component)this.m_cbDay, constraints);
        constraints.insets.left = 5;
        this.m_modelMonth = new DefaultComboBoxModel<String>(this.m_months);
        this.m_cbMonth = new JComboBox(this.m_modelMonth);
        this.m_cbMonth.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char key, ComboBoxModel cbm) {
                int nr = key - 48;
                if (nr < 0 || nr > 9) {
                    return -1;
                }
                if (nr < 3 && DatePanel.this.m_cbMonth.getSelectedIndex() == 0) {
                    nr = 10 + nr;
                }
                return nr - 1;
            }
        });
        this.m_cbMonth.addItemListener(this);
        ++constraints.gridx;
        this.add((Component)this.m_cbMonth, constraints);
        this.m_modelYear = new DefaultComboBoxModel<Object>(this.createArray(2000, 2030));
        this.m_cbYear = new JComboBox(this.m_modelYear);
        this.m_cbYear.addItemListener(this);
        ++constraints.gridx;
        constraints.insets.right = 0;
        this.add((Component)this.m_cbYear, constraints);
        this.setDate(date);
    }

    private void updateDays() {
        Object selectedDay = this.m_cbDay.getSelectedItem();
        int monthIndex = this.m_cbMonth.getSelectedIndex();
        int numberOfDays = this.m_daysPerMonth[this.m_cbMonth.getSelectedIndex()];
        int year = new Integer(this.m_cbYear.getSelectedItem().toString());
        if (this.isLeapYear(year) && monthIndex == 1) {
            LogHolder.log(7, LogType.MISC, "Leap year + month is February --> 29 days");
            numberOfDays = 29;
        }
        this.m_modelDay = new DefaultComboBoxModel<Object>(this.createArray(1, numberOfDays));
        this.m_cbDay.setModel(this.m_modelDay);
        if (selectedDay != null) {
            this.m_cbDay.setSelectedItem(selectedDay);
        } else {
            this.m_cbDay.setSelectedIndex(0);
        }
    }

    private boolean isLeapYear(int year) {
        boolean ret = false;
        if (year % 4 == 0) {
            if (year % 100 != 0) {
                ret = true;
            } else if (year % 400 == 0) {
                ret = true;
            }
        }
        return ret;
    }

    private Object[] createArray(int start, int end) {
        if (end <= start) {
            return null;
        }
        int size = end - start + 1;
        Object[] ret = new Object[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = start++;
        }
        return ret;
    }

    private boolean dateHasChanged() {
        boolean ret = false;
        Calendar newCal = this.getCalendar();
        if (this.m_cal == null || this.m_cal.get(5) != newCal.get(5) || this.m_cal.get(2) != newCal.get(2) || this.m_cal.get(1) != newCal.get(1)) {
            LogHolder.log(7, LogType.MISC, "The date has changed ..");
            ret = true;
        }
        this.m_cal = newCal;
        return ret;
    }

    public void setDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        this.m_bSuppressEvents = true;
        this.m_cbYear.setSelectedItem(cal.get(1));
        this.m_cbMonth.setSelectedIndex(cal.get(2));
        this.m_cbDay.setSelectedItem(cal.get(5));
        this.m_bSuppressEvents = false;
        this.fireDateChanged();
    }

    public Calendar getCalendar() throws NumberFormatException {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int year = new Integer(this.m_cbYear.getSelectedItem().toString());
        int month = this.m_cbMonth.getSelectedIndex();
        int day = new Integer(this.m_cbDay.getSelectedItem().toString());
        cal.set(year, month, day);
        return cal;
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    @Override
    public void itemStateChanged(ItemEvent a_event) {
        if ((a_event.getSource() == this.m_cbMonth || a_event.getSource() == this.m_cbYear) && a_event.getStateChange() == 1) {
            this.updateDays();
        }
        if (a_event.getStateChange() == 1 && !this.m_bSuppressEvents && this.dateHasChanged()) {
            this.fireDateChanged();
        }
    }

    protected void fireDateChanged() {
        for (int i = 0; i < this.m_dateListeners.size(); ++i) {
            this.m_dateListeners.elementAt(i).dateChanged();
        }
    }

    public void addDateListener(DateListener a_dateListener) {
        this.removeDateListener(a_dateListener);
        this.m_dateListeners.addElement(a_dateListener);
    }

    public void removeDateListener(DateListener a_dateListener) {
        this.m_dateListeners.removeElement(a_dateListener);
    }
}

