/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import anon.util.JAPMessages;
import anon.util.XMLParseException;
import gui.GUIUtils;
import gui.JAPHelpContext;
import gui.dialog.CADialog;
import gui.dialog.JAPDialog;
import gui.dialog.ProxyDialog;
import gui.help.JAPHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Proxy;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.event.ChangeEvent;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ChoicePanel;
import mixconfig.ConfigFrame;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.tools.CertificationTool;
import mixconfig.tools.CrimeLogProcessing;
import mixconfig.tools.DataRetentionLogDecrypt;
import mixconfig.tools.EmailComposer;
import mixconfig.tools.EncryptedLogTool;
import mixconfig.tools.TemplateSigningTool;
import mixconfig.wizard.ConfigWizard;

public class Menu
implements ActionListener,
JAPHelpContext.IHelpContext {
    public static final String CMD_OPEN_FILE = "Open";
    public static final String CMD_OPEN_FILE_WIZARD = "OpenWizard";
    public static final String CMD_RESET = "Reset";
    public static final String CMD_NEW_FROM_CANCEL = "New_from_Cancel";
    private static final String WIZARD = "wizard";
    private static final String EXPERT = "expert";
    private static final String START = "start";
    private static final String MSG_NO_VALID_CLIPDOC = Menu.class.getName() + "_noValidClipdoc";
    private static final String MSG_COULD_NOT_PARSE = Menu.class.getName() + "_couldNotParse";
    private static final String MSG_REALLY_CONTINUE = Menu.class.getName() + "_reallyContinue";
    private static final String MSG_FILE = Menu.class.getName() + "_file";
    private static final String MSG_TOOLS = Menu.class.getName() + "_tools";
    private static final String MSG_VIEW = Menu.class.getName() + "_view";
    private static final String MSG_EMAIL = Menu.class.getName() + "_email";
    private static final String MSG_IGNORE_INCONSISTENCIES = Menu.class.getName() + "_ignoreInconsistencies";
    private JFrame m_mainWin;
    private JMenuBar m_MenuBar;
    private ConfigFrame m_configFrame_Panel;
    private ConfigWizard m_configWiz_Panel;
    private JMenuItem m_defaultSize;
    private JCheckBoxMenuItem m_changeViewToWizMenuItem;
    private JCheckBoxMenuItem m_changeViewToExpertMenuItem;
    private JMenuItem m_saveMenuItem;
    private JMenuItem m_saveAsMenuItem;
    private JMenuItem m_saveclipItem;
    private JMenuItem m_checkItem;
    private JMenuItem m_proxyItem;
    private JMenuItem m_newMenuItem;
    private JMenuItem m_openMenuItem;
    private JMenuItem m_openclipItem;
    protected JMenuItem m_helpTopics;
    private JMenu m_toolsMenu;
    private JMenu m_fileMenu;

    public Menu(JFrame mainWin, JRootPane rootPane, ConfigWizard configWiz_Panel, ConfigFrame configFrame_Panel) {
        this.m_mainWin = mainWin;
        this.m_configFrame_Panel = configFrame_Panel;
        this.m_configWiz_Panel = configWiz_Panel;
        this.m_MenuBar = new JMenuBar();
        if (this.m_mainWin != null) {
            this.m_mainWin.setJMenuBar(this.m_MenuBar);
        } else if (rootPane != null) {
            rootPane.setJMenuBar(this.m_MenuBar);
        }
        this.m_fileMenu = new JMenu(JAPMessages.getString(MSG_FILE));
        this.m_fileMenu.setMnemonic(JAPMessages.getString(MSG_FILE).charAt(0));
        this.m_MenuBar.add(this.m_fileMenu);
        this.m_toolsMenu = new JMenu(JAPMessages.getString(MSG_TOOLS));
        this.m_toolsMenu.setMnemonic(JAPMessages.getString(MSG_TOOLS).charAt(0));
        this.m_MenuBar.add(this.m_toolsMenu);
        JMenu viewMenu = new JMenu(JAPMessages.getString(MSG_VIEW));
        viewMenu.setMnemonic(JAPMessages.getString(MSG_VIEW).charAt(0));
        this.m_MenuBar.add(viewMenu);
        JMenu helpMenu = new JMenu(JAPMessages.getString(JAPHelp.MSG_HELP_BUTTON));
        helpMenu.setMnemonic(JAPMessages.getString(JAPHelp.MSG_HELP_BUTTON).charAt(0));
        this.m_MenuBar.add(helpMenu);
        this.m_newMenuItem = new JMenuItem("New");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        this.m_openMenuItem = new JMenuItem("Open ...");
        this.m_openclipItem = new JMenuItem("Open from clipboard");
        this.m_checkItem = new JMenuItem("Check");
        this.m_checkItem.setEnabled(false);
        this.m_proxyItem = new JMenuItem("Proxy");
        this.m_proxyItem.setEnabled(true);
        this.m_saveMenuItem = new JMenuItem();
        String curFileName = MixConfig.getCurrentFileName();
        if (curFileName == null) {
            curFileName = "none";
            this.m_saveMenuItem.setEnabled(false);
        }
        this.m_saveMenuItem.setText("Save [" + curFileName + "] ");
        this.m_saveclipItem = new JMenuItem("Save to clipboard");
        this.m_saveclipItem.setEnabled(false);
        this.m_saveAsMenuItem = new JMenuItem("Save as ...");
        this.m_saveAsMenuItem.setEnabled(false);
        this.m_newMenuItem.addActionListener(this);
        exitMenuItem.addActionListener(this);
        this.m_openMenuItem.addActionListener(this);
        this.m_openclipItem.addActionListener(this);
        this.m_checkItem.addActionListener(this);
        this.m_proxyItem.addActionListener(this);
        this.m_saveMenuItem.addActionListener(this);
        this.m_saveclipItem.addActionListener(this);
        this.m_saveAsMenuItem.addActionListener(this);
        this.m_newMenuItem.setActionCommand("New");
        exitMenuItem.setActionCommand("Exit");
        this.m_openMenuItem.setActionCommand(CMD_OPEN_FILE);
        this.m_saveclipItem.setActionCommand("SaveClip");
        this.m_openclipItem.setActionCommand("OpenClip");
        this.m_checkItem.setActionCommand("Check");
        this.m_proxyItem.setActionCommand("Proxy");
        this.m_saveMenuItem.setActionCommand("Save");
        this.m_saveAsMenuItem.setActionCommand("SaveAs");
        if (this.m_mainWin == null) {
            exitMenuItem.setEnabled(false);
            this.m_openMenuItem.setEnabled(false);
            this.m_saveAsMenuItem.setEnabled(false);
        }
        this.m_fileMenu.add(this.m_newMenuItem);
        this.m_fileMenu.addSeparator();
        this.m_fileMenu.add(this.m_openMenuItem);
        this.m_fileMenu.add(this.m_openclipItem);
        this.m_fileMenu.addSeparator();
        this.m_fileMenu.add(this.m_checkItem);
        this.m_fileMenu.add(this.m_proxyItem);
        this.m_fileMenu.add(this.m_saveMenuItem);
        this.m_fileMenu.add(this.m_saveAsMenuItem);
        this.m_fileMenu.add(this.m_saveclipItem);
        this.m_fileMenu.addSeparator();
        this.m_fileMenu.add(exitMenuItem);
        JMenuItem toolEmailMenuItem = new JMenuItem(JAPMessages.getString(MSG_EMAIL));
        this.m_toolsMenu.add(toolEmailMenuItem);
        toolEmailMenuItem.setActionCommand("toolEmailMenuItem");
        toolEmailMenuItem.addActionListener(this);
        JMenuItem toolCertSigMenuItem = new JMenuItem("Sign X.509 certificate ...");
        this.m_toolsMenu.add(toolCertSigMenuItem);
        toolCertSigMenuItem.setActionCommand("toolCertSigMenuItem");
        toolCertSigMenuItem.addActionListener(this);
        JMenuItem toolEncLogMenuItem = new JMenuItem("Display encrypted mix log ...");
        this.m_toolsMenu.add(toolEncLogMenuItem);
        toolEncLogMenuItem.setActionCommand("toolEncLogMenuItem");
        toolEncLogMenuItem.addActionListener(this);
        JMenuItem toolDataRetentionLogMenuItem = new JMenuItem("Process retained Data ...");
        this.m_toolsMenu.add(toolDataRetentionLogMenuItem);
        toolDataRetentionLogMenuItem.setActionCommand("toolDataRetentionLogMenuItem");
        toolDataRetentionLogMenuItem.addActionListener(this);
        JMenuItem toolLawEnforcementLogMenuItem = new JMenuItem("Process Law Enforcement Data ...");
        this.m_toolsMenu.add(toolLawEnforcementLogMenuItem);
        toolLawEnforcementLogMenuItem.setActionCommand("toolLawEnforcementLogMenuItem");
        toolLawEnforcementLogMenuItem.addActionListener(this);
        JMenuItem toolCertViewMenuItem = new JMenuItem("View accepted CAs ...");
        this.m_toolsMenu.add(toolCertViewMenuItem);
        toolCertViewMenuItem.setActionCommand("toolCertViewMenuItem");
        toolCertViewMenuItem.addActionListener(this);
        JMenuItem toolTemplateSignerMenuItem = new JMenuItem("Sign T&C templates");
        this.m_toolsMenu.add(toolTemplateSignerMenuItem);
        toolTemplateSignerMenuItem.setActionCommand("toolTemplateSignerMenuItem");
        toolTemplateSignerMenuItem.addActionListener(this);
        this.m_changeViewToWizMenuItem = new JCheckBoxMenuItem("Wizard", false);
        viewMenu.add(this.m_changeViewToWizMenuItem);
        this.m_changeViewToWizMenuItem.setActionCommand("ChangeViewToWiz");
        this.m_changeViewToWizMenuItem.addActionListener(this);
        this.m_changeViewToExpertMenuItem = new JCheckBoxMenuItem("Expert", false);
        viewMenu.add(this.m_changeViewToExpertMenuItem);
        this.m_changeViewToExpertMenuItem.setActionCommand("ChangeViewToExpert");
        this.m_changeViewToExpertMenuItem.addActionListener(this);
        this.m_defaultSize = new JMenuItem("Default size");
        this.m_defaultSize.addActionListener(this);
        viewMenu.add(this.m_defaultSize);
        JMenuItem aboutMenuItem = new JMenuItem("About...");
        helpMenu.add(JAPHelp.createHelpMenuItem(this));
        helpMenu.add(aboutMenuItem);
        aboutMenuItem.setActionCommand("About");
        aboutMenuItem.addActionListener(this);
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    public void exit() {
        int exit = 0;
        if (!MixConfig.getMainWindow().isEnabled()) {
            return;
        }
        if (!MixConfig.getMixConfiguration().isSavedToFile()) {
            exit = JAPDialog.showConfirmDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_REALLY_CONTINUE), 2, 3);
        }
        if (0 == exit) {
            System.exit(0);
        }
    }

    public void reset(boolean a_bStartNewConfiguration) throws XMLParseException, IOException {
        boolean bReset = false;
        ChoicePanel cp = (ChoicePanel)this.m_configWiz_Panel.getParent();
        if (cp.getActiveCard().equals(START)) {
            cp.setExpertVisible();
            this.m_changeViewToWizMenuItem.setEnabled(true);
            this.m_changeViewToExpertMenuItem.setEnabled(false);
        } else {
            bReset = MixConfig.getMixConfiguration().isSavedToFile();
            if (!bReset) {
                int ok = JAPDialog.showConfirmDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_REALLY_CONTINUE), 2, 3);
                boolean bl = bReset = 0 == ok;
            }
        }
        if (bReset) {
            this.reset();
            if (!a_bStartNewConfiguration) {
                cp.setStartScreenVisible();
            }
            this.m_configWiz_Panel.changeButtonLabelToNext();
            this.m_configWiz_Panel.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            MixConfiguration mixConf = MixConfig.getMixConfiguration();
            if (evt.getActionCommand().equals(CMD_RESET)) {
                this.reset();
            } else if (evt.getSource() == this.m_defaultSize) {
                ((ChoicePanel)this.m_configWiz_Panel.getParent()).setDefaultSize();
            } else if (evt.getActionCommand().equals("New") || evt.getActionCommand().equals(CMD_NEW_FROM_CANCEL)) {
                this.reset(!evt.getActionCommand().equals(CMD_NEW_FROM_CANCEL));
            } else if (evt.getActionCommand().equals("Exit")) {
                this.exit();
            } else if (evt.getActionCommand().equals("Check")) {
                String[] msg = this.m_configFrame_Panel.check();
                if (msg != null && msg.length > 0) {
                    MixConfig.info("Inconsistencies found", msg, false);
                } else {
                    JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), "Configuration is valid.", "Check");
                }
                mixConf.performReloadCheck();
            } else if (evt.getActionCommand().equals("Proxy")) {
                Proxy proxy = ProxyDialog.showProxyDialog(MixConfig.getMainWindow(), MixConfig.getProxy());
                if (proxy != null) {
                    MixConfig.configureProxy(proxy);
                }
            } else if (evt.getActionCommand().equals("Save")) {
                if (this.ignoreInconsistenciesForSaving() && MixConfig.getCurrentFileName() != null && mixConf.performReloadCheck()) {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(MixConfig.getCurrentFileName()), "UTF-8");
                    mixConf.save(writer, true);
                    writer.close();
                }
            } else if (evt.getActionCommand().equals("SaveAs")) {
                if (this.ignoreInconsistenciesForSaving() && mixConf.performReloadCheck()) {
                    JFileChooser fileChooser = MixConfig.showFileDialog(MixConfig.getMainWindow(), 1, 2);
                    if (fileChooser == null) {
                        return;
                    }
                    File file = fileChooser.getSelectedFile();
                    if (file != null) {
                        String fname = file.getName();
                        if (!fname.toLowerCase().endsWith(".xml")) {
                            file = new File(file.getParent(), fname + ".xml");
                        }
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getCanonicalPath()), "UTF-8");
                        mixConf.save(writer, true);
                        this.m_saveMenuItem.setText("Save [" + file.getName() + "] ");
                        this.m_saveMenuItem.setEnabled(true);
                        MixConfig.setCurrentFilename(file.getCanonicalPath());
                    }
                }
            } else if (evt.getActionCommand().equals("SaveClip")) {
                if (this.ignoreInconsistenciesForSaving() && mixConf.performReloadCheck()) {
                    StringWriter sw = new StringWriter();
                    MixConfig.getMixConfiguration().save(sw, false);
                    String xmlString = sw.toString();
                    GUIUtils.saveTextToClipboard(xmlString, MixConfig.getMainWindow());
                }
            } else if (evt.getActionCommand().equals("OpenClip")) {
                String xmlString = GUIUtils.getTextFromClipboard(this.m_MenuBar);
                StringReader sr = new StringReader(xmlString);
                try {
                    mixConf.setMixConfiguration(sr);
                    this.m_configFrame_Panel.setConfiguration(mixConf);
                    this.m_configWiz_Panel.setConfiguration(mixConf);
                    ChoicePanel cp = (ChoicePanel)this.m_configWiz_Panel.getParent();
                    if (cp.getActiveCard().equals(START)) {
                        cp.setExpertVisible();
                        this.m_changeViewToWizMenuItem.setEnabled(true);
                        this.m_changeViewToExpertMenuItem.setEnabled(false);
                    }
                    this.m_configFrame_Panel.reset();
                    this.m_configWiz_Panel.reset();
                }
                catch (XMLParseException a_e) {
                    JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_NO_VALID_CLIPDOC), JAPMessages.getString(MSG_COULD_NOT_PARSE), (Throwable)a_e);
                }
            } else if (evt.getActionCommand().equals(CMD_OPEN_FILE) || evt.getActionCommand().equals(CMD_OPEN_FILE_WIZARD)) {
                File file = null;
                JFileChooser chooser = MixConfig.showFileDialog(MixConfig.getMainWindow(), 2, 2);
                if (chooser != null) {
                    file = chooser.getSelectedFile();
                }
                if (file != null && mixConf.setMixConfiguration(new FileReader(file))) {
                    this.m_configFrame_Panel.setConfiguration(mixConf);
                    this.m_configWiz_Panel.setConfiguration(mixConf);
                    this.m_saveMenuItem.setText("Save [" + file.getName() + "] ");
                    this.m_saveMenuItem.setEnabled(true);
                    MixConfig.setCurrentFilename(file.getCanonicalPath());
                    ChoicePanel cp = (ChoicePanel)this.m_configWiz_Panel.getParent();
                    if (evt.getActionCommand().equals(CMD_OPEN_FILE)) {
                        cp.setExpertVisible();
                    } else {
                        cp.setWizardVisible();
                    }
                    this.m_configFrame_Panel.reset();
                    this.m_configWiz_Panel.reset();
                    mixConf.setSavedToFile();
                }
            } else if (evt.getActionCommand().equals("toolEmailMenuItem")) {
                EmailComposer.composeEmail();
            } else if (evt.getActionCommand().equals("toolCertSigMenuItem")) {
                new CertificationTool(MixConfig.getMainWindow());
            } else if (evt.getActionCommand().equals("toolEncLogMenuItem")) {
                new EncryptedLogTool(MixConfig.getMainWindow());
            } else if (evt.getActionCommand().equals("toolDataRetentionLogMenuItem")) {
                new DataRetentionLogDecrypt(MixConfig.getMainWindow());
            } else if (evt.getActionCommand().equals("toolLawEnforcementLogMenuItem")) {
                new CrimeLogProcessing(MixConfig.getMainWindow());
            } else if (evt.getActionCommand().equals("toolCertViewMenuItem")) {
                new CADialog(MixConfig.getMainWindow());
            } else if (evt.getActionCommand().equals("toolTemplateSignerMenuItem")) {
                new TemplateSigningTool(MixConfig.getMainWindow());
            } else if (evt.getActionCommand().equals("About")) {
                MixConfig.about();
            } else if (evt.getActionCommand().equals("ChangeViewToWiz")) {
                LogHolder.log(7, LogType.GUI, "Switching to Wizard View");
                ChoicePanel cp = (ChoicePanel)this.m_configWiz_Panel.getParent();
                boolean bSavedToFile = mixConf.isSavedToFile();
                cp.setWizardVisible();
                this.m_configWiz_Panel.load();
                if (bSavedToFile) {
                    mixConf.setSavedToFile();
                }
            } else if (evt.getActionCommand().equals("ChangeViewToExpert")) {
                LogHolder.log(7, LogType.GUI, "Switching to Expert View");
                ChoicePanel cp = (ChoicePanel)this.m_configFrame_Panel.getParent();
                boolean bSavedToFile = mixConf.isSavedToFile();
                cp.setExpertVisible();
                this.m_configFrame_Panel.load();
                this.m_configFrame_Panel.setActivePanel(this.m_configWiz_Panel.getCurrentPageClass());
                if (bSavedToFile) {
                    mixConf.setSavedToFile();
                }
            }
        }
        catch (Exception e) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(JAPDialog.MSG_ERROR_UNKNOWN), (Throwable)e);
        }
        ((ChoicePanel)this.m_configWiz_Panel.getParent()).setMessageTitle();
    }

    private void reset() throws XMLParseException, IOException {
        this.m_saveMenuItem.setText("Save [none]");
        this.m_saveMenuItem.setEnabled(false);
        MixConfig.setCurrentFilename(null);
        MixConfiguration mixconfig = new MixConfiguration();
        this.m_configFrame_Panel.setConfiguration(mixconfig);
        this.m_configWiz_Panel.setConfiguration(mixconfig);
        this.m_configFrame_Panel.reset();
        this.m_configWiz_Panel.reset();
        mixconfig.setSavedToFile();
        ChoicePanel cp = (ChoicePanel)this.m_configWiz_Panel.getParent();
        if (cp.getActiveCard().equals(START)) {
            cp.setWizardVisible();
        }
    }

    protected void checkUnuseableMenuItem() {
        ChoicePanel cp = (ChoicePanel)this.m_configWiz_Panel.getParent();
        if (cp.getActiveCard().equals(WIZARD)) {
            this.m_changeViewToWizMenuItem.setEnabled(false);
            this.m_changeViewToWizMenuItem.setState(true);
            this.m_changeViewToExpertMenuItem.setEnabled(true);
            this.m_changeViewToExpertMenuItem.setState(false);
            this.m_toolsMenu.setEnabled(false);
            this.m_newMenuItem.setEnabled(false);
            this.m_openMenuItem.setEnabled(false);
            this.m_openclipItem.setEnabled(false);
            this.m_saveAsMenuItem.setEnabled(true);
            this.m_saveclipItem.setEnabled(true);
            this.m_checkItem.setEnabled(true);
        } else if (cp.getActiveCard().equals(EXPERT)) {
            this.m_changeViewToWizMenuItem.setEnabled(true);
            this.m_changeViewToWizMenuItem.setState(false);
            this.m_changeViewToExpertMenuItem.setEnabled(false);
            this.m_changeViewToExpertMenuItem.setState(true);
            this.m_toolsMenu.setEnabled(true);
            this.m_newMenuItem.setEnabled(true);
            this.m_openMenuItem.setEnabled(true);
            this.m_openclipItem.setEnabled(true);
            this.m_saveAsMenuItem.setEnabled(true);
            this.m_saveclipItem.setEnabled(true);
            this.m_checkItem.setEnabled(true);
        } else if (cp.getActiveCard().equals(START)) {
            this.m_changeViewToWizMenuItem.setEnabled(true);
            this.m_changeViewToWizMenuItem.setState(false);
            this.m_changeViewToExpertMenuItem.setEnabled(true);
            this.m_changeViewToExpertMenuItem.setState(false);
            this.m_toolsMenu.setEnabled(true);
            this.m_newMenuItem.setEnabled(true);
            this.m_openMenuItem.setEnabled(true);
            this.m_openclipItem.setEnabled(true);
            this.m_saveAsMenuItem.setEnabled(false);
            this.m_saveclipItem.setEnabled(false);
            this.m_checkItem.setEnabled(false);
        }
    }

    private boolean ignoreInconsistenciesForSaving() throws IOException {
        boolean bIgnore = true;
        String[] msg = this.m_configFrame_Panel.check();
        if (msg.length > 0 && !(bIgnore = JAPDialog.showYesNoDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_IGNORE_INCONSISTENCIES), "Inconsistencies found"))) {
            MixConfig.info("Inconsistencies found", msg, false);
        }
        return bIgnore;
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

