/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import mixconfig.network.ConnectionData;
import mixconfig.network.ConnectionTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class OutgoingConnectionTableModel
extends ConnectionTableModel {
    private static final String[] columnNames = new String[]{"No.", "Type", "Transport", "Host-/Filename", "Port"};

    @Override
    public Object getValueAt(int row, int column) {
        ConnectionData data = this.getData(row);
        if (data == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                if (data.getType().equals("Proxy")) {
                    switch (data.getFlags() & 7) {
                        case 0: {
                            return "Proxy";
                        }
                        case 1: {
                            return "HTTP Proxy";
                        }
                        case 2: {
                            return "Socks Proxy";
                        }
                        case 4: {
                            return "VPN Proxy";
                        }
                    }
                } else {
                    return "Mix";
                }
            }
            case 2: {
                return new Integer(data.getTransport());
            }
            case 3: {
                return data.getHostname();
            }
            case 4: {
                return new Integer(data.getPort());
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Element createMixAsElement(Document doc) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(i).getType().equals("NextMix")) continue;
            Element mix = this.getData(i).toXmlElement(doc);
            return mix;
        }
        return null;
    }

    public void readFromElement(Element out) {
        if (out.getTagName().equals("NextMix")) {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                if (!this.getData(i).getType().equals("Mix")) continue;
                this.deleteData(i);
            }
            ConnectionData data = ConnectionData.createFromElement("NextMix", out);
            if (data != null) {
                this.addData(data);
            }
        }
    }
}

