/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.JAPCertificate;
import anon.util.Base64;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPJIntField;
import gui.MixConfigTextField;
import gui.TitledGridBagPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfiguration;
import mixconfig.panels.CertPanel;
import mixconfig.panels.MixConfigPanel;

public class AdvancedPanel
extends MixConfigPanel
implements ChangeListener {
    private static final String XMLPATH_TRAFFIC_SHAPING = "Ressources";
    private static final String XMLPATH_TRAFFIC_SHAPING_LATENCY = "Ressources/Latency";
    private static final String XMLPATH_TRAFFIC_SHAPING_TIME_INTERVAL = "Ressources/Intervall";
    private static final String XMLPATH_TRAFFIC_SHAPING_PACKET_INTERVAL = "Ressources/BytesPerIntervall";
    private static final String XMLPATH_TRAFFIC_SHAPING_UNSHAPED_TRAFFIC = "Ressources/UnlimitTraffic";
    public static final String XMLPATH_MONITORING_HOST = "Network/ServerMonitoring/Host";
    public static final String XMLPATH_MONITORING_PORT = "Network/ServerMonitoring/Port";
    private static final String MSG_SERVER_MONITORING = AdvancedPanel.class.getName() + "_SM";
    private static final String MSG_SERVER_MONITORING_TOOLTIP = AdvancedPanel.class.getName() + "_smToolTip";
    private static final String MSG_SERVER_MONITORING_HOST = AdvancedPanel.class.getName() + "_smHost";
    private static final String MSG_SERVER_MONITORING_PORT = AdvancedPanel.class.getName() + "_smPort";
    private static final String MSG_TRAFFIC_SHAPING = AdvancedPanel.class.getName() + "_TS";
    private static final String MSG_LATENCY = AdvancedPanel.class.getName() + "_tsLatency";
    private static final String MSG_LATENCY_TOOLTIP = AdvancedPanel.class.getName() + "_tsLatencyToolTip";
    private static final String MSG_TIME_INTERVAL = AdvancedPanel.class.getName() + "_tsTimeInterval";
    private static final String MSG_PACKET_INTERVAL = AdvancedPanel.class.getName() + "_tsPacketInterval";
    private static final String MSG_SHAPING_INTERVAL_TOOLTIP = AdvancedPanel.class.getName() + "_tsShapingIntervalToolTip";
    private static final String MSG_UNSHAPED_TRAFFIC = AdvancedPanel.class.getName() + "_tsUnshapedTraffic";
    private static final String MSG_UNSHAPED_TRAFFIC_TOOLTIP = AdvancedPanel.class.getName() + "_tsUnshapedTrafficToolTip";
    private static final String MSG_SET_UID = AdvancedPanel.class.getName() + "_setUID";
    private static final String MSG_SET_FD = AdvancedPanel.class.getName() + "_setFD";
    private static final String MSG_SET_MAXUSERS = AdvancedPanel.class.getName() + "_setMaxUsers";
    private static final String MSG_RUN_DAEMON = AdvancedPanel.class.getName() + "_runDaemon";
    private static final String MSG_ENABLE_ROOT_VERIFICATION = AdvancedPanel.class.getName() + "_enableRootVerification";
    private static final String MSG_ENABLE_LOGGING = AdvancedPanel.class.getName() + "_enableLogging";
    private static final String MSG_LOG_CONSOLE = AdvancedPanel.class.getName() + "_logConsole";
    private static final String MSG_LOG_DIR = AdvancedPanel.class.getName() + "_logDir";
    private static final String MSG_COMPRESS_LOG = AdvancedPanel.class.getName() + "_compressLog";
    private static final String MSG_LOG_SYSLOG = AdvancedPanel.class.getName() + "_logSyslog";
    private static final String MSG_LOG_LABEL_MAX_FILE_SIZE = AdvancedPanel.class.getName() + "_logLabelMaxFileSize";
    private static final String MSG_LOG_LABEL_MAX_FILES = AdvancedPanel.class.getName() + "_logLabelMaxFiles";
    private static final String XML_ELEMENT_GENERAL = "General";
    private static final String XML_ELEMENT_LOGGING = "Logging";
    private static final String XML_ATTR_COMPRESSED = "compressed";
    private static final String XML_ATTR_MAX_LOG_FILE_SIZE = "MaxFileSize";
    private static final String XML_ATTR_MAX_LOG_FILES = "MaxFiles";
    private TitledGridBagPanel m_panelLogging;
    private TitledGridBagPanel m_panelMonitoring;
    private TitledGridBagPanel m_panelTrafficShaping;
    private TitledGridBagPanel m_panelMisc;
    private CertPanel m_panelLogCert;
    private MixConfigTextField m_tfFileName;
    private MixConfigTextField m_tfMonitoringHost;
    private JAPJIntField m_tfMonitoringPort;
    private JAPJIntField m_tfLatency;
    private JAPJIntField m_tfTimeInterval;
    private JAPJIntField m_tfBytesPerInterval;
    private JAPJIntField m_tfUnshapedTraffic;
    private MixConfigTextField m_tfUID;
    private JAPJIntField m_tfNumFileDesc;
    private JAPJIntField m_tfMaxUsers;
    private JAPJIntField m_tfMaxLogFileSize;
    private JAPJIntField m_tfMaxLogFiles;
    private JLabel m_lblMaxUsers;
    private JCheckBox m_cbDaemon;
    private JCheckBox m_cbCompressLog;
    private JCheckBox m_cbPathVerification;
    private JRadioButton m_rbConsole;
    private JRadioButton m_rbFile;
    private JRadioButton m_rbSyslog;
    private JRadioButton m_rbNoLog;
    private ButtonGroup m_loggingButtonGroup;
    private String m_logFilePath = "General/Logging/File";

    public AdvancedPanel() {
        super("Advanced");
        this.setAutoSaveEnabled(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = this.getInitialConstraints();
        this.m_panelLogging = new TitledGridBagPanel(XML_ELEMENT_LOGGING);
        constraints.gridheight = 2;
        constraints.fill = 1;
        this.add((Component)this.m_panelLogging, constraints);
        this.m_rbNoLog = new JRadioButton(JAPMessages.getString(MSG_ENABLE_LOGGING));
        this.m_rbNoLog.setSelected(true);
        this.m_rbNoLog.setModel(new MixConfigPanel.ToggleButtonModel(this));
        this.m_rbNoLog.addItemListener(this);
        this.m_panelLogging.addRow(this.m_rbNoLog, null);
        this.m_rbConsole = new JRadioButton(JAPMessages.getString(MSG_LOG_CONSOLE));
        this.m_rbConsole.setModel(new MixConfigPanel.ToggleButtonModel(this));
        this.m_rbConsole.addItemListener(this);
        this.m_panelLogging.addRow(this.m_rbConsole, null);
        this.m_rbFile = new JRadioButton(JAPMessages.getString(MSG_LOG_DIR));
        this.m_rbFile.setModel(new MixConfigPanel.ToggleButtonModel(this));
        this.m_rbFile.addItemListener(this);
        this.m_tfFileName = new MixConfigTextField();
        this.m_tfFileName.addFocusListener(this);
        this.m_tfFileName.setEnabled(false);
        this.m_tfMaxLogFiles = new JAPJIntField(100);
        this.m_tfMaxLogFiles.addFocusListener(this);
        this.m_tfMaxLogFiles.setEnabled(false);
        this.m_tfMaxLogFileSize = new JAPJIntField(2000);
        this.m_tfMaxLogFileSize.addFocusListener(this);
        this.m_tfMaxLogFileSize.setEnabled(false);
        this.m_panelLogging.addRow(this.m_rbFile, this.m_tfFileName);
        this.m_panelLogging.addRow(GUIUtils.createLabel(MSG_LOG_LABEL_MAX_FILE_SIZE), this.m_tfMaxLogFileSize, GUIUtils.createLabel(MSG_LOG_LABEL_MAX_FILES), this.m_tfMaxLogFiles);
        this.m_cbCompressLog = new JCheckBox(JAPMessages.getString(MSG_COMPRESS_LOG));
        this.m_cbCompressLog.addItemListener(this);
        this.m_cbCompressLog.setEnabled(false);
        this.m_panelLogging.addRow(null, this.m_cbCompressLog);
        this.m_rbSyslog = new JRadioButton(JAPMessages.getString(MSG_LOG_SYSLOG));
        this.m_rbSyslog.setModel(new MixConfigPanel.ToggleButtonModel(this));
        this.m_rbSyslog.addItemListener(this);
        this.m_panelLogging.addRow(this.m_rbSyslog, null);
        this.m_loggingButtonGroup = new ButtonGroup();
        this.m_loggingButtonGroup.add(this.m_rbNoLog);
        this.m_loggingButtonGroup.add(this.m_rbConsole);
        this.m_loggingButtonGroup.add(this.m_rbFile);
        this.m_loggingButtonGroup.add(this.m_rbSyslog);
        this.m_panelLogCert = new CertPanel("Encrypted Log Certificate", "This is the certificate your Mix will use to encrypt the log file", (JAPCertificate)null, 1, 0);
        this.m_panelLogCert.addChangeListener(this);
        this.m_panelLogCert.setEnabled(false);
        ++constraints.gridx;
        constraints.gridheight = 1;
        this.add((Component)this.m_panelLogCert, constraints);
        this.m_panelMonitoring = new TitledGridBagPanel(JAPMessages.getString(MSG_SERVER_MONITORING));
        this.m_panelMonitoring.setToolTipText(JAPMessages.getString(MSG_SERVER_MONITORING_TOOLTIP));
        ++constraints.gridy;
        this.add((Component)this.m_panelMonitoring, constraints);
        this.m_tfMonitoringHost = new MixConfigTextField(15);
        this.m_tfMonitoringHost.setName(XMLPATH_MONITORING_HOST);
        this.m_tfMonitoringHost.addFocusListener(this);
        this.m_tfMonitoringPort = new JAPJIntField(65535);
        this.m_tfMonitoringPort.setName(XMLPATH_MONITORING_PORT);
        this.m_tfMonitoringPort.addFocusListener(this);
        JLabel lblMonitoringHost = new JLabel(JAPMessages.getString(MSG_SERVER_MONITORING_HOST));
        lblMonitoringHost.setHorizontalAlignment(2);
        JLabel lblMonitoringPort = new JLabel(JAPMessages.getString(MSG_SERVER_MONITORING_PORT));
        lblMonitoringPort.setHorizontalAlignment(2);
        this.m_panelMonitoring.addRow(lblMonitoringHost, this.m_tfMonitoringHost);
        this.m_panelMonitoring.addRow((Component)lblMonitoringPort, (Component)this.m_tfMonitoringPort, 0);
        this.m_panelTrafficShaping = new TitledGridBagPanel(JAPMessages.getString(MSG_TRAFFIC_SHAPING));
        constraints.fill = 1;
        ++constraints.gridy;
        this.add((Component)this.m_panelTrafficShaping, constraints);
        constraints.fill = 2;
        this.m_tfLatency = new JAPJIntField();
        this.m_tfLatency.setName(XMLPATH_TRAFFIC_SHAPING_LATENCY);
        this.m_tfLatency.addFocusListener(this);
        JLabel lblLatency = new JLabel(JAPMessages.getString(MSG_LATENCY));
        lblLatency.setToolTipText(JAPMessages.getString(MSG_LATENCY_TOOLTIP));
        this.m_panelTrafficShaping.addRow(lblLatency, this.m_tfLatency);
        this.m_tfTimeInterval = new JAPJIntField();
        this.m_tfTimeInterval.setName(XMLPATH_TRAFFIC_SHAPING_TIME_INTERVAL);
        this.m_tfTimeInterval.addFocusListener(this);
        JLabel lblTimeInterval = new JLabel(JAPMessages.getString(MSG_TIME_INTERVAL));
        lblTimeInterval.setToolTipText(JAPMessages.getString(MSG_SHAPING_INTERVAL_TOOLTIP));
        this.m_panelTrafficShaping.addRow(lblTimeInterval, this.m_tfTimeInterval);
        this.m_tfBytesPerInterval = new JAPJIntField();
        this.m_tfBytesPerInterval.setName(XMLPATH_TRAFFIC_SHAPING_PACKET_INTERVAL);
        this.m_tfBytesPerInterval.addFocusListener(this);
        JLabel lblPacketInterval = new JLabel(JAPMessages.getString(MSG_PACKET_INTERVAL));
        lblPacketInterval.setToolTipText(JAPMessages.getString(MSG_SHAPING_INTERVAL_TOOLTIP));
        this.m_panelTrafficShaping.addRow(lblPacketInterval, this.m_tfBytesPerInterval);
        this.m_tfUnshapedTraffic = new JAPJIntField();
        this.m_tfUnshapedTraffic.setName(XMLPATH_TRAFFIC_SHAPING_UNSHAPED_TRAFFIC);
        this.m_tfUnshapedTraffic.addFocusListener(this);
        JLabel lblUnshapedTraffic = new JLabel(JAPMessages.getString(MSG_UNSHAPED_TRAFFIC));
        lblUnshapedTraffic.setToolTipText(JAPMessages.getString(MSG_UNSHAPED_TRAFFIC_TOOLTIP));
        this.m_panelTrafficShaping.addRow(lblUnshapedTraffic, this.m_tfUnshapedTraffic);
        this.m_panelMisc = new TitledGridBagPanel("Miscellaneous");
        --constraints.gridx;
        this.add((Component)this.m_panelMisc, constraints);
        this.m_tfUID = new MixConfigTextField(10);
        this.m_tfUID.setName("General/UserID");
        this.m_tfUID.addFocusListener(this);
        JLabel lblUserID = new JLabel(JAPMessages.getString(MSG_SET_UID));
        lblUserID.setToolTipText("Set a user name that is the owner of the mix process");
        this.m_panelMisc.addRow(lblUserID, this.m_tfUID);
        this.m_tfNumFileDesc = new JAPJIntField(new JAPJIntField.IntFieldWithoutZeroBounds(-1));
        this.m_tfNumFileDesc.setName("General/NrOfFileDescriptors");
        this.m_tfNumFileDesc.addFocusListener(this);
        JLabel lblFileDesc = new JLabel(JAPMessages.getString(MSG_SET_FD));
        lblFileDesc.setToolTipText("Set the maximum number of open file descriptors allowed");
        this.m_panelMisc.addRow(lblFileDesc, this.m_tfNumFileDesc);
        this.m_tfMaxUsers = new JAPJIntField(new JAPJIntField.IntFieldWithoutZeroBounds(-1));
        this.m_tfMaxUsers.setName("General/MaxUsers");
        this.m_tfMaxUsers.addFocusListener(this);
        this.m_lblMaxUsers = new JLabel(JAPMessages.getString(MSG_SET_MAXUSERS));
        this.m_lblMaxUsers.setToolTipText("Set a maximum number of users that can be connected to this cascade at any time");
        this.m_panelMisc.addRow(this.m_lblMaxUsers, this.m_tfMaxUsers);
        this.m_cbDaemon = new JCheckBox(JAPMessages.getString(MSG_RUN_DAEMON));
        this.m_cbDaemon.setName("General/Daemon");
        this.m_cbDaemon.addItemListener(this);
        this.m_panelMisc.addRow(this.m_cbDaemon, null);
        JButton btnRootCerts = new JButton("Reset root certificates");
        btnRootCerts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a_event) {
                CertPanel.resetRootCertificates(AdvancedPanel.this.getConfiguration());
            }
        });
        this.m_cbPathVerification = new JCheckBox(JAPMessages.getString(MSG_ENABLE_ROOT_VERIFICATION));
        this.m_cbPathVerification.setName("Certificates/MixCertificateVerification");
        this.m_cbPathVerification.addItemListener(this);
        this.m_panelMisc.addRow(this.m_cbPathVerification, btnRootCerts);
        ++constraints.gridx;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)new JLabel(), constraints);
        this.setAutoSaveEnabled(true);
    }

    @Override
    public void itemStateChanged(ItemEvent a_event) {
        Object s = a_event.getSource();
        MixConfiguration c = this.getConfiguration();
        if (s == this.m_rbConsole && this.m_rbConsole.isSelected() && this.isAutoSaveEnabled()) {
            c.setValue("General/Logging/Console", true);
            c.removeNode("General/Logging/Syslog");
            c.removeNode("General/Logging/File");
            c.removeNode("General/Logging/EncryptedLog");
        } else if (s == this.m_rbSyslog && this.m_rbSyslog.isSelected() && this.isAutoSaveEnabled()) {
            c.setValue("General/Logging/Syslog", true);
            c.removeNode("General/Logging/Console");
            c.removeNode("General/Logging/File");
            c.removeNode("General/Logging/EncryptedLog");
        } else if (s == this.m_rbNoLog && this.m_rbNoLog.isSelected() && this.isAutoSaveEnabled()) {
            c.removeNode("General/Logging/Syslog");
            c.removeNode("General/Logging/Console");
            c.removeNode("General/Logging/File");
            c.removeNode("General/Logging/EncryptedLog");
            c.removeNode("General/Logging");
        } else if (s == this.m_rbFile) {
            this.m_tfFileName.setEnabled(this.m_rbFile.isSelected());
            this.m_tfMaxLogFileSize.setEnabled(this.m_rbFile.isSelected());
            this.m_tfMaxLogFiles.setEnabled(this.m_rbFile.isSelected());
            this.m_cbCompressLog.setEnabled(this.m_rbFile.isSelected());
            this.m_panelLogCert.setEnabled(this.m_rbFile.isSelected());
            if (!this.m_rbFile.isSelected()) {
                this.m_panelLogCert.removeCert();
            } else if (c.isMixOnCDEnabled() && this.m_tfFileName.getText().equals("")) {
                this.m_tfFileName.setText("/usbstick");
            }
            if (this.isAutoSaveEnabled()) {
                this.focusLost(new FocusEvent(this.m_tfFileName, 0));
                c.removeNode("General/Logging/Syslog");
                c.removeNode("General/Logging/Console");
            }
        } else if (s == this.m_cbCompressLog) {
            this.setDirectoryLoggingValues();
        } else if (s == this.m_cbDaemon) {
            if (this.m_cbDaemon.isSelected()) {
                if (this.m_rbConsole.isSelected()) {
                    this.m_rbFile.setSelected(true);
                }
                this.m_rbConsole.setEnabled(false);
            } else {
                this.m_rbConsole.setEnabled(true);
            }
            this.save(this.m_cbDaemon);
        } else {
            super.itemStateChanged(a_event);
        }
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        a_conf.removeChangeListener(this);
        a_conf.addChangeListener(this);
        this.enableComponents();
    }

    @Override
    public void stateChanged(ChangeEvent a_event) {
        if (a_event instanceof ConfigurationEvent) {
            ConfigurationEvent c = (ConfigurationEvent)a_event;
            if (c.getModifiedXMLPath().equals("General/MixType")) {
                // empty if block
            }
            this.enableComponents();
        } else if (a_event.getSource() == this.m_panelLogCert) {
            if (this.m_panelLogCert.getCert() != null) {
                this.m_logFilePath = "General/Logging/EncryptedLog/File";
                if (this.isAutoSaveEnabled()) {
                    this.getConfiguration().setValue("General/Logging/EncryptedLog/KeyInfo/X509Data/X509Certificate/X509Certificate", this.m_panelLogCert.getCert().getX509Certificate().toByteArray());
                }
            } else {
                this.m_logFilePath = "General/Logging/File";
            }
            if (this.isAutoSaveEnabled()) {
                this.focusLost(new FocusEvent(this.m_tfFileName, 0));
            }
        }
    }

    @Override
    protected void enableComponents() {
        boolean bEnableMaxUsers = this.getConfiguration() != null ? this.getConfiguration().getMixType() == 1 : true;
        this.m_tfMaxUsers.setEnabled(bEnableMaxUsers);
        this.m_lblMaxUsers.setEnabled(bEnableMaxUsers);
    }

    @Override
    public void focusGained(FocusEvent a_event) {
        if (a_event.getSource() == this.m_tfFileName) {
            MixConfiguration c = this.getConfiguration();
            if (c.isMixOnCDEnabled() && this.m_tfFileName.getText().equals("")) {
                this.m_tfFileName.setText("/usbstick");
            }
        } else {
            super.focusGained(a_event);
        }
    }

    private void setDirectoryLoggingValues() {
        int iMaxLogFiles;
        int iMaxLogFileSize;
        MixConfiguration c = this.getConfiguration();
        c.removeNode("General/Logging/EncryptedLog/File");
        c.removeNode("General/Logging/File");
        String[] attributes = new String[]{XML_ATTR_MAX_LOG_FILE_SIZE, XML_ATTR_MAX_LOG_FILES, XML_ATTR_COMPRESSED};
        try {
            iMaxLogFileSize = this.m_tfMaxLogFileSize.getInt();
        }
        catch (NumberFormatException a_e) {
            iMaxLogFileSize = -1;
        }
        try {
            iMaxLogFiles = this.m_tfMaxLogFiles.getInt();
        }
        catch (NumberFormatException a_e) {
            iMaxLogFiles = -1;
        }
        String[] values = new String[]{iMaxLogFileSize > 0 ? Integer.toString(iMaxLogFileSize * 1024 * 1024) : "", iMaxLogFiles > 0 ? Integer.toString(iMaxLogFiles) : "", this.m_cbCompressLog.isSelected() ? "true" : ""};
        for (int i = 0; i < attributes.length; ++i) {
            if (values[i] == null || values[i].equals("")) {
                c.removeAttribute(this.m_logFilePath, attributes[i]);
                continue;
            }
            c.setAttribute(this.m_logFilePath, attributes[i], values[i]);
        }
        c.setValue(this.m_logFilePath, this.m_tfFileName.getText());
    }

    @Override
    public void focusLost(FocusEvent a_event) {
        MixConfiguration c = this.getConfiguration();
        if (a_event.getSource() == this.m_tfFileName || a_event.getSource() == this.m_tfMaxLogFileSize || a_event.getSource() == this.m_tfMaxLogFiles) {
            this.setDirectoryLoggingValues();
        } else if (a_event.getSource() == this.m_tfNumFileDesc) {
            if (this.m_tfNumFileDesc.getText().equals("")) {
                c.removeNode("General/NrOfFileDescriptors");
            } else {
                this.save(this.m_tfNumFileDesc);
            }
        } else if (a_event.getSource() == this.m_tfMaxUsers) {
            if (this.m_tfMaxUsers.getText().equals("")) {
                c.removeNode("General/MaxUsers");
            } else {
                this.save(this.m_tfMaxUsers);
            }
        } else if (a_event.getSource() == this.m_tfUID) {
            if (this.m_tfUID.getText().equals("")) {
                c.removeNode("General/UserID");
            } else {
                this.save(this.m_tfUID);
            }
        } else if (a_event.getSource() == this.m_tfMonitoringHost) {
            if (this.m_tfMonitoringHost.getText().equals("")) {
                c.removeNode(this.m_tfMonitoringHost.getName());
            } else {
                this.save(this.m_tfMonitoringHost);
            }
        } else if (a_event.getSource() == this.m_tfMonitoringPort) {
            if (this.m_tfMonitoringPort.getText().equals("")) {
                c.removeNode(this.m_tfMonitoringPort.getName());
            } else {
                this.save(this.m_tfMonitoringPort);
            }
        } else {
            super.focusLost(a_event);
        }
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.setAutoSaveEnabled(false);
        MixConfiguration c = this.getConfiguration();
        this.m_tfFileName.setText("");
        this.m_rbNoLog.setSelected(true);
        String s = c.getValue("General/Logging/Console");
        if (s != null) {
            this.m_rbConsole.setSelected(new Boolean(s));
        }
        if ((s = c.getValue("General/Logging/Syslog")) != null) {
            this.m_rbSyslog.setSelected(new Boolean(s));
        }
        if ((s = c.getValue("General/Logging/EncryptedLog/File")) != null) {
            this.m_tfFileName.setText(s);
            s = c.getValue(this.m_logFilePath + "/" + XML_ATTR_COMPRESSED);
            this.m_cbCompressLog.setSelected(new Boolean(s));
            this.m_rbFile.setSelected(true);
            this.m_panelLogCert.setEnabled(true);
            String cert = c.getValue("General/Logging/EncryptedLog/KeyInfo/X509Data/X509Certificate/X509Certificate");
            byte[] b = null;
            if (cert != null && !cert.equals("")) {
                b = Base64.decode(cert);
            }
            this.m_panelLogCert.setCert(b);
        }
        if ((s = c.getValue("General/Logging/File")) != null) {
            this.m_tfFileName.setText(s);
            s = c.getValue(this.m_logFilePath + "/" + XML_ATTR_MAX_LOG_FILE_SIZE);
            if (s != null) {
                try {
                    this.m_tfMaxLogFileSize.setInt(Integer.parseInt(s) / 0x100000);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((s = c.getValue(this.m_logFilePath + "/" + XML_ATTR_MAX_LOG_FILES)) != null) {
                try {
                    this.m_tfMaxLogFiles.setInt(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            s = c.getValue(this.m_logFilePath + "/" + XML_ATTR_COMPRESSED);
            this.m_cbCompressLog.setSelected(new Boolean(s));
            this.m_rbFile.setSelected(true);
        }
        this.setAutoSaveEnabled(true);
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    @Override
    public Vector<String> check() {
        String userId;
        String path;
        Vector<String> errors = new Vector<String>();
        MixConfiguration c = this.getConfiguration();
        if (this.m_rbFile.isSelected() && ((path = c.getValue(this.m_logFilePath)) == null || path.equals("") || path.indexOf(" ") != -1)) {
            errors.addElement("Path to logging directory is invalid in " + this.getName() + " panel.");
        }
        if ((userId = c.getValue("General/UserID")) != null && !userId.equals("") && userId.indexOf(" ") != -1) {
            errors.addElement("User ID is invalid in " + this.getName() + " panel.");
        }
        String sPort = c.getValue(this.m_tfMonitoringPort.getName());
        String sHost = c.getValue(this.m_tfMonitoringHost.getName());
        if (sHost != null && !sHost.equals("") || sPort != null && !sPort.equals("")) {
            if (sPort != null && sHost == null) {
                errors.add("You entered a port, but no host for Server Monitoring!");
            }
            if (sPort == null && sHost != null) {
                errors.add("You entered a host, but no port for Server Monitoring!");
            }
            if (sHost != null && (sHost.equals("") || sHost.indexOf(" ") != -1)) {
                errors.add("Server Monitoring host is invalid!");
            }
        }
        if (this.m_cbPathVerification.isSelected() && !CertPanel.hasRootCertificates(c)) {
            errors.add("The configuration contains no root certificates for automatic verification. Please reset the root certificates, or your mix will not connect.");
        }
        return errors;
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

