/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.ICertificate;
import anon.crypto.PKCS12;
import anon.pay.xml.XMLPriceCertificate;
import anon.util.Base64;
import anon.util.ClassUtil;
import gui.IPTextField;
import gui.JAPHelpContext;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.TableModel;
import logging.LogHolder;
import logging.LogType;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.infoservice.InfoServiceData;
import mixconfig.infoservice.InfoServiceTableModel;
import mixconfig.network.IncomingConnectionTableModel;
import mixconfig.network.OutgoingConnectionTableModel;
import mixconfig.network.ProxyTableModel;
import mixconfig.panels.CascadePanel;
import mixconfig.panels.CertPanel;
import mixconfig.panels.PriceCertPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MixConfigPanel
extends JPanel
implements ItemListener,
FocusListener,
JAPHelpContext.IHelpContext {
    public static final int MAX_COLUMN_LENGTH = 20;
    public static final int MAX_COMBO_BOX_LENGTH = 27;
    public static final int MAX_COORDINATE_FIELD_LENGTH = 7;
    public static final String MSG_WARNING_NO_MIX_CERT = MixConfigPanel.class.getName() + "_warningNoMixCert";
    public static final String MSG_WARNING_NO_OPERATOR_CERT = MixConfigPanel.class.getName() + "_warningOperatorCert";
    public static final String MSG_ERROR_BLANK_FIELD = MixConfigPanel.class.getName() + "_errorBlankField";
    private boolean m_autoSave = true;
    private MixConfiguration m_mixConf = null;
    private Insets m_insets;

    protected MixConfigPanel(String a_name) {
        super(new GridBagLayout());
        this.setName(a_name);
        this.m_insets = new Insets(5, 5, 5, 5);
    }

    protected abstract void enableComponents();

    public abstract Vector<String> check();

    public String getPanelName() {
        String name = ClassUtil.getShortClassName(this.getClass());
        if (name.toLowerCase().endsWith("panel")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }

    protected GridBagConstraints getInitialConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = this.getDefaultInsets();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        return constraints;
    }

    public Insets getDefaultInsets() {
        return this.m_insets;
    }

    @Override
    public final void setName(String a_name) {
        if (a_name == null || a_name.trim().length() <= 0) {
            throw new IllegalArgumentException("Panel name must be a valid string!");
        }
        super.setName(a_name);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        try {
            Object source = ie.getSource();
            if (this.m_autoSave && ((Component)source).getName() != null) {
                if (source instanceof JTextField) {
                    this.save((JTextField)source);
                } else if (source instanceof JCheckBox) {
                    this.save((JCheckBox)source);
                } else if (source instanceof JComboBox) {
                    this.save((JComboBox)source);
                } else if (source instanceof JRadioButton && ie.getStateChange() == 1) {
                    this.save((JRadioButton)source);
                }
            }
            this.enableComponents();
            this.validate();
        }
        catch (Exception uee) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)uee);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            if (e.getSource() instanceof JTextField) {
                this.save((JTextField)e.getSource());
            } else if (e.getSource() instanceof IPTextField) {
                this.save((IPTextField)e.getSource());
            }
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Container p = this;
        do {
            if (!((p = p.getParent()) instanceof JTabbedPane)) continue;
            JTabbedPane jtb = (JTabbedPane)p;
            for (int k = 0; k < jtb.getTabCount(); ++k) {
                if (jtb.getComponentAt(k) != this) continue;
                jtb.setEnabledAt(k, enabled);
            }
        } while (p != null);
    }

    public void setConfiguration(MixConfiguration a_mixConf) throws IOException {
        this.m_mixConf = a_mixConf;
        this.load();
    }

    public MixConfiguration getConfiguration() {
        return this.m_mixConf;
    }

    protected void setAutoSaveEnabled(boolean a_autoSave) {
        this.m_autoSave = a_autoSave;
    }

    protected boolean isAutoSaveEnabled() {
        return this.m_autoSave;
    }

    public void load() throws IOException {
        this.setAutoSaveEnabled(false);
        this.load(this);
        this.setAutoSaveEnabled(true);
    }

    public void save() throws IOException {
        this.save(this);
    }

    protected void save(IPTextField a_ipTextField) {
        String s = a_ipTextField.getText().trim();
        if (!a_ipTextField.isEnabled() || !a_ipTextField.isCorrect()) {
            s = null;
        }
        this.m_mixConf.setValue(a_ipTextField.getName(), s);
    }

    protected void save(Container a) throws IOException {
        if (a instanceof IPTextField) {
            this.save((IPTextField)a);
            return;
        }
        Component[] c = a.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i].getName() == null || c[i].getName().equals("")) {
                if (!(c[i] instanceof Container)) continue;
                this.save((Container)c[i]);
                continue;
            }
            if (c[i] instanceof JTable) {
                this.save((JTable)c[i]);
            }
            if (c[i] instanceof CertPanel) {
                this.save((CertPanel)c[i]);
                continue;
            }
            if (c[i] instanceof JTextField) {
                this.save((JTextField)c[i]);
                continue;
            }
            if (c[i] instanceof JComboBox) {
                this.save((JComboBox)c[i]);
                continue;
            }
            if (c[i] instanceof JCheckBox) {
                this.save((JCheckBox)c[i]);
                continue;
            }
            if (c[i] instanceof JRadioButton) {
                this.save((JRadioButton)c[i]);
                continue;
            }
            if (c[i] instanceof IPTextField) {
                this.save((IPTextField)c[i]);
                continue;
            }
            if (!(c[i] instanceof Container)) continue;
            this.save((Container)c[i]);
        }
    }

    protected void save(JTable table) {
        TableModel model = table.getModel();
        if (model instanceof InfoServiceTableModel) {
            this.m_mixConf.setValue("Network", (InfoServiceTableModel)model);
        } else if (model instanceof IncomingConnectionTableModel) {
            this.m_mixConf.setValue("Network", (IncomingConnectionTableModel)model);
        } else if (model instanceof OutgoingConnectionTableModel) {
            this.m_mixConf.setValue(table.getName(), (OutgoingConnectionTableModel)model);
        } else if (model instanceof ProxyTableModel) {
            this.m_mixConf.setValue(table.getName(), (ProxyTableModel)model);
        } else if (model instanceof CascadePanel.MixListTableModel) {
            this.m_mixConf.setValue(table.getName(), (CascadePanel.MixListTableModel)model);
        }
    }

    protected void save(CertPanel a) throws IOException {
        String name = a.getName();
        ICertificate certificate = a.getCert();
        if (!a.isEnabled() || certificate == null) {
            this.m_mixConf.removeNode(name);
        } else {
            if (name.endsWith("OwnCertificate")) {
                this.m_mixConf.setValue(name + "/X509PKCS12", ((PKCS12)certificate).toByteArray(a.getPrivateCertPassword()));
            }
            this.m_mixConf.setValue(name + "/X509Certificate", certificate.getX509Certificate().toByteArray());
        }
    }

    protected void save(PriceCertPanel a_panel) throws IOException {
        String name = a_panel.getName();
        XMLPriceCertificate cert = a_panel.getCert();
        if (cert == null) {
            this.m_mixConf.removeNode(name);
        } else {
            this.m_mixConf.setValue(name, cert);
        }
    }

    protected void save(JTextField a_textfield) {
        String s = a_textfield.getText().trim();
        if (!a_textfield.isEnabled()) {
            this.m_mixConf.removeNode(a_textfield.getName());
        } else {
            this.save(a_textfield.getName(), s);
        }
    }

    protected void save(String a_xmlPath, String a_value) {
        String sValue = null;
        if (!(a_value != null && a_value.trim().length() != 0 || this.m_mixConf.hasAttributes(a_xmlPath))) {
            this.m_mixConf.removeNode(a_xmlPath);
        } else {
            sValue = this.m_mixConf.getValue(a_xmlPath);
            if (sValue != null && sValue.equals(a_value)) {
                return;
            }
            this.m_mixConf.setValue(a_xmlPath, a_value);
        }
    }

    protected void save(JCheckBox a) {
        this.m_mixConf.setValue(a.getName(), a.isSelected() && a.isEnabled());
    }

    protected void save(JComboBox a) {
        int s = a.getSelectedIndex();
        if (!a.isEnabled()) {
            this.m_mixConf.removeNode(a.getName());
        } else {
            if (a.getName().equals("General/MixType")) {
                s = (int)Math.pow(2.0, s);
            }
            this.m_mixConf.setValue(a.getName(), s);
        }
    }

    protected void save(JRadioButton a) {
        try {
            ToggleButtonModel bm = (ToggleButtonModel)a.getModel();
            ButtonGroup group = bm.getGroup();
            this.save(group);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void save(ButtonGroup a) {
    }

    protected void load(Container a) throws IOException {
        if (a instanceof IPTextField) {
            this.load((IPTextField)a);
            return;
        }
        Component[] c = a.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof Container) {
                this.load((Container)c[i]);
            }
            if (c[i].getName() == null) continue;
            if (c[i] instanceof JTable) {
                this.load((JTable)c[i]);
                continue;
            }
            if (c[i] instanceof CertPanel) {
                this.load((CertPanel)c[i]);
                continue;
            }
            if (c[i] instanceof PriceCertPanel) {
                this.load((PriceCertPanel)c[i]);
                continue;
            }
            if (c[i] instanceof JTextField) {
                this.load((JTextField)c[i]);
                continue;
            }
            if (c[i] instanceof JCheckBox) {
                this.load((JCheckBox)c[i]);
                continue;
            }
            if (c[i] instanceof JComboBox) {
                this.load((JComboBox)c[i]);
                continue;
            }
            if (c[i] instanceof JRadioButton) {
                this.load((JRadioButton)c[i]);
                continue;
            }
            if (!(c[i] instanceof IPTextField)) continue;
            this.load((IPTextField)c[i]);
        }
    }

    protected void load(JTextField a) {
        a.setText(this.m_mixConf.getValue(a.getName()));
    }

    protected void load(JCheckBox a) {
        Boolean b = new Boolean(this.m_mixConf.getValue(a.getName()));
        a.setSelected(b);
    }

    protected void load(JComboBox a) {
        int i;
        String s = this.m_mixConf.getValue(a.getName());
        try {
            i = Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            i = 0;
        }
        if (a.getName().indexOf("General/MixType") >= 0) {
            i = (int)(Math.log(i) / Math.log(2.0));
        }
        a.setSelectedIndex(i);
    }

    protected void load(JRadioButton a) {
        Boolean b = new Boolean(this.m_mixConf.getValue(a.getName()));
        a.setSelected(b);
    }

    protected void load(JTable table) {
        TableModel model = table.getModel();
        boolean prevAutoSave = this.m_autoSave;
        this.setAutoSaveEnabled(false);
        if (model instanceof InfoServiceTableModel) {
            Node parent;
            int i;
            InfoServiceTableModel tableModel = (InfoServiceTableModel)model;
            NodeList nl = this.m_mixConf.getDocument().getElementsByTagName("InfoServices");
            if (nl.getLength() == 1) {
                tableModel.readFromElement((Element)nl.item(0));
            } else if (nl.getLength() == 0) {
                nl = this.m_mixConf.getDocument().getElementsByTagName("InfoService");
                for (i = 0; i < nl.getLength(); ++i) {
                    parent = nl.item(i).getParentNode();
                    if (parent.getNodeName().equals("InfoServices")) continue;
                    LogHolder.log(5, LogType.NET, "Found old InfoService element --> converting it ..");
                    String sHost = "";
                    int iPort = 0;
                    for (Node child = nl.item(i).getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeName().equals("Host")) {
                            sHost = child.getTextContent();
                            LogHolder.log(7, LogType.NET, "The hostname is " + sHost);
                            continue;
                        }
                        if (!child.getNodeName().equals("Port")) continue;
                        iPort = new Integer(child.getTextContent());
                        LogHolder.log(7, LogType.NET, "The port is " + iPort);
                    }
                    tableModel.clear();
                    tableModel.addData(new InfoServiceData("InfoService", sHost, iPort));
                }
            } else {
                return;
            }
            nl = this.m_mixConf.getDocument().getElementsByTagName("InfoService");
            for (i = 0; i < nl.getLength(); ++i) {
                parent = nl.item(i).getParentNode();
                if (parent.getNodeName().equals("InfoServices")) continue;
                parent.removeChild(nl.item(i));
                LogHolder.log(5, LogType.NET, "Removed deprecated InfoService node");
                this.m_mixConf.setValue("Network", tableModel);
            }
        } else if (model instanceof IncomingConnectionTableModel) {
            IncomingConnectionTableModel in = (IncomingConnectionTableModel)model;
            NodeList nl = this.m_mixConf.getDocument().getElementsByTagName("ListenerInterfaces");
            if (nl.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Node parent = nl.item(i).getParentNode();
                if (!parent.getNodeName().equals("Network") || !(parent = parent.getParentNode()).getNodeName().equals("MixConfiguration")) continue;
                in.readFromElement((Element)nl.item(i));
            }
        } else if (model instanceof OutgoingConnectionTableModel) {
            OutgoingConnectionTableModel out = (OutgoingConnectionTableModel)model;
            NodeList nl = this.m_mixConf.getDocument().getElementsByTagName("Network");
            if (nl.getLength() != 0) {
                for (Node n = nl.item(0).getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (!n.getNodeName().equals("NextMix") && !n.getNodeName().equals("Proxies")) continue;
                    out.readFromElement((Element)n);
                }
            }
        } else if (model instanceof ProxyTableModel) {
            ProxyTableModel tableModel = (ProxyTableModel)model;
            NodeList nl = this.m_mixConf.getDocument().getElementsByTagName("Network");
            if (nl.getLength() != 0) {
                for (Node n = nl.item(0).getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (!n.getNodeName().equals("Proxies")) continue;
                    tableModel.readFromElement((Element)n);
                }
            }
        }
        this.setAutoSaveEnabled(prevAutoSave);
    }

    protected void load(IPTextField a_ipTextField) {
        if (a_ipTextField.getName() != null) {
            a_ipTextField.setText(this.m_mixConf.getValue(a_ipTextField.getName()));
            return;
        }
    }

    protected void load(CertPanel a_panel) throws IOException {
        String name = a_panel.getName();
        name = name.endsWith("OwnCertificate") ? name + "/X509PKCS12" : name + "/X509Certificate";
        String cert = this.m_mixConf.getValue(name);
        byte[] b = null;
        if (cert != null && !cert.equals("")) {
            b = Base64.decode(cert);
        }
        CertPanel.setAutoSign(false);
        a_panel.setCert(b);
        CertPanel.setAutoSign(true);
    }

    protected void load(PriceCertPanel a_panel) throws IOException {
        NodeList nl = this.m_mixConf.getDocument().getElementsByTagName("PriceCertificate");
        if (nl.getLength() >= 1) {
            Node priceCertNode = nl.item(0);
            XMLPriceCertificate cert = null;
            if (priceCertNode != null && priceCertNode instanceof Element) {
                Element priceCertElement = (Element)priceCertNode;
                try {
                    cert = new XMLPriceCertificate(priceCertElement);
                }
                catch (Exception ex) {
                    LogHolder.log(2, LogType.PAY, "Exception while loading price certificate", ex);
                }
            }
            a_panel.setCert(cert);
        } else {
            XMLPriceCertificate c = null;
            a_panel.setCert(c);
        }
    }

    protected boolean isNumber(String str) {
        try {
            Integer.parseInt(str, 10);
            return true;
        }
        catch (NumberFormatException ev) {
            return false;
        }
    }

    protected Component getComponentByName(String a_name) {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!c[i].getName().equals(a_name)) continue;
            return c[i];
        }
        return null;
    }

    protected class ToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        protected ToggleButtonModel() {
        }

        @Override
        public ButtonGroup getGroup() {
            return this.group;
        }
    }
}

