/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools.dataretention;

import anon.crypto.MyRSA;
import anon.crypto.MyRSAPrivateKey;
import anon.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class DataRetentionLogFileHeader {
    public static final byte MAX_nr_of_keys = 10;
    public static final int LOGGING_ENTITY_FIRST_MIX = 1;
    public static final int LOGGING_ENTITY_MIDDLE_MIX = 2;
    public static final int LOGGING_ENTITY_LAST_MIX = 3;
    private byte version = 0;
    private byte reserved1 = 0;
    private byte reserved2 = 0;
    private byte reserved3 = 0;
    private byte day = 0;
    private byte month = 0;
    private short year = 0;
    private long m_BaseTime;
    private byte logging_entity = 0;
    private byte logged_fields = 0;
    private short nr_of_log_entries_per_encrypted_log_line = 0;
    private byte nr_of_keys = 0;
    private t_encrypted_key[] keys = new t_encrypted_key[10];
    private byte[] auth_tag = null;
    private byte m_sizeOfLogEntry;

    public DataRetentionLogFileHeader() {
        for (int i = 0; i < 10; ++i) {
            this.keys[i] = new t_encrypted_key();
        }
        this.auth_tag = new byte[16];
    }

    public void writeToFile(FileOutputStream file) throws Exception {
        this.writeWithoutAuthTag(file);
        file.write(this.auth_tag);
    }

    private void writeWithoutAuthTag(OutputStream out) throws Exception {
        out.write(this.version);
        out.write(this.reserved1);
        out.write(this.reserved2);
        out.write(this.reserved3);
        out.write(this.day);
        out.write(this.month);
        byte year1 = (byte)(this.year >> 8);
        byte year2 = (byte)(this.year & 0xFF);
        out.write(year1);
        out.write(year2);
        out.write(this.logging_entity);
        out.write(this.logged_fields);
        out.write(this.nr_of_log_entries_per_encrypted_log_line);
        out.write(this.nr_of_keys);
        for (int i = 0; i < this.nr_of_keys; ++i) {
            out.write(this.keys[i].encryptedKeyBlock);
        }
        out.flush();
    }

    public void parseFromFile(FileInputStream file) throws IOException {
        this.version = (byte)file.read();
        if (this.version != 0) {
            throw new IOException("Unknown version");
        }
        this.reserved1 = (byte)file.read();
        this.reserved2 = (byte)file.read();
        this.reserved3 = (byte)file.read();
        this.day = (byte)file.read();
        this.month = (byte)file.read();
        short year1 = (short)file.read();
        short year2 = (short)file.read();
        this.year = (short)(year1 << 8 | year2);
        Date d = new Date(this.year - 1900, this.month - 1, this.day);
        this.m_BaseTime = d.getTime() / 1000L;
        this.logging_entity = (byte)file.read();
        this.logged_fields = (byte)file.read();
        this.nr_of_log_entries_per_encrypted_log_line = (short)file.read();
        this.nr_of_keys = (byte)file.read();
        for (int i = 0; i < this.nr_of_keys; ++i) {
            this.keys[i].encryptedKeyBlock = new byte[256];
            file.read(this.keys[i].encryptedKeyBlock);
        }
        file.read(this.auth_tag);
        this.m_sizeOfLogEntry = (byte)18;
    }

    public int getLength() {
        return 12 + 256 * this.nr_of_keys + 16;
    }

    public byte[] getEncryptedKey(int index) {
        return this.keys[index].encryptedKeyBlock;
    }

    public int getEncryptedKeyCount() {
        return this.nr_of_keys;
    }

    public static byte[] decryptSymKey(byte[] encSymKey, MyRSAPrivateKey privKey) throws Exception {
        MyRSA rsa = new MyRSA();
        rsa.init(privKey);
        byte[] decBlock = rsa.processBlockPKCS1(encSymKey, 0, encSymKey.length);
        byte[] key = new byte[16];
        System.arraycopy(decBlock, 0, key, 0, 16);
        byte[] iv = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2};
        DataRetentionLogFileHeader.verifyMac(decBlock, 0, 20, decBlock, 20, iv, key);
        SHA512Digest sha = new SHA512Digest();
        sha.update(decBlock, 16, 4);
        byte[] digest = new byte[sha.getDigestSize()];
        sha.doFinal(digest, 0);
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(decBlock[i] ^ digest[i]);
        }
        return key;
    }

    public void verifyHeader(byte[] key) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeWithoutAuthTag(bout);
        byte[] header = bout.toByteArray();
        byte[] iv = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3};
        DataRetentionLogFileHeader.verifyMac(header, this.auth_tag, iv, key);
    }

    public int getSizeOfLogLine() {
        return this.nr_of_log_entries_per_encrypted_log_line * this.m_sizeOfLogEntry + 16;
    }

    public int getNrOfLogEntriesPerLogLine() {
        return this.nr_of_log_entries_per_encrypted_log_line;
    }

    public int getSizeOfLogEntry() {
        return this.m_sizeOfLogEntry;
    }

    public int getLoggingEntity() {
        return this.logging_entity;
    }

    public long getBaseTime() {
        return this.m_BaseTime;
    }

    public static int decryptAndVerify(byte[] in, byte[] iv, byte[] key, byte[] plainOut) throws Exception {
        return DataRetentionLogFileHeader.decryptAndVerify(in, 0, in.length, iv, key, plainOut);
    }

    public static int decryptAndVerify(byte[] in, int inOff, int inLen, byte[] iv, byte[] key, byte[] plainOut) throws Exception {
        GCMBlockCipher gcmCipher = new GCMBlockCipher(new AESFastEngine());
        gcmCipher.init(false, new AEADParameters(new KeyParameter(key), 128, iv, null));
        byte[] plainText = new byte[gcmCipher.getOutputSize(inLen)];
        int outL = gcmCipher.processBytes(in, inOff, inLen, plainText, 0);
        outL += gcmCipher.doFinal(plainText, outL);
        if (plainOut != null) {
            System.arraycopy(plainText, 0, plainOut, 0, Math.min(outL, plainOut.length));
        }
        return outL;
    }

    private static void verifyMac(byte[] in, byte[] tag, byte[] iv, byte[] key) throws Exception {
        DataRetentionLogFileHeader.verifyMac(in, 0, in.length, tag, 0, iv, key);
    }

    static void verifyMac(byte[] in, int inOff, int inLen, byte[] tag, int tagOff, byte[] iv, byte[] key) throws Exception {
        GCMBlockCipher gcmCipher = new GCMBlockCipher(new AESFastEngine());
        gcmCipher.init(true, new AEADParameters(new KeyParameter(key), 128, iv, null));
        byte[] cipherText = new byte[gcmCipher.getOutputSize(inLen)];
        int outL = gcmCipher.processBytes(in, inOff, inLen, cipherText, 0);
        outL += gcmCipher.doFinal(cipherText, outL);
        if (!Util.arraysEqual(tag, tagOff, cipherText, cipherText.length - 16, 16)) {
            throw new Exception("Wrong MAC");
        }
    }

    class t_encrypted_key {
        public static final short ENCRYPTED_KEY_LENGTH = 256;
        public byte[] encryptedKeyBlock = null;

        t_encrypted_key() {
        }
    }
}

