/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools.dataretention;

import anon.crypto.MyRSAPublicKey;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.List;
import javax.crypto.Cipher;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import mixconfig.tools.dataretention.DataRetentionLogFileHeader;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class DataRetentionSmartCard {
    CardTerminal m_terminal = null;
    CardChannel m_channel = null;
    Card m_card = null;
    private final byte OFFSET_CLA = 0;
    private final byte OFFSET_INS = 1;
    private final byte OFFSET_P1 = (byte)2;
    private final byte OFFSET_P2 = (byte)3;
    private final byte OFFSET_LC = (byte)4;
    private final byte OFFSET_DATA = (byte)5;
    private final byte HEADER_LENGTH = (byte)5;
    private final short RSA_KEY_LENGTH = (short)256;
    private final byte CLA_ANON = (byte)-80;
    private final byte INS_AUTHADMIN = (byte)48;
    private final byte INS_SETDATE = (byte)49;
    private final byte INS_UNBLOCKUSERPIN = (byte)50;
    private final byte INS_SETADMINPIN = (byte)51;
    private final byte INS_AUTHUSER = (byte)80;
    private final byte INS_GETLOGKEY = (byte)81;
    private final byte INS_GETPUBLICKEY_EXP = (byte)82;
    private final byte INS_GETPUBLICKEY_MOD = (byte)83;
    private final byte ANON_LOG_KEY_LENGTH = (byte)16;
    private final short APDU_DATA_LENGTH = (short)200;
    public static final byte DATE_LENGTH = 4;
    public static final byte DATE_AUTH_TAG_LENGTH = 16;
    public static final short GCM_AUTH_TAG_LENGTH = 128;
    public static final short ENCRYPTED_KEY_LENGTH = 256;
    private final byte[] selectANONApplet = new byte[]{0, -92, 4, 0, 13, 65, 78, 79, 78, 76, 111, 103, 65, 112, 112, 108, 101, 116};
    public static byte[] entity_entry_lengths = new byte[]{0, 18, 16, 18, 12};
    public static final short AES_BLOCK_LENGTH = 16;
    public static final short AES128_KEY_LENGTH = 16;
    private static final short EXCEPTION_NEW_DATE_IN_PAST = 24577;
    private static final short EXCEPTION_OUTSIDE_RETENTION_PERIOD = 24578;
    private static final short SW_SECURITY_STATUS_NOT_SATISFIED = 24578;

    public List GetReaderList() {
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> readersList = factory.terminals().list();
            return readersList;
        }
        catch (Exception ex) {
            System.out.println("Exception : " + ex);
            return null;
        }
    }

    public boolean connectToSmartCard() throws Exception {
        List terminalList = this.GetReaderList();
        boolean cardFound = false;
        for (int i = 0; i < terminalList.size(); ++i) {
            System.out.println(i + " : " + terminalList.get(i));
            this.m_terminal = (CardTerminal)terminalList.get(i);
            if (!this.m_terminal.isCardPresent()) continue;
            this.m_card = this.m_terminal.connect("*");
            System.out.println("card: " + this.m_card);
            this.m_channel = this.m_card.getBasicChannel();
            ATR atr = this.m_card.getATR();
            System.out.println(atr.toString());
            ResponseAPDU resp = this.sendAPDU(this.selectANONApplet);
            if (resp.getSW() != 36864) {
                System.out.println("Not ANON card.");
                continue;
            }
            cardFound = true;
            break;
        }
        return cardFound;
    }

    public void DisconnectFromCard() throws Exception {
        if (this.m_card != null) {
            this.m_card.disconnect(false);
            this.m_card = null;
        }
    }

    public MyRSAPublicKey retrievePublicKey() throws Exception {
        byte[] temp;
        MyRSAPublicKey key = null;
        byte[] exponent = null;
        byte[] modulus = null;
        int modulusOffset = 0;
        byte[] apdu = new byte[]{-80, 82, 0, 0, 0};
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to get public exponent");
        } else {
            temp = resp.getData();
            exponent = new byte[temp.length];
            System.arraycopy(temp, 0, exponent, 0, temp.length);
        }
        apdu[0] = -80;
        apdu[1] = 83;
        apdu[2] = 0;
        resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to get public modulus");
        } else {
            temp = resp.getData();
            modulus = new byte[256];
            System.arraycopy(temp, 0, modulus, 0, temp.length);
            modulusOffset = (short)(modulusOffset + temp.length);
        }
        apdu[0] = -80;
        apdu[1] = 83;
        apdu[2] = 1;
        resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to get public modulus");
        } else {
            temp = resp.getData();
            System.arraycopy(temp, 0, modulus, modulusOffset, temp.length);
            modulusOffset = (short)(modulusOffset + temp.length);
        }
        BigInteger modulusInt = new BigInteger(1, modulus);
        System.out.println("Key modulus is :" + modulusInt);
        BigInteger exponentInt = new BigInteger(1, exponent);
        System.out.println("Key exponent is :" + exponentInt);
        key = new MyRSAPublicKey(modulusInt, exponentInt);
        return key;
    }

    public byte[] EncryptLogKey(byte[] logKey, byte day, byte month, short year, PublicKey publicKey) throws Exception {
        if (logKey.length != 16) {
            return null;
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        System.out.println("\n" + cipher.getProvider().getInfo());
        System.out.println("\nStart encryption");
        byte[] keyBlock = new byte[logKey.length + 4 + 16];
        System.arraycopy(logKey, 0, keyBlock, 0, logKey.length);
        keyBlock[logKey.length] = day;
        keyBlock[logKey.length + 1] = month;
        keyBlock[logKey.length + 2] = (byte)(year >> 8);
        keyBlock[logKey.length + 3] = (byte)(year & 0xFF);
        GCMBlockCipher gcmCipher = new GCMBlockCipher(new AESFastEngine());
        byte[] iv = new byte[16];
        gcmCipher.init(true, new AEADParameters(new KeyParameter(logKey), 128, iv, null));
        int tmp = gcmCipher.getOutputSize(logKey.length + 4);
        byte[] outblock = new byte[tmp];
        int outL = gcmCipher.processBytes(keyBlock, 0, logKey.length + 4, outblock, 0);
        gcmCipher.doFinal(outblock, outL);
        byte[] gcmMAC = gcmCipher.getMac();
        System.arraycopy(gcmMAC, 0, keyBlock, logKey.length + 4, gcmMAC.length);
        cipher.init(1, publicKey);
        byte[] cipherText = cipher.doFinal(keyBlock);
        System.out.println("Finish encryption: ");
        System.out.println(this.bytesToHex(cipherText));
        return cipherText;
    }

    public int GetExpectedLogLineLength(int plainDataLength) throws Exception {
        GCMBlockCipher gcmCipher = new GCMBlockCipher(new AESFastEngine());
        byte[] iv = new byte[16];
        byte[] logKey = new byte[16];
        gcmCipher.init(true, new AEADParameters(new KeyParameter(logKey), 128, iv, null));
        return gcmCipher.getOutputSize(plainDataLength);
    }

    public byte[] EncryptLogLine(byte[] logKey, byte[] data, byte[] iv) throws Exception {
        GCMBlockCipher gcmCipher = new GCMBlockCipher(new AESFastEngine());
        gcmCipher.init(true, new AEADParameters(new KeyParameter(logKey), 128, iv, null));
        int tmp = gcmCipher.getOutputSize(data.length);
        byte[] cipherText = new byte[tmp];
        int outL = gcmCipher.processBytes(data, 0, data.length, cipherText, 0);
        gcmCipher.doFinal(cipherText, outL);
        return cipherText;
    }

    public byte[] DecryptLogLine(byte[] encrLogKey, byte[] encrData, byte[] iv) throws Exception {
        byte[] plainKey = null;
        plainKey = this.decrpytSymmetricKey(encrLogKey);
        if (plainKey != null) {
            return this.DecryptLogLineKey(plainKey, encrData, iv);
        }
        return null;
    }

    public byte[] DecryptLogLineKey(byte[] logKey, byte[] encrData, byte[] iv) throws Exception {
        GCMBlockCipher gcmCipher = new GCMBlockCipher(new AESFastEngine());
        gcmCipher.init(false, new AEADParameters(new KeyParameter(logKey), 128, iv, null));
        int tmp = gcmCipher.getOutputSize(encrData.length);
        byte[] plainText = new byte[tmp];
        int outL = gcmCipher.processBytes(encrData, 0, encrData.length, plainText, 0);
        gcmCipher.doFinal(plainText, outL);
        return plainText;
    }

    public boolean authenticateUser(byte[] pin) throws Exception {
        boolean status = false;
        byte[] apdu = new byte[5 + pin.length];
        apdu[0] = -80;
        apdu[1] = 80;
        apdu[2] = 0;
        apdu[3] = 0;
        apdu[4] = (byte)pin.length;
        System.arraycopy(pin, 0, apdu, 5, pin.length);
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to verify User PIN");
            status = false;
        } else {
            System.out.println("User PIN verification OK");
            status = true;
        }
        return status;
    }

    public boolean Admin_Authenticate(byte[] key) throws Exception {
        boolean status = false;
        byte[] apdu = new byte[5 + key.length];
        apdu[0] = -80;
        apdu[1] = 48;
        apdu[2] = 0;
        apdu[3] = 0;
        apdu[4] = (byte)key.length;
        System.arraycopy(key, 0, apdu, 5, key.length);
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to verify Admin PIN");
            status = false;
        } else {
            System.out.println("Admin PIN verification OK");
            status = true;
        }
        return status;
    }

    public boolean Admin_SetCurrentDate(byte day, byte month, short year) throws Exception {
        boolean status = false;
        byte[] apdu = new byte[]{-80, 49, 0, 0, 4, day, month, (byte)(year >> 8), (byte)(year & 0xFF)};
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to set current date, check if admin is authenticated.");
            status = false;
        } else {
            System.out.println("Actual date set OK");
            status = true;
        }
        return status;
    }

    public boolean Admin_SetAdminPIN(byte[] newPINValue) throws Exception {
        boolean status = false;
        byte[] apdu = new byte[5 + newPINValue.length];
        apdu[0] = -80;
        apdu[1] = 51;
        apdu[2] = 0;
        apdu[3] = 0;
        apdu[4] = (byte)newPINValue.length;
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to set admin PIN, check if admin is authenticated.");
            status = false;
        } else {
            System.out.println("Admin PIN set");
            status = true;
        }
        return status;
    }

    public boolean Admin_UnblockUserPIN(byte[] newPINValue) throws Exception {
        boolean status = false;
        byte[] apdu = null;
        apdu = newPINValue == null ? new byte[5] : new byte[5 + newPINValue.length];
        apdu[0] = -80;
        apdu[1] = 50;
        apdu[2] = (byte)(newPINValue != null ? 1 : 0);
        apdu[3] = 0;
        apdu[4] = (byte)(newPINValue != null ? newPINValue.length : 0);
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to unblock user PIN, check if admin is authenticated.");
            status = false;
        } else {
            System.out.println("User PIN ublocked");
            status = true;
        }
        return status;
    }

    public byte[] decrpytSymmetricKey(byte[] encryptedKey) throws Exception {
        ResponseAPDU resp;
        byte[] apdu;
        int remainingLength = encryptedKey.length;
        byte apduCounter = 0;
        int offset = 0;
        while (remainingLength > 200) {
            apdu = new byte[205];
            apdu[0] = -80;
            apdu[1] = 81;
            apdu[2] = apduCounter;
            apdu[3] = 0;
            apdu[4] = -56;
            System.arraycopy(encryptedKey, offset, apdu, 5, 200);
            resp = this.sendAPDU(apdu);
            if (resp.getSW() != 36864) {
                System.out.println("Fail to decrypt key");
                return null;
            }
            offset += 200;
            remainingLength -= 200;
            apduCounter = (byte)(apduCounter + 1);
        }
        apdu = new byte[5 + remainingLength];
        apdu[0] = -80;
        apdu[1] = 81;
        apdu[2] = apduCounter;
        apdu[3] = 1;
        apdu[4] = (byte)remainingLength;
        System.arraycopy(encryptedKey, offset, apdu, 5, remainingLength);
        resp = this.sendAPDU(apdu);
        if (resp.getSW() != 36864) {
            System.out.println("Fail to decrypt key");
            return null;
        }
        System.out.println(this.bytesToHex(resp.getBytes()));
        byte[] returnKey = null;
        byte[] key = resp.getData();
        if (key.length > 16) {
            returnKey = new byte[16];
            System.arraycopy(key, 0, returnKey, 0, 16);
            byte[] iv = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2};
            DataRetentionLogFileHeader.verifyMac(key, 0, 20, key, 20, iv, returnKey);
            SHA512Digest sha = new SHA512Digest();
            sha.update(key, 16, 4);
            byte[] digest = new byte[sha.getDigestSize()];
            sha.doFinal(digest, 0);
            for (int i = 0; i < 16; ++i) {
                returnKey[i] = (byte)(key[i] ^ digest[i]);
            }
        } else {
            returnKey = key;
        }
        return returnKey;
    }

    public byte[] CreateIV(int blocksCounter) {
        byte[] iv = new byte[12];
        for (int i = 0; i < iv.length; ++i) {
            iv[i] = 0;
        }
        iv[8] = (byte)(blocksCounter >> 24 & 0xFF);
        iv[9] = (byte)(blocksCounter >> 16 & 0xFF);
        iv[10] = (byte)(blocksCounter >> 8 & 0xFF);
        iv[11] = (byte)(blocksCounter & 0xFF);
        return iv;
    }

    public byte[] CreateFooter(byte[] logKey, int blocksCounter) throws Exception {
        byte[] data = new byte[]{(byte)(++blocksCounter >> 24 & 0xFF), (byte)(blocksCounter >> 16 & 0xFF), (byte)(blocksCounter >> 8 & 0xFF), (byte)(blocksCounter & 0xFF)};
        return this.EncryptLogLine(logKey, data, this.CreateIV(blocksCounter));
    }

    public int VerifyFooter(byte[] logKey, byte[] footer, int counter) throws Exception {
        byte[] iv = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        byte[] data = this.DecryptLogLineKey(logKey, footer, iv);
        int numBlocks = data[0] << 24 | data[1] << 16 & 0xFF0000 | data[2] << 8 & 0xFF00 | data[3] & 0xFF;
        return numBlocks;
    }

    public String byteToHex(byte data) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toHexChar(data >>> 4 & 0xF));
        buf.append(this.toHexChar(data & 0xF));
        return buf.toString();
    }

    public char toHexChar(int i) {
        if (0 <= i && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(97 + (i - 10));
    }

    public String bytesToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buf.append(this.byteToHex(data[i]));
            buf.append(" ");
        }
        return buf.toString();
    }

    private ResponseAPDU sendAPDU(byte[] apdu) throws Exception {
        CommandAPDU commandAPDU = new CommandAPDU(apdu);
        System.out.println(">>>>");
        System.out.println(commandAPDU);
        System.out.println(this.bytesToHex(commandAPDU.getBytes()));
        ResponseAPDU responseAPDU = this.m_channel.transmit(commandAPDU);
        System.out.println(responseAPDU);
        System.out.println(this.bytesToHex(responseAPDU.getBytes()));
        if (responseAPDU.getSW1() == 97) {
            CommandAPDU apduToSend = new CommandAPDU(0, -64, 0, 0, responseAPDU.getSW1());
            responseAPDU = this.m_channel.transmit(apduToSend);
            System.out.println(this.bytesToHex(responseAPDU.getBytes()));
        }
        System.out.println("<<<<");
        return responseAPDU;
    }
}

