/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import java.security.SecureRandom;
import logging.LogHolder;
import logging.LogType;

public final class KeyPool
implements Runnable {
    private SecureRandom sr;
    private KeyList pool;
    private KeyList aktKey;
    private int keySize;
    private int poolSize;
    private Object l1;
    private Object l2;
    private boolean runflag;
    private static KeyPool m_KeyPool = null;
    private Thread m_KeyPoolThread = null;

    private KeyPool(int n, int n2) {
        this.keySize = n2;
        this.poolSize = n;
        this.pool = null;
        this.aktKey = null;
        this.l1 = new Object();
        this.l2 = new Object();
        this.m_KeyPoolThread = new Thread((Runnable)this, "JAP - KeyPool");
        this.m_KeyPoolThread.setDaemon(true);
        this.m_KeyPoolThread.setPriority(1);
        this.m_KeyPoolThread.start();
    }

    public static synchronized KeyPool start() {
        if (m_KeyPool == null) {
            m_KeyPool = new KeyPool(20, 16);
        }
        return m_KeyPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        KeyList keyList;
        byte[] byArray = null;
        try {
            byArray = SecureRandom.getSeed(20);
            this.sr = new SecureRandom(byArray);
        }
        catch (Throwable throwable) {
            this.sr = new SecureRandom();
        }
        byArray = null;
        this.pool = new KeyList(this.keySize);
        for (int i = 1; i < this.poolSize; ++i) {
            keyList = new KeyList(this.keySize);
            keyList.next = this.pool;
            this.pool = keyList;
        }
        this.aktKey = null;
        this.runflag = true;
        while (this.runflag) {
            if (this.pool != null) {
                KeyPool keyPool = this;
                synchronized (keyPool) {
                    this.sr.nextBytes(this.pool.key);
                    keyList = this.pool;
                    this.pool = this.pool.next;
                    keyList.next = this.aktKey;
                    this.aktKey = keyList;
                    Object object = this.l2;
                    synchronized (object) {
                        this.l2.notify();
                    }
                }
            }
            try {
                Object object = this.l1;
                synchronized (object) {
                    this.l1.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                LogHolder.log(7, LogType.MISC, "JAPKeyPool:run() waiting interrupted!");
            }
        }
    }

    public static int getKey(byte[] byArray) {
        return KeyPool.getKey(byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getKey(byte[] byArray, int n) {
        Object object;
        if (byArray == null || byArray.length - n < KeyPool.m_KeyPool.keySize) {
            return -1;
        }
        if (KeyPool.m_KeyPool.aktKey == null) {
            try {
                object = KeyPool.m_KeyPool.l2;
                synchronized (object) {
                    KeyPool.m_KeyPool.l2.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                LogHolder.log(7, LogType.MISC, "JAPKeyPool:getKey() waiting interrupted!");
            }
        }
        object = m_KeyPool;
        synchronized (object) {
            System.arraycopy(KeyPool.m_KeyPool.aktKey.key, 0, byArray, n, KeyPool.m_KeyPool.keySize);
            KeyList keyList = KeyPool.m_KeyPool.aktKey;
            KeyPool.m_KeyPool.aktKey = KeyPool.m_KeyPool.aktKey.next;
            keyList.next = KeyPool.m_KeyPool.pool;
            KeyPool.m_KeyPool.pool = keyList;
        }
        object = KeyPool.m_KeyPool.l1;
        synchronized (object) {
            KeyPool.m_KeyPool.l1.notify();
        }
        return 0;
    }

    private final class KeyList {
        public byte[] key;
        public KeyList next;

        public KeyList(int n) {
            this.key = new byte[n];
            this.next = null;
        }
    }
}

