/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.X509UnknownExtension;
import anon.util.ClassUtil;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public abstract class AbstractX509Extension {
    public static final String IDENTIFIER = null;
    private static Class[] AVAILABLE_EXTENSIONS = new Class[]{class$anon$crypto$X509UnknownExtension == null ? (class$anon$crypto$X509UnknownExtension = AbstractX509Extension.class$("anon.crypto.X509UnknownExtension")) : class$anon$crypto$X509UnknownExtension, class$anon$crypto$X509SubjectKeyIdentifier == null ? (class$anon$crypto$X509SubjectKeyIdentifier = AbstractX509Extension.class$("anon.crypto.X509SubjectKeyIdentifier")) : class$anon$crypto$X509SubjectKeyIdentifier, class$anon$crypto$X509AuthorityKeyIdentifier == null ? (class$anon$crypto$X509AuthorityKeyIdentifier = AbstractX509Extension.class$("anon.crypto.X509AuthorityKeyIdentifier")) : class$anon$crypto$X509AuthorityKeyIdentifier, class$anon$crypto$X509SubjectAlternativeName == null ? (class$anon$crypto$X509SubjectAlternativeName = AbstractX509Extension.class$("anon.crypto.X509SubjectAlternativeName")) : class$anon$crypto$X509SubjectAlternativeName, class$anon$crypto$X509IssuerAlternativeName == null ? (class$anon$crypto$X509IssuerAlternativeName = AbstractX509Extension.class$("anon.crypto.X509IssuerAlternativeName")) : class$anon$crypto$X509IssuerAlternativeName, class$anon$crypto$X509BasicConstraints == null ? (class$anon$crypto$X509BasicConstraints = AbstractX509Extension.class$("anon.crypto.X509BasicConstraints")) : class$anon$crypto$X509BasicConstraints, class$anon$crypto$X509KeyUsage == null ? (class$anon$crypto$X509KeyUsage = AbstractX509Extension.class$("anon.crypto.X509KeyUsage")) : class$anon$crypto$X509KeyUsage};
    private static Vector ms_classExtensions;
    private DERObjectIdentifier m_identifier;
    private boolean m_critical;
    private byte[] m_value;
    private DERSequence m_extension;
    static /* synthetic */ Class class$anon$crypto$X509UnknownExtension;
    static /* synthetic */ Class class$anon$crypto$X509SubjectKeyIdentifier;
    static /* synthetic */ Class class$anon$crypto$X509AuthorityKeyIdentifier;
    static /* synthetic */ Class class$anon$crypto$X509SubjectAlternativeName;
    static /* synthetic */ Class class$anon$crypto$X509IssuerAlternativeName;
    static /* synthetic */ Class class$anon$crypto$X509BasicConstraints;
    static /* synthetic */ Class class$anon$crypto$X509KeyUsage;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERSequence;

    public AbstractX509Extension(String string, boolean bl, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.m_identifier = new DERObjectIdentifier(string);
        this.m_critical = bl;
        this.m_value = byArray;
        aSN1EncodableVector.add((DEREncodable)this.m_identifier);
        aSN1EncodableVector.add((DEREncodable)new DERBoolean(bl));
        aSN1EncodableVector.add((DEREncodable)new DEROctetString(byArray));
        this.m_extension = new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }

    public AbstractX509Extension(DERSequence dERSequence) {
        int n = 1;
        this.m_extension = dERSequence;
        this.m_identifier = (DERObjectIdentifier)dERSequence.getObjectAt(0);
        if (dERSequence.size() == 3) {
            this.m_critical = ((DERBoolean)dERSequence.getObjectAt(1)).isTrue();
            n = 2;
        } else {
            this.m_critical = false;
        }
        this.m_value = ((DEROctetString)dERSequence.getObjectAt(n)).getOctets();
    }

    static AbstractX509Extension getInstance(DERSequence dERSequence) {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)dERSequence.getObjectAt(0);
        Object[] objectArray = new Object[]{dERSequence};
        Class[] classArray = new Class[1];
        Class clazz = classArray[0] = class$org$bouncycastle$asn1$DERSequence == null ? (class$org$bouncycastle$asn1$DERSequence = AbstractX509Extension.class$("org.bouncycastle.asn1.DERSequence")) : class$org$bouncycastle$asn1$DERSequence;
        if (ms_classExtensions == null) {
            try {
                ms_classExtensions = ClassUtil.findSubclasses(ClassUtil.getClassStatic());
            }
            catch (Throwable throwable) {
                LogHolder.log(2, LogType.CRYPTO, throwable);
            }
            if (ms_classExtensions == null) {
                ms_classExtensions = new Vector();
            }
            if (ms_classExtensions.size() < AVAILABLE_EXTENSIONS.length) {
                int n = ClassUtil.isFindSubclassesEnabled() ? 2 : 5;
                LogHolder.log(n, LogType.CRYPTO, "X509 extension classes have not been loaded automatically!");
                for (int i = 0; i < AVAILABLE_EXTENSIONS.length; ++i) {
                    if (ms_classExtensions.contains(AVAILABLE_EXTENSIONS[i])) continue;
                    ms_classExtensions.addElement(AVAILABLE_EXTENSIONS[i]);
                }
            }
        }
        Enumeration enumeration = ms_classExtensions.elements();
        while (enumeration.hasMoreElements()) {
            Class clazz2 = (Class)enumeration.nextElement();
            try {
                if (!clazz2.getDeclaredField("IDENTIFIER").get(null).equals(dERObjectIdentifier.getId())) continue;
                return (AbstractX509Extension)clazz2.getConstructor(classArray).newInstance(objectArray);
            }
            catch (Exception exception) {
            }
        }
        return new X509UnknownExtension(dERSequence);
    }

    public abstract String getName();

    public final boolean isCritical() {
        return this.m_critical;
    }

    public final String getIdentifier() {
        return this.m_identifier.getId();
    }

    public final byte[] getDEROctets() {
        return this.m_value;
    }

    public final int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractX509Extension)) {
            return false;
        }
        return this.getIdentifier().equals(((AbstractX509Extension)object).getIdentifier());
    }

    public abstract Vector getValues();

    public final String toString() {
        return this.getName();
    }

    final DERSequence getBCExtension() {
        return this.m_extension;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

