/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.IMySignature;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.MyRSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;

public final class MyRSASignature
implements IMySignature {
    private static final AlgorithmIdentifier ms_identifier = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.5"));
    private PKCS1Encoding m_SignatureAlgorithm = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
    private Key m_initKey;
    private SHA1Digest m_Digest = new SHA1Digest();
    private static final AlgorithmIdentifier ms_AlgID = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, null);

    public synchronized void initVerify(IMyPublicKey iMyPublicKey) throws InvalidKeyException {
        this.m_SignatureAlgorithm.init(false, ((MyRSAPublicKey)iMyPublicKey).getParams());
        this.m_initKey = iMyPublicKey;
    }

    public synchronized void initSign(IMyPrivateKey iMyPrivateKey) throws InvalidKeyException {
        this.m_SignatureAlgorithm.init(true, ((MyRSAPrivateKey)iMyPrivateKey).getParams());
        this.m_initKey = iMyPrivateKey;
    }

    public synchronized boolean verify(byte[] byArray, byte[] byArray2) {
        return this.verify(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public synchronized boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        try {
            this.m_Digest.reset();
            this.m_Digest.update(byArray, n, n2);
            byte[] byArray3 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.doFinal(byArray3, 0);
            byte[] byArray4 = this.m_SignatureAlgorithm.processBlock(byArray2, n3, n4);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            DigestInfo digestInfo = new DigestInfo((ASN1Sequence)aSN1InputStream.readObject());
            if (!digestInfo.getAlgorithmId().getObjectId().equals((Object)ms_AlgID.getObjectId())) {
                return false;
            }
            DEREncodable dEREncodable = digestInfo.getAlgorithmId().getParameters();
            if (dEREncodable != null && !(dEREncodable instanceof ASN1Null)) {
                return false;
            }
            byte[] byArray5 = digestInfo.getDigest();
            if (byArray3.length != byArray5.length) {
                return false;
            }
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray5[i] == byArray3[i]) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            LogHolder.log(7, LogType.CRYPTO, "Signature algorithm does not match!");
            return false;
        }
    }

    public synchronized boolean verifyPlain(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = this.m_SignatureAlgorithm.processBlock(byArray2, 0, byArray2.length);
            if (byArray.length != byArray3.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray3[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized byte[] sign(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.reset();
            this.m_Digest.update(byArray, 0, byArray.length);
            this.m_Digest.doFinal(byArray2, 0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
            DigestInfo digestInfo = new DigestInfo(ms_AlgID, byArray2);
            dEROutputStream.writeObject((Object)digestInfo);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return this.m_SignatureAlgorithm.processBlock(byArray3, 0, byArray3.length);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public synchronized byte[] signPlain(byte[] byArray) {
        try {
            return this.m_SignatureAlgorithm.processBlock(byArray, 0, byArray.length);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public AlgorithmIdentifier getIdentifier() {
        return ms_identifier;
    }

    public byte[] encodeForXMLSignature(byte[] byArray) {
        return byArray;
    }

    public byte[] decodeForXMLSignature(byte[] byArray) {
        return byArray;
    }

    public String getXMLSignatureAlgorithmReference() {
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }
}

