/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.FECCodeFactory;
import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.MessageImplementation;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.util.ByteArrayUtil;
import logging.LogHolder;
import logging.LogType;

public class FragmentedMessage
extends MessageImplementation {
    static final int KEY_LEN = 16;
    static final int OVERHEAD = 0;
    static final int FRAGMENT_HEADER_LEN = 47;
    String[] m_recipient;
    byte[] m_payload;

    public FragmentedMessage(String[] stringArray, byte[] byArray) {
        this.m_payload = byArray;
        this.m_recipient = stringArray;
    }

    public byte[][] buildPayload() {
        this.m_payload = MixMinionCryptoUtil.compressData(this.m_payload);
        ExitInformation exitInformation = MMRDescription.getExitInformation(this.m_recipient, null);
        exitInformation.m_Content = this.m_recipient[0].getBytes();
        byte[] byArray = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(256L, 2), ByteArrayUtil.inttobyte(exitInformation.m_Content.length, 2), exitInformation.m_Content);
        this.m_payload = ByteArrayUtil.conc(byArray, this.m_payload);
        LogHolder.log(7, LogType.MISC, "[Message] Fragmented, new Compressed Size = " + this.m_payload.length);
        if (this.m_payload.length + 22 <= 28672) {
            throw new RuntimeException("Fragmented Header nach Neukomprimierung mit Single-Laenge");
        }
        this.m_payload = this.whiten(this.m_payload);
        byte[][] byArray2 = this.divideIntoFragments(this.m_payload);
        byte[] byArray3 = MixMinionCryptoUtil.randomArray(20);
        byte[] byArray4 = ByteArrayUtil.inttobyte(this.m_payload.length, 4);
        byte[][] byArray5 = new byte[byArray2.length][28672];
        for (int i = 0; i < byArray2.length; ++i) {
            byte[] byArray6 = byArray2[i];
            byte[] byArray7 = new byte[3];
            byArray7 = ByteArrayUtil.inttobyte(0x800000 + i, 3);
            byte[] byArray8 = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(byArray3, byArray4, byArray6));
            byArray5[i] = ByteArrayUtil.conc(byArray7, byArray8, byArray3, byArray4, byArray6);
        }
        return byArray5;
    }

    byte[][] divideIntoFragments(byte[] byArray) {
        Object object;
        int n;
        int n2 = 28625;
        double d = 1.3333333333333333;
        double d2 = Math.ceil((double)byArray.length / (double)n2);
        double d3 = Math.log(d2) / Math.log(2.0);
        d3 = Math.ceil(d3);
        d3 = Math.pow(2.0, d3);
        int n3 = (int)Math.min(16.0, d3);
        int n4 = (int)Math.ceil(d2 / (double)n3);
        byte[] byArray2 = MixMinionCryptoUtil.randomArray(16);
        int n5 = byArray.length - n4 * n2 * n3;
        System.out.println(n5);
        n5 = Math.abs(n5);
        byte[] byArray3 = MixMinionCryptoUtil.createPRNG(byArray2, n5);
        byArray = ByteArrayUtil.conc(byArray, byArray3);
        byte[][] byArray4 = new byte[n4][n2];
        for (n = 1; n <= n4; ++n) {
            object = ByteArrayUtil.copy(byArray, (n - 1) * n2 * n3, n2 * n3);
            byArray4[n - 1] = object;
        }
        n = (int)Math.ceil(d * (double)n3);
        System.out.println("   N,num " + n + " " + n4);
        object = new byte[n4 * n][28672];
        for (int i = 0; i <= n4 - 1; ++i) {
            for (int j = 0; j <= n - 1; ++j) {
                object[i * n + j] = (byte)this.FRAGMENT(byArray4[i], n3, n, j, n2);
            }
        }
        return object;
    }

    byte[] FRAGMENT(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[n2 * n6];
        byte[][] byArrayArray = new byte[n][];
        byte[][] byArrayArray2 = new byte[n2][];
        int[] nArray = new int[byArrayArray.length];
        int[] nArray2 = new int[byArrayArray2.length];
        for (n5 = 0; n5 < byArrayArray.length; ++n5) {
            byArrayArray[n5] = byArray2;
            nArray[n5] = n5 * n6;
        }
        for (n5 = 0; n5 < byArrayArray2.length; ++n5) {
            byArrayArray2[n5] = byArray3;
            nArray2[n5] = n5 * n6;
        }
        int[] nArray3 = new int[n2];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = i;
        }
        FECCode fECCode = FECCodeFactory.getDefault().createFECCode(n, n2);
        fECCode.encode(byArrayArray, nArray, byArrayArray2, nArray2, nArray3, n6);
        return ByteArrayUtil.copy(byArrayArray2[n3], nArray2[n3], n6);
    }

    private byte[] whiten(byte[] byArray) {
        byte[] byArray2 = new byte[]{87, 72, 73, 84, 69, 78};
        byte[] byArray3 = ByteArrayUtil.conc(byArray2, "WHITEN".getBytes());
        return MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(byArray3), byArray);
    }
}

