/*
Copyright (c) 2005, The JAP-Team
All rights reserved.
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

- Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

- Neither the name of the University of Technology Dresden, Germany nor the names of its contributors
 may be used to endorse or promote products derived from this software without specific
prior written permission.


THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
*/
package anon.mixminion;

import anon.AnonServerDescription;

/** Holder for the neseccary information to setup the Mixmion service.*/
public class MixminionServiceDescription implements AnonServerDescription
{
	private int m_iRouteLen;
	private String m_myEmail;

	/** Constucts a new MixminionServiceDescription object.
	 * @see #setRouteLen(int)
	 * @param routeLen number of hops for the anonymous mail
	 */

	public MixminionServiceDescription(int routeLen, String myEmail)
	{
		setRouteLen(routeLen);
		m_myEmail = myEmail;
	}

	public int getRouteLen()
	{
		return m_iRouteLen;
	}

	/** Sets the number of hops for the anonymous mail.
	 * @param routeLen number of hops for the anonymous mail. This number must be {@code <= Mixminion.MAX_ROUTE_LEN} and
	 * {@code >=Mixminion.MIN_ROUTE_LEN}
	 *
	 */
	public void setRouteLen(int routeLen)
	{
		if (routeLen >= Mixminion.MIN_ROUTE_LEN && routeLen <= Mixminion.MAX_ROUTE_LEN)
		{
			m_iRouteLen = routeLen;
		}
	}
	
	/**
	 * 
	 * @return the in the config specified address, if no one is specified the default value is ""
	 */
	public String getMyEmail() {
		return m_myEmail;
	}
	
}
