/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.util.IReturnRunnable;
import anon.util.ProgressCapsule;
import gui.GUIUtils;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class WorkerContentPane
extends DialogContentPane
implements DialogContentPane.IWizardSuitableNoWizardButtons {
    public static final String IMG_BUSY = "busy.gif";
    public static final String MSG_PLEASE_WAIT = (class$gui$dialog$WorkerContentPane == null ? (class$gui$dialog$WorkerContentPane = WorkerContentPane.class$("gui.dialog.WorkerContentPane")) : class$gui$dialog$WorkerContentPane).getName() + "_pleaseWait";
    public static final String DOTS = "...";
    private Thread m_workerThread;
    private Runnable m_workerRunnable;
    private Thread m_internalThread;
    private boolean m_bInterruptThreadSafe = true;
    private int m_iProgressStatus;
    static /* synthetic */ Class class$gui$dialog$WorkerContentPane;

    public WorkerContentPane(JAPDialog jAPDialog, String string, Runnable runnable) {
        this(jAPDialog, string, "", null, runnable);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, Runnable runnable, Observable observable) {
        this(jAPDialog, string, "", null, runnable, observable);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, String string2, Runnable runnable) {
        this(jAPDialog, string, string2, null, runnable);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, String string2, Runnable runnable, Observable observable) {
        this(jAPDialog, string, string2, null, runnable, observable);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, DialogContentPane dialogContentPane, Runnable runnable) {
        this(jAPDialog, string, "", dialogContentPane, runnable);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, DialogContentPane dialogContentPane, Runnable runnable, Observable observable) {
        this(jAPDialog, string, "", dialogContentPane, runnable, observable);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, String string2, DialogContentPane dialogContentPane, Runnable runnable) {
        this(jAPDialog, string, string2, dialogContentPane, runnable, null);
    }

    public WorkerContentPane(JAPDialog jAPDialog, String string, String string2, DialogContentPane dialogContentPane, Runnable runnable, final Observable observable) {
        super(jAPDialog, string, new DialogContentPane.Layout(string2), new DialogContentPaneOptions(-2147483647, dialogContentPane));
        this.setDefaultButtonOperation(2);
        this.m_workerRunnable = runnable;
        this.m_iProgressStatus = -1;
        this.addComponentListener(new WorkerComponentListener());
        this.getContentPane().setLayout(new BorderLayout());
        if (observable == null) {
            this.getContentPane().add((Component)new JLabel(GUIUtils.loadImageIcon(IMG_BUSY, true)), "Center");
        } else {
            final JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setBorderPainted(true);
            jProgressBar.setStringPainted(true);
            this.getContentPane().add((Component)jProgressBar, "Center");
            Observer observer = new Observer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void update(Observable observable2, Object object) {
                    if (object != null && object instanceof ProgressCapsule) {
                        ProgressCapsule progressCapsule = (ProgressCapsule)object;
                        int n = progressCapsule.getValue();
                        int n2 = progressCapsule.getMaximum();
                        int n3 = progressCapsule.getMinimum();
                        int n4 = progressCapsule.getStatus();
                        if (n4 == 1) {
                            JProgressBar jProgressBar2 = jProgressBar;
                            synchronized (jProgressBar2) {
                                if (jProgressBar.getMaximum() != n2) {
                                    jProgressBar.setMaximum(n2);
                                }
                                if (jProgressBar.getMinimum() != n3) {
                                    jProgressBar.setMinimum(n3);
                                }
                                jProgressBar.setValue(n);
                                jProgressBar.validate();
                            }
                        } else {
                            observable.deleteObserver(this);
                        }
                        WorkerContentPane.this.m_iProgressStatus = n4;
                    }
                }
            };
            observable.addObserver(observer);
        }
    }

    public final boolean isInterruptThreadSafe() {
        return this.m_bInterruptThreadSafe;
    }

    public final void setInterruptThreadSafe(boolean bl) {
        this.m_bInterruptThreadSafe = bl;
    }

    public final void joinThread() {
        try {
            if (this.m_workerThread != null) {
                this.m_workerThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isReady() {
        return true;
    }

    public boolean isSkippedAsPreviousContentPane() {
        return true;
    }

    public DialogContentPane.CheckError[] checkCancel() {
        this.interruptWorkerThread();
        return null;
    }

    public synchronized void dispose() {
        super.dispose();
        this.setInterruptThreadSafe(false);
        this.interruptWorkerThread();
        this.m_internalThread = null;
    }

    public int getProgressStatus() {
        return this.m_iProgressStatus;
    }

    public void interruptWorkerThread() {
        if (this.m_workerThread != null) {
            if (this.m_workerThread.isAlive() && !this.m_workerThread.isInterrupted()) {
                this.m_workerThread.interrupt();
            }
            if (this.isInterruptThreadSafe()) {
                this.joinThread();
            }
        }
    }

    public Object getValue() {
        if (this.m_workerRunnable instanceof IReturnRunnable && this.m_workerRunnable != null) {
            return ((IReturnRunnable)this.m_workerRunnable).getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WorkerComponentListener
    extends ComponentAdapter
    implements Runnable {
        private WorkerComponentListener() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (WorkerContentPane.this.isReady()) {
                WorkerContentPane.this.interruptWorkerThread();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (WorkerContentPane.this.m_workerRunnable == null) {
                WorkerContentPane.this.setButtonValue(0);
                WorkerContentPane.this.moveToNextContentPane();
                return;
            }
            if (WorkerContentPane.this.isVisible() && WorkerContentPane.this.isReady()) {
                WorkerContentPane.this.m_internalThread = new Thread((Runnable)this, "WorkerContentPane - componentShown()");
                WorkerContentPane.this.m_internalThread.setDaemon(true);
                WorkerContentPane.this.m_internalThread.start();
            }
        }

        public synchronized void run() {
            if (WorkerContentPane.this.m_workerRunnable == null) {
                WorkerContentPane.this.interruptWorkerThread();
                WorkerContentPane.this.setButtonValue(0);
                WorkerContentPane.this.moveToNextContentPane();
                return;
            }
            WorkerContentPane.this.setButtonValue(Integer.MIN_VALUE);
            WorkerContentPane.this.m_workerThread = new InternalThread(WorkerContentPane.this.m_workerRunnable);
            WorkerContentPane.this.m_workerThread.setPriority(1);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                WorkerContentPane.this.interruptWorkerThread();
                WorkerContentPane.this.m_workerThread = null;
                WorkerContentPane.this.moveToPreviousContentPane();
                this.notifyAll();
                return;
            }
            WorkerContentPane.this.m_workerThread.start();
            try {
                WorkerContentPane.this.m_workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                WorkerContentPane.this.interruptWorkerThread();
            }
            if (WorkerContentPane.this.m_workerThread.isInterrupted() || WorkerContentPane.this.getButtonValue() == 2 || WorkerContentPane.this.getButtonValue() == -1) {
                if (WorkerContentPane.this.getButtonValue() == Integer.MIN_VALUE) {
                    if ((WorkerContentPane.this.getDefaultButtonOperation() & 0x8002) > 0) {
                        WorkerContentPane.this.closeDialog(true);
                    } else if ((WorkerContentPane.this.getDefaultButtonOperation() & 0x1001) > 0) {
                        WorkerContentPane.this.closeDialog(false);
                    } else if ((WorkerContentPane.this.getDefaultButtonOperation() & 0x240) > 0) {
                        WorkerContentPane.this.moveToPreviousContentPane();
                    } else if ((WorkerContentPane.this.getDefaultButtonOperation() & 0x24) > 0) {
                        WorkerContentPane.this.moveToNextContentPane();
                    }
                }
            } else {
                WorkerContentPane.this.interruptWorkerThread();
                WorkerContentPane.this.setButtonValue(0);
                WorkerContentPane.this.moveToNextContentPane();
            }
            WorkerContentPane.this.m_workerThread = null;
            this.notifyAll();
        }
    }

    private class InternalThread
    extends Thread {
        private Runnable m_runnable;
        private boolean m_bInterrupted = false;

        public InternalThread(Runnable runnable) {
            super(runnable, "WorkerContentPane - InternalThread");
            this.m_runnable = runnable;
        }

        public void run() {
            this.m_runnable.run();
            this.m_bInterrupted = this.isInterrupted();
        }

        public boolean isInterrupted() {
            return super.isInterrupted() || this.m_bInterrupted;
        }
    }
}

