/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.Position;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private Document model;
    private transient Caret caret;
    private transient Highlighter highlighter;
    private transient Keymap keymap;
    private boolean opaque;
    private transient MutableCaretEvent caretEvent;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private Color disabledTextColor;
    private boolean editable;
    private Insets margin;
    private char focusAccelerator;
    private Action focusAction = new FocusAction();
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();
    private static Hashtable keymapTable = null;
    private JTextComponent editor;
    private static JTextComponent focusedComponent;
    public static final String DEFAULT_KEYMAP = "default";
    static final KeyBinding[] defaultBindings;
    static /* synthetic */ Class class$javax$swing$event$CaretListener;

    static {
        defaultBindings = new KeyBinding[]{new KeyBinding(KeyStroke.getKeyStroke(8, 0), "delete-previous"), new KeyBinding(KeyStroke.getKeyStroke(127, 0), "delete-next"), new KeyBinding(KeyStroke.getKeyStroke(39, 0), "caret-forward"), new KeyBinding(KeyStroke.getKeyStroke(37, 0), "caret-backward")};
        try {
            keymapTable = new Hashtable(17);
            Keymap keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
            DefaultEditorKit defaultEditorKit = new DefaultEditorKit();
            JTextComponent.loadKeymap(keymap, defaultBindings, ((EditorKit)defaultEditorKit).getActions());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            keymapTable = new Hashtable(17);
        }
    }

    public JTextComponent() {
        this.enableEvents(8L);
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.setEditable(true);
        this.setLayout(null);
        this.updateUI();
    }

    static /* synthetic */ JTextComponent access$1() {
        return focusedComponent;
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(class$javax$swing$event$CaretListener != null ? class$javax$swing$event$CaretListener : (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")), caretListener);
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            keymapTable.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void copy() {
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            int n = Math.min(this.caret.getDot(), this.caret.getMark());
            int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
            if (n != n2) {
                Document document = this.getDocument();
                String string = document.getText(n, n2 - n);
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, defaultClipboardOwner);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void cut() {
        if (this.isEditable() && this.isEnabled()) {
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (n != n2) {
                    Document document = this.getDocument();
                    String string = document.getText(n, n2 - n);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, defaultClipboardOwner);
                    document.remove(n, n2 - n);
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.getToolkit().beep();
        }
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CaretListener != null ? class$javax$swing$event$CaretListener : JTextComponent.class$("javax.swing.event.CaretListener"))) {
                ((CaretListener)objectArray[n + 1]).caretUpdate(caretEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextComponent();
        }
        return this.accessibleContext;
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public Caret getCaret() {
        return this.caret;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public Document getDocument() {
        return this.model;
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    static final JTextComponent getFocusedComponent() {
        return focusedComponent;
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public static Keymap getKeymap(String string) {
        return (Keymap)keymapTable.get(string);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public String getSelectedText() {
        int n;
        String string = null;
        int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
        if (n2 != (n = Math.max(this.caret.getDot(), this.caret.getMark()))) {
            try {
                Document document = this.getDocument();
                string = document.getText(n2, n - n2);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
        return string;
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public int getSelectionEnd() {
        int n = Math.max(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    int getSelectionEnd(Position.Bias[] biasArray) {
        DefaultCaret defaultCaret = (DefaultCaret)this.caret;
        if (defaultCaret.getDot() > defaultCaret.getMark()) {
            biasArray[0] = defaultCaret.getDotBias();
            return defaultCaret.getDot();
        }
        biasArray[0] = defaultCaret.getMarkBias();
        return defaultCaret.getMark();
    }

    public int getSelectionStart() {
        int n = Math.min(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    int getSelectionStart(Position.Bias[] biasArray) {
        DefaultCaret defaultCaret = (DefaultCaret)this.caret;
        if (defaultCaret.getDot() < defaultCaret.getMark()) {
            biasArray[0] = defaultCaret.getDotBias();
            return defaultCaret.getDot();
        }
        biasArray[0] = defaultCaret.getMarkBias();
        return defaultCaret.getMark();
    }

    public String getText() {
        String string;
        Document document = this.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.getDocument().getText(n, n2);
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Object object;
        Hashtable<String, Action> hashtable = new Hashtable<String, Action>();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            object = (String)action.getValue("Name");
            hashtable.put((String)(object != null ? object : ""), action);
            ++n;
        }
        int n2 = 0;
        while (n2 < keyBindingArray.length) {
            object = (Action)hashtable.get(keyBindingArray[n2].actionName);
            if (object != null) {
                keymap.addActionForKeyStroke(keyBindingArray[n2].key, (Action)object);
            }
            ++n2;
        }
    }

    private final boolean mapEventToAction(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        Action action;
        Keymap keymap = this.getKeymap();
        if (keymap != null && (action = keymap.getAction(keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent))) != null) {
            String string = null;
            if (keyEvent.getKeyChar() != '\u0000') {
                string = String.valueOf(keyEvent.getKeyChar());
            }
            ActionEvent actionEvent = new ActionEvent(this, 1001, string, keyEvent.getModifiers());
            action.actionPerformed(actionEvent);
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getUI().modelToView(this, n);
    }

    public void moveCaretPosition(int n) {
        this.caret.moveDot(n);
    }

    protected String paramString() {
        String string = this.opaque ? "true" : "false";
        String string2 = this.editable ? "true" : "false";
        String string3 = this.caretColor != null ? this.caretColor.toString() : "";
        String string4 = this.selectionColor != null ? this.selectionColor.toString() : "";
        String string5 = this.selectedTextColor != null ? this.selectedTextColor.toString() : "";
        String string6 = this.disabledTextColor != null ? this.disabledTextColor.toString() : "";
        String string7 = this.margin != null ? this.margin.toString() : "";
        return String.valueOf(super.paramString()) + ",caretColor=" + string3 + ",disabledTextColor=" + string6 + ",editable=" + string2 + ",margin=" + string7 + ",opaque=" + string + ",selectedTextColor=" + string5 + ",selectionColor=" + string4;
    }

    public void paste() {
        block2: {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) break block2;
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(string);
            }
            catch (Exception exception) {
                this.getToolkit().beep();
            }
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 400: {
                Action action;
                Keymap keymap;
                if (this.mapEventToAction(keyEvent) || (keymap = this.getKeymap()) == null || (action = keymap.getDefaultAction()) == null) break;
                ActionEvent actionEvent = new ActionEvent(this, 1001, String.valueOf(keyEvent.getKeyChar()), keyEvent.getModifiers());
                action.actionPerformed(actionEvent);
                keyEvent.consume();
                break;
            }
            case 401: {
                this.mapEventToAction(keyEvent);
                break;
            }
            case 402: {
                this.mapEventToAction(keyEvent);
                break;
            }
        }
    }

    public void read(Reader reader, Object object) throws IOException {
        EditorKit editorKit = this.getUI().getEditorKit(this);
        Document document = editorKit.createDefaultDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            editorKit.read(reader, document, 0);
            this.setDocument(document);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(class$javax$swing$event$CaretListener != null ? class$javax$swing$event$CaretListener : (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")), caretListener);
    }

    public static Keymap removeKeymap(String string) {
        return (Keymap)keymapTable.remove(string);
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public void replaceSelection(String string) {
        block4: {
            Document document = this.getDocument();
            if (document == null) break block4;
            try {
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
            }
        }
    }

    public void select(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.getDocument().getLength()) {
            n2 = this.getDocument().getLength();
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n > n2) {
            n = n2;
        }
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(document.getLength());
        }
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.removeChangeListener(this.caretEvent);
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
            this.caret.addChangeListener(this.caretEvent);
        }
        this.firePropertyChange("caret", caret2, this.caret);
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public void setCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            if (n > document.getLength() || n < 0) {
                throw new IllegalArgumentException("bad position: " + n);
            }
            this.caret.setDot(n);
        }
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, this.disabledTextColor);
    }

    public void setDocument(Document document) {
        if (this.accessibleContext != null) {
            this.model.removeDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
        Document document2 = this.model;
        this.model = document;
        this.firePropertyChange("document", document2, document);
        this.revalidate();
        this.repaint();
        if (this.accessibleContext != null) {
            this.model.addDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
    }

    public void setEditable(boolean bl) {
        if (bl != this.editable) {
            boolean bl2 = this.editable;
            this.editable = bl;
            this.firePropertyChange("editable", new Boolean(bl2), new Boolean(this.editable));
            this.repaint();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void setFocusAccelerator(char c) {
        c = Character.toUpperCase(c);
        KeyStroke[] keyStrokeArray = this.getRegisteredKeyStrokes();
        int n = 0;
        int n2 = keyStrokeArray.length;
        while (n < n2) {
            if (this.getActionForKeyStroke(keyStrokeArray[n]) == this.focusAction) {
                if (keyStrokeArray[n].getKeyChar() == c) {
                    return;
                }
                this.unregisterKeyboardAction(keyStrokeArray[n]);
                break;
            }
            ++n;
        }
        if (c != '\u0000') {
            this.registerKeyboardAction(this.focusAction, KeyStroke.getKeyStroke((int)c, 8), 2);
        }
        char c2 = this.focusAccelerator;
        this.focusAccelerator = c;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c2, this.focusAccelerator);
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            this.getToolkit().beep();
        }
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        this.invalidate();
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public void write(Writer writer) throws IOException {
        Document document = this.getDocument();
        try {
            this.getUI().getEditorKit(this).write(writer, document, 0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener {
        int caretPos;

        public AccessibleJTextComponent() {
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
            }
            JTextComponent.this.addCaretListener(this);
            this.caretPos = this.getCaretPosition();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            if (this.caretPos != n) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretPos), new Integer(n));
                this.caretPos = n;
            }
            if (n2 != n) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Caret caret = JTextComponent.this.getCaret();
            Integer n = new Integer(caret.getDot());
            this.firePropertyChange("AccessibleText", null, n);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public String getAfterIndex(int n, int n2) {
            if (n2 < 0 || n2 >= JTextComponent.this.model.getLength()) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 + 1 >= JTextComponent.this.model.getLength()) {
                        return null;
                    }
                    try {
                        return JTextComponent.this.model.getText(n2 + 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        if (n3 == -1 || n3 >= string.length()) {
                            return null;
                        }
                        int n4 = breakIterator.following(n3);
                        if (n4 == -1 || n4 >= string.length()) {
                            return null;
                        }
                        return string.substring(n3, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n5 = breakIterator.following(n2);
                        if (n5 == -1 || n5 >= string.length()) {
                            return null;
                        }
                        int n6 = breakIterator.following(n5);
                        if (n6 == -1 || n6 >= string.length()) {
                            return null;
                        }
                        return string.substring(n5, n6);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getAtIndex(int n, int n2) {
            if (n2 < 0 || n2 >= JTextComponent.this.model.getLength()) {
                return null;
            }
            switch (n) {
                case 1: {
                    try {
                        return JTextComponent.this.model.getText(n2, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        return string.substring(breakIterator.previous(), n3);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n2);
                        return string.substring(breakIterator.previous(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getBeforeIndex(int n, int n2) {
            if (n2 < 0 || n2 > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 == 0) {
                        return null;
                    }
                    try {
                        return JTextComponent.this.model.getText(n2 - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        n3 = breakIterator.previous();
                        int n4 = breakIterator.previous();
                        if (n4 == -1) {
                            return null;
                        }
                        return string.substring(n4, n3);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n5 = breakIterator.following(n2);
                        n5 = breakIterator.previous();
                        int n6 = breakIterator.previous();
                        if (n6 == -1) {
                            return null;
                        }
                        return string.substring(n6, n5);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        public int getCharCount() {
            return JTextComponent.this.model.getLength();
        }

        public AttributeSet getCharacterAttribute(int n) {
            Element element = null;
            element = JTextComponent.this.model.getDefaultRootElement();
            while (!element.isLeaf()) {
                int n2 = element.getElementIndex(n);
                element = element.getElement(n2);
            }
            return element.getAttributes();
        }

        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle;
            if (n < 0 || n > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            try {
                rectangle = JTextComponent.this.modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            return rectangle;
        }

        public int getIndexAtPoint(Point point) {
            if (point == null) {
                return -1;
            }
            return JTextComponent.this.viewToModel(point);
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public int getSelectionStart() {
            return JTextComponent.this.getSelectionStart();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Caret caret = JTextComponent.this.getCaret();
            Integer n = new Integer(caret.getDot());
            this.firePropertyChange("AccessibleText", null, n);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Caret caret = JTextComponent.this.getCaret();
            Integer n = new Integer(caret.getDot());
            this.firePropertyChange("AccessibleText", null, n);
        }
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            Object object;
            if (action == null) {
                return null;
            }
            Object[] objectArray = null;
            Vector vector = null;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (this.bindings.get(object) != action) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(object);
            }
            if (this.parent != null && (object = this.parent.getKeyStrokesForAction(action)) != null) {
                int n = 0;
                int n2 = ((K)object).length - 1;
                while (n2 >= 0) {
                    if (this.isLocallyDefined((KeyStroke)object[n2])) {
                        object[n2] = null;
                        ++n;
                    }
                    --n2;
                }
                if (n > 0 && n < ((K)object).length) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    int n3 = ((K)object).length - 1;
                    while (n3 >= 0) {
                        if (object[n3] != null) {
                            vector.addElement(object[n3]);
                        }
                        --n3;
                    }
                } else if (n == 0) {
                    if (vector == null) {
                        objectArray = object;
                    } else {
                        objectArray = new KeyStroke[vector.size() + ((K)object).length];
                        vector.copyInto(objectArray);
                        System.arraycopy(object, 0, objectArray, vector.size(), ((K)object).length);
                        vector = null;
                    }
                }
            }
            if (vector != null) {
                objectArray = new KeyStroke[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }

        public String getName() {
            return this.nm;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    MouseListener,
    FocusListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        MutableCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        final void fire() {
            JTextComponent jTextComponent = (JTextComponent)this.getSource();
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                jTextComponent.fireCaretUpdate(this);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            focusedComponent = (JTextComponent)this.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.dragActive = true;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.dragActive = false;
            this.fire();
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        public final String toString() {
            return "dot=" + this.dot + "," + "mark=" + this.mark;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent.this.requestFocus();
        }

        public boolean isEnabled() {
            return JTextComponent.this.isEditable();
        }
    }
}

